/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.service;

import com.agilemind.commons.application.controllers.ApplicationControllerImpl;
import com.agilemind.commons.application.controllers.ProjectsTabController;
import com.agilemind.commons.application.data.Project;
import com.agilemind.commons.application.gui.util.ProjectLocationInfo;
import com.agilemind.commons.application.modules.commands.operations.ScheduledOperation;
import com.agilemind.commons.application.modules.concurrent.util.operations.logger.OperationResultInfoTransient;
import com.agilemind.commons.application.modules.report.controllers.ReportProjectPanelController;
import com.agilemind.commons.application.modules.scheduler.data.IScheduledTaskSettings;
import com.agilemind.commons.application.service.ScheduledTasksService;
import com.agilemind.commons.application.service.TaskManagerSchedulerOperation;
import com.agilemind.commons.modules.concurrent.util.operations.Operation;
import com.agilemind.commons.util.ThreadSafeUtil;
import java.io.IOException;
import java.util.Date;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerSchedulerConsumer<P extends Project, T extends Operation>
implements Consumer<TaskManagerSchedulerOperation<P, T>> {
    private static final Logger a = LoggerFactory.getLogger(TaskManagerSchedulerConsumer.class);
    private final ApplicationControllerImpl<P> b;
    private ScheduledTasksService c;
    private IScheduledTaskSettings d;
    private final ProjectLocationInfo e;
    private final Function<P, Consumer<T>> f;

    public TaskManagerSchedulerConsumer(ApplicationControllerImpl<P> applicationControllerImpl, ScheduledTasksService scheduledTasksService, IScheduledTaskSettings iScheduledTaskSettings, ProjectLocationInfo projectLocationInfo, Function<P, Consumer<T>> function) {
        this.b = applicationControllerImpl;
        this.c = scheduledTasksService;
        this.d = iScheduledTaskSettings;
        this.e = projectLocationInfo;
        this.f = function;
    }

    @Override
    public void accept(TaskManagerSchedulerOperation<P, T> taskManagerSchedulerOperation) {
        ThreadSafeUtil.runInDispatchThread(() -> {
            this.a(taskManagerSchedulerOperation);
            this.b(taskManagerSchedulerOperation);
        });
    }

    private void a(TaskManagerSchedulerOperation<P, T> taskManagerSchedulerOperation) {
        this.c.setFinishTime(this.d.getId(), this.e, new Date());
        this.c.setState(this.d.getId(), this.e, ScheduledOperation.getScheduledOperationState(taskManagerSchedulerOperation.getOperationState()));
        try {
            ScheduledOperation.removeOldLog(this.e, this.d);
            ScheduledOperation.saveLog(this.c, this.d, this.e, new OperationResultInfoTransient((Operation)taskManagerSchedulerOperation));
        }
        catch (IOException iOException) {
            a.error("", (Throwable)iOException);
        }
    }

    private void b(TaskManagerSchedulerOperation<P, T> taskManagerSchedulerOperation) {
        taskManagerSchedulerOperation.getRootOperation().ifPresent(operation -> {
            Project project;
            ProjectsTabController<ReportProjectPanelController<?, P>, P> projectsTabController = this.b.getProjectsTab();
            ReportProjectPanelController<?, P> reportProjectPanelController = projectsTabController.getTab(this.e.getLocation());
            Project project2 = project = reportProjectPanelController != null ? (Project)reportProjectPanelController.getProject() : null;
            if (project != null) {
                this.f.apply(project).accept((Operation)operation);
            }
        });
    }
}

