/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.taskmanager.component;

import com.agilemind.commons.application.taskmanager.component.historycard.HistoryCardComponent;
import com.agilemind.commons.application.taskmanager.component.historygroup.HistoryGroupComponent;
import com.agilemind.commons.application.taskmanager.component.historygroupcontainer.TaskHistoryGroupContainerComponent;
import com.agilemind.commons.application.taskmanager.data.TaskHistoryGroupType;
import com.agilemind.commons.application.taskmanager.data.TaskResultItem;
import com.agilemind.commons.mvc.controllers.Controller;
import com.agilemind.commons.util.ThreadSafeUtil;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class TaskHistoryResultManager {
    private final HistoryCardComponentFactory a;
    private final TaskHistoryGroupContainerComponent b;
    private final Consumer<TaskResultItem> c;
    private Map<HistoryCardComponent, HistoryGroupComponent> d;
    private Map<Long, HistoryCardComponent> e;
    public static boolean f;

    public TaskHistoryResultManager(HistoryCardComponentFactory historyCardComponentFactory, TaskHistoryGroupContainerComponent taskHistoryGroupContainerComponent, Consumer<TaskResultItem> consumer) {
        boolean bl2 = f;
        this.d = new HashMap<HistoryCardComponent, HistoryGroupComponent>();
        this.e = new WeakHashMap<Long, HistoryCardComponent>();
        this.a = historyCardComponentFactory;
        this.b = taskHistoryGroupContainerComponent;
        taskHistoryGroupContainerComponent.enableEmptyView(true);
        this.c = consumer;
        if (bl2) {
            Controller.g = !Controller.g;
        }
    }

    public void addItem(TaskResultItem taskResultItem) {
        ThreadSafeUtil.runInDispatchThread(() -> {
            HistoryCardComponent historyCardComponent = this.a.create(taskResultItem);
            this.a(historyCardComponent);
            this.a(historyCardComponent, this.c(historyCardComponent));
        });
    }

    public void setItems(Collection<TaskResultItem> collection) {
        this.clearAll();
        if (!collection.isEmpty()) {
            this.a(collection);
            this.b.enableEmptyView(false);
        }
    }

    public void invalidateInSwing() {
        ThreadSafeUtil.runInDispatchThread(this::c);
    }

    public void clearAll() {
        boolean bl2 = f;
        this.d.clear();
        this.b.clearAll();
        this.b.enableEmptyView(true);
        if (Controller.g) {
            f = !bl2;
        }
    }

    private void c() {
        boolean bl2 = f;
        for (Map.Entry<HistoryCardComponent, HistoryGroupComponent> entry : this.d.entrySet()) {
            HistoryCardComponent historyCardComponent2 = entry.getKey();
            historyCardComponent2.updateFinishTime();
            if (!bl2) continue;
        }
        this.d.keySet().stream().sorted().forEach(historyCardComponent -> {
            TaskHistoryGroupType taskHistoryGroupType = this.c((HistoryCardComponent)historyCardComponent);
            HistoryGroupComponent historyGroupComponent = this.d.get(historyCardComponent);
            if (!historyGroupComponent.isType(taskHistoryGroupType)) {
                historyGroupComponent.removeCard((HistoryCardComponent)historyCardComponent);
                this.a((HistoryCardComponent)historyCardComponent, taskHistoryGroupType);
            }
        });
    }

    private void a(HistoryCardComponent historyCardComponent) {
        historyCardComponent.setCloseAction(() -> ThreadSafeUtil.runInDispatchThread(() -> {
            this.b(historyCardComponent);
            this.c.accept(historyCardComponent.getItem());
        }));
    }

    private void a(HistoryCardComponent historyCardComponent, TaskHistoryGroupType taskHistoryGroupType) {
        HistoryGroupComponent historyGroupComponent = this.b.getGroup(taskHistoryGroupType);
        ThreadSafeUtil.runInDispatchThread(() -> {
            historyGroupComponent.addCard(historyCardComponent);
            this.b.enableEmptyView(false);
        });
        this.d.put(historyCardComponent, historyGroupComponent);
    }

    private void b(HistoryCardComponent historyCardComponent) {
        HistoryGroupComponent historyGroupComponent = this.d.get(historyCardComponent);
        ThreadSafeUtil.runInDispatchThread(() -> {
            historyGroupComponent.removeCard(historyCardComponent);
            this.b.invalidateGroups();
        });
        this.d.remove(historyCardComponent);
    }

    private void a(Collection<TaskResultItem> collection) {
        collection.stream().map(this.a::create).peek(historyCardComponent -> this.e.put(historyCardComponent.getItem().getId(), (HistoryCardComponent)historyCardComponent)).collect(Collectors.groupingBy(this::c)).entrySet().forEach(entry -> {
            HistoryGroupComponent historyGroupComponent = this.b.getGroup((TaskHistoryGroupType)((Object)((Object)entry.getKey())));
            ((List)entry.getValue()).forEach(historyCardComponent -> {
                this.a((HistoryCardComponent)historyCardComponent);
                this.d.put((HistoryCardComponent)historyCardComponent, historyGroupComponent);
            });
            ThreadSafeUtil.runInDispatchThread(() -> historyGroupComponent.addAllCard((List)entry.getValue()));
        });
    }

    private TaskHistoryGroupType c(HistoryCardComponent historyCardComponent) {
        LocalDateTime localDateTime;
        LocalDateTime localDateTime2 = historyCardComponent.getItem().getFinishTime();
        Duration duration = Duration.between(localDateTime2, localDateTime = LocalDateTime.now());
        if (duration.toDays() >= 3L) {
            return TaskHistoryGroupType.THREE_DAYS_AGO;
        }
        if (duration.toDays() >= 1L) {
            return TaskHistoryGroupType.ONE_DAY_AGO;
        }
        if (duration.toHours() >= 4L) {
            return TaskHistoryGroupType.FOUR_HOURS_AGO;
        }
        if (duration.toHours() >= 1L) {
            return TaskHistoryGroupType.ONE_HOUR_AGO;
        }
        return TaskHistoryGroupType.RECENTLY;
    }

    public void showHistory(Long l2) {
        HistoryCardComponent historyCardComponent = this.e.get(l2);
        if (historyCardComponent != null) {
            historyCardComponent.getView().scrollRectToVisible(historyCardComponent.getView().getBounds());
        }
    }

    @FunctionalInterface
    public static interface HistoryGroupComponentFactory {
        public HistoryGroupComponent create(TaskHistoryGroupType var1);
    }

    @FunctionalInterface
    public static interface HistoryCardComponentFactory {
        public HistoryCardComponent create(TaskResultItem var1);
    }
}

