/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.taskmanager.util;

import com.agilemind.commons.application.controllers.ApplicationControllerImpl;
import com.agilemind.commons.application.gui.util.ProjectLocationInfo;
import com.agilemind.commons.application.modules.notifmanager.Notification;
import com.agilemind.commons.application.modules.notifmanager.impl.SchedulerPreRunNotification;
import com.agilemind.commons.application.modules.scheduler.data.IScheduledTaskSettings;
import com.agilemind.commons.application.modules.scheduler.util.ScheduledTaskDateUtil;
import com.agilemind.commons.application.taskmanager.data.TaskResultItem;
import com.agilemind.commons.application.taskmanager.data.TaskType;
import com.agilemind.commons.application.taskmanager.util.CommonsTaskTitleFactory;
import com.agilemind.commons.application.taskmanager.util.ITaskNotificationFactory;
import com.agilemind.commons.application.taskmanager.util.ITaskResultCardsViewFactory;
import com.agilemind.commons.application.taskmanager.view.TaskAddedNotification;
import com.agilemind.commons.application.taskmanager.view.TaskRemovedNotification;
import com.agilemind.commons.localization.stringkey.CommonsStringKey;
import com.agilemind.commons.localization.stringkey.StringKey;
import com.agilemind.commons.localization.stringkey.StringKeyStorage;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.ThreadSafeUtil;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTaskNotificationFactory
implements ITaskNotificationFactory {
    private final ApplicationControllerImpl a;
    private final ITaskResultCardsViewFactory b;
    private static final String[] c;

    public AbstractTaskNotificationFactory(ApplicationControllerImpl applicationControllerImpl, ITaskResultCardsViewFactory iTaskResultCardsViewFactory) {
        this.a = applicationControllerImpl;
        this.b = iTaskResultCardsViewFactory;
    }

    @Override
    public Notification createAddNotification(TaskType taskType, String string) {
        return new TaskAddedNotification(false, this.createOneTaskAddedText(taskType, string));
    }

    @Override
    public Notification createAddNotification(TaskType taskType, Collection<String> collection) {
        switch (collection.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.createAddNotification(taskType, (String)Iterables.get(collection, (int)0));
            }
        }
        return new TaskAddedNotification(false, this.createManyTaskAddedText(taskType, collection.size()));
    }

    @Override
    public Notification createSchedulerNotification(IScheduledTaskSettings iScheduledTaskSettings) {
        List<String> list = iScheduledTaskSettings.getProjectFiles().stream().map(ProjectLocationInfo::getProjectName).collect(Collectors.toList());
        return new TaskAddedNotification(true, this.a(iScheduledTaskSettings.getName(), list));
    }

    @Override
    public Notification createPreRunSchedulerNotification(IScheduledTaskSettings iScheduledTaskSettings) {
        List<String> list = iScheduledTaskSettings.getProjectFiles().stream().map(ProjectLocationInfo::getProjectName).collect(Collectors.toList());
        return new SchedulerPreRunNotification(ScheduledTaskDateUtil.getNextRun(iScheduledTaskSettings, new Date()), this.b(iScheduledTaskSettings.getName(), list), () -> ThreadSafeUtil.runInDispatchThread(this.a::configureScheduler));
    }

    @Override
    public Notification createRemoveNotification(TaskResultItem taskResultItem) {
        return new TaskRemovedNotification(this.b.createHistoryCard(taskResultItem), () -> ThreadSafeUtil.runInDispatchThread(() -> this.a.showHistoryComp(taskResultItem.getId())));
    }

    protected abstract StringKey createOneTaskAddedText(TaskType var1, String var2);

    private StringKey a(String string, Collection<String> collection) {
        CommonsStringKey commonsStringKey;
        StringKeyStorage.FixedMap fixedMap = new StringKeyStorage.FixedMap();
        switch (collection.size()) {
            case 0: {
                return null;
            }
            case 1: {
                fixedMap.addValue(c[7], c[0] + StringUtil.CutUtil.cutName((String)((String)Iterables.get(collection, (int)0)), (int)80) + c[5]);
                commonsStringKey = new CommonsStringKey(c[4]);
                if (!CommonsTaskTitleFactory.c) break;
            }
            default: {
                fixedMap.addValue(c[6], c[1] + collection.size() + c[2]);
                commonsStringKey = new CommonsStringKey(c[8]);
            }
        }
        fixedMap.addValue(c[3], StringUtil.CutUtil.cutName((String)string, (int)80));
        return commonsStringKey.createExtension((StringKeyStorage)fixedMap);
    }

    @NotNull
    private StringKey b(String string, Collection<String> collection) {
        CommonsStringKey commonsStringKey;
        StringKeyStorage.FixedMap fixedMap = new StringKeyStorage.FixedMap();
        switch (collection.size()) {
            case 0: {
                return null;
            }
            case 1: {
                fixedMap.addValue(c[14], c[15] + StringUtil.CutUtil.cutName((String)((String)Iterables.get(collection, (int)0)), (int)80) + c[10]);
                commonsStringKey = new CommonsStringKey(c[17]);
                if (!CommonsTaskTitleFactory.c) break;
            }
            default: {
                fixedMap.addValue(c[16], c[13] + collection.size() + c[11]);
                commonsStringKey = new CommonsStringKey(c[9]);
            }
        }
        fixedMap.addValue(c[12], StringUtil.CutUtil.cutName((String)string, (int)80));
        return commonsStringKey.createExtension((StringKeyStorage)fixedMap);
    }

    protected abstract StringKey createManyTaskAddedText(TaskType var1, int var2);

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[18];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "4BQ";
        int n3 = -1;
        block25: while (true) {
            char[] cArray;
            block30: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block29: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block29;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block30;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 8;
                                break;
                            }
                            case 1: {
                                n9 = 32;
                                break;
                            }
                            case 2: {
                                n9 = 111;
                                break;
                            }
                            case 3: {
                                n9 = 9;
                                break;
                            }
                            default: {
                                n9 = 118;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "4BQ";
                    n3 = 0;
                    continue block25;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "4\u000f\r7";
                    n3 = 1;
                    continue block25;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "WS\fa\u0013lU\u0003l\u0004\\A\u001cb";
                    n3 = 2;
                    continue block25;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "fO\u001b`\u0010aC\u000e}\u001fgNAh\u0012lt\u000ez\u001d&O\u0001lX{C\u0007l\u0012}L\n{";
                    n3 = 3;
                    continue block25;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "4\u000f\r7";
                    n3 = 4;
                    continue block25;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "WP\u001df\u001cmC\u001bJ\u0019}N\u001b";
                    n3 = 5;
                    continue block25;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "WP\u001df\u001cmC\u001bG\u0017eE";
                    n3 = 6;
                    continue block25;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "fO\u001b`\u0010aC\u000e}\u001fgNAh\u0012lt\u000ez\u001d&M\u000eg\u000f&S\fa\u0013lU\u0003l\u0004";
                    n3 = 7;
                    continue block25;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "fO\u001b`\u0010aC\u000e}\u001fgNAh\u0012lt\u000ez\u001d&M\u000eg\u000f&S\fa\u0013lU\u0003l\u0004&P\u001dl$}N";
                    n3 = 8;
                    continue block25;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "4\u000f\r7";
                    n3 = 9;
                    continue block25;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "4\u000f\r7";
                    n3 = 10;
                    continue block25;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "WS\fa\u0013lU\u0003l\u0004\\A\u001cb";
                    n3 = 11;
                    continue block25;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "4BOj\u001aiS\u001c4\u0011zE\ng)kLQ";
                    n3 = 12;
                    continue block25;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "WP\u001df\u001cmC\u001bG\u0017eE";
                    n3 = 13;
                    continue block25;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "4BOj\u001aiS\u001c4\u0011zE\ng)kLQ";
                    n3 = 14;
                    continue block25;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "WP\u001df\u001cmC\u001bJ\u0019}N\u001b";
                    n3 = 15;
                    continue block25;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "fO\u001b`\u0010aC\u000e}\u001fgNAh\u0012lt\u000ez\u001d&O\u0001lX{C\u0007l\u0012}L\n{XxR\n[\u0003f";
                    n3 = 16;
                    continue block25;
                }
                case 16: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        c = stringArray3;
    }
}

