/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.taskmanager.util;

import com.agilemind.commons.application.controllers.ApplicationControllerImpl;
import com.agilemind.commons.application.modules.io.proxy.util.CheckInternetConnectionOperation;
import com.agilemind.commons.application.modules.io.proxy.util.NoInternetConnectionException;
import com.agilemind.commons.application.modules.license.LicenseType;
import com.agilemind.commons.application.modules.license.analytics.CampaignTerm;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.DropboxException;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.DropboxFileNotFoundException;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.StorageQuotaReachedException;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.WrongAuthorizationException;
import com.agilemind.commons.application.modules.storage.spscloud.client.account.exceptions.AccountNotFoundException;
import com.agilemind.commons.application.modules.storage.spscloud.client.exceptions.ServerErrorException;
import com.agilemind.commons.application.modules.storage.spscloud.client.exceptions.TokenErrorException;
import com.agilemind.commons.application.modules.storage.spscloud.client.projects.exceptions.ProjectNotFoundException;
import com.agilemind.commons.application.modules.storage.spscloud.client.reports.exceptions.LimitReachedException;
import com.agilemind.commons.application.taskmanager.component.historycard.IActionComponent;
import com.agilemind.commons.application.taskmanager.data.OperationResultItem;
import com.agilemind.commons.application.taskmanager.data.ScheduledTaskInfo;
import com.agilemind.commons.application.taskmanager.data.TaskResultItem;
import com.agilemind.commons.application.taskmanager.data.TaskResultStatus;
import com.agilemind.commons.application.taskmanager.data.TaskType;
import com.agilemind.commons.application.taskmanager.data.TypedTask;
import com.agilemind.commons.application.taskmanager.util.CommonsTaskTitleFactory;
import com.agilemind.commons.application.taskmanager.util.ITaskResultFactory;
import com.agilemind.commons.application.taskmanager.util.e;
import com.agilemind.commons.application.util.ApplicationLivePlanInfoProvider;
import com.agilemind.commons.application.util.ProjectCorruptException;
import com.agilemind.commons.application.util.settings.ApplicationParametersImpl;
import com.agilemind.commons.io.pagereader.SearchEngineUtils;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngineKnowledgeBaseDataModel;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngineList;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngineParserBrokenException;
import com.agilemind.commons.io.searchengine.searchengines.type.SearchEngineType;
import com.agilemind.commons.modules.concurrent.util.OperationStatistic;
import com.agilemind.commons.modules.concurrent.util.operations.CompositeOperation;
import com.agilemind.commons.modules.concurrent.util.operations.Operation;
import com.agilemind.commons.modules.concurrent.util.operations.OperationState;
import com.agilemind.commons.modules.taskmanager.TaskFailedStatus;
import com.agilemind.commons.modules.taskmanager.TaskManager;
import com.agilemind.commons.modules.taskmanager.listener.TaskAddedListener;
import com.agilemind.commons.modules.taskmanager.listener.TaskRemovedListener;
import com.agilemind.commons.mvc.controllers.Controller;
import com.agilemind.commons.util.StringUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class CommonTaskResultFactory
implements ITaskResultFactory {
    protected final ApplicationControllerImpl applicationController;
    private AtomicLong a;
    private Map<Class<? extends Throwable>, TaskFailedStatus> b;
    protected static final String LIMIT_EXCEEDED_URL;
    protected static final String LIMIT_EXCEEDED_TEXT;
    private static final String[] d;

    public CommonTaskResultFactory(ApplicationControllerImpl applicationControllerImpl) {
        boolean bl2 = CommonsTaskTitleFactory.c;
        this.a = new AtomicLong();
        this.b = new HashMap<Class<? extends Throwable>, TaskFailedStatus>();
        this.applicationController = applicationControllerImpl;
        this.b.put(NoInternetConnectionException.class, TaskFailedStatus.NO_INTERNET_CONNECTION);
        this.b.put(ProjectNotFoundException.class, TaskFailedStatus.PROJECT_NOT_FOUND);
        this.b.put(DropboxFileNotFoundException.class, TaskFailedStatus.PROJECT_NOT_FOUND);
        this.b.put(ProjectCorruptException.class, TaskFailedStatus.PROJECT_FILE_CORRUPTED);
        this.b.put(WrongAuthorizationException.class, TaskFailedStatus.WRONG_AUTHORIZATION);
        this.b.put(StorageQuotaReachedException.class, TaskFailedStatus.QUOTA_REACHED);
        this.b.put(DropboxException.class, TaskFailedStatus.DROPBOX_ERROR);
        this.b.put(ServerErrorException.class, TaskFailedStatus.SPS_SERVER_ERROR);
        this.b.put(AccountNotFoundException.class, TaskFailedStatus.SPS_NO_ACCOUNT);
        this.b.put(TokenErrorException.class, TaskFailedStatus.SPS_TOKEN_ERROR);
        this.b.put(LimitReachedException.class, TaskFailedStatus.SPS_LIMIT_REACHED);
        if (Controller.g) {
            CommonsTaskTitleFactory.c = !bl2;
        }
    }

    @Override
    public TaskResultItem create(TypedTask typedTask) {
        boolean bl2 = CommonsTaskTitleFactory.c;
        TaskResultItem taskResultItem = this.createTaskResultItem(typedTask);
        CompositeOperation compositeOperation = (CompositeOperation)typedTask.getOperation();
        ArrayList<OperationResultItem> arrayList = new ArrayList<OperationResultItem>(compositeOperation.getAllOperations().size());
        for (Operation operation : compositeOperation.getSubOperations()) {
            this.a(arrayList, operation, compositeOperation);
            if (!bl2) continue;
            break;
        }
        arrayList.forEach(taskResultItem::addSubTaskInfo);
        return taskResultItem;
    }

    private void a(List<OperationResultItem> list, Operation operation, CompositeOperation compositeOperation) {
        block4: {
            block3: {
                boolean bl2 = CommonsTaskTitleFactory.c;
                if (!operation.isComposite()) break block3;
                for (Operation operation2 : ((CompositeOperation)operation).getSubOperations()) {
                    this.a(list, operation2, (CompositeOperation)operation);
                    if (!bl2) continue;
                }
                if (!bl2) break block4;
            }
            list.add(this.a(operation, (Operation)compositeOperation));
        }
    }

    @NotNull
    protected TaskResultStatus getOKTaskResultStatus(TypedTask typedTask, TaskFailedStatus taskFailedStatus) {
        if (taskFailedStatus != TaskFailedStatus.WITHOUT_EXCEPTION) {
            return TaskResultStatus.DONE_WITH_ERRORS;
        }
        return TaskResultStatus.SUCCESS;
    }

    private OperationResultItem a(Operation operation, Operation operation2) {
        return new OperationResultItem(operation.getOperationState(), operation.getPrevName(operation2) + '\\' + operation.getName(), operation.getOperationStatus(), StringUtil.stackTraceToString((Throwable)operation.getException()), operation.getOperationTime() == 0L ? LocalDateTime.now() : LocalDateTime.ofInstant(new Date(operation.getStartTime() + operation.getOperationTime()).toInstant(), ZoneId.systemDefault()), operation.getClass());
    }

    protected void putAdditionalData(TypedTask typedTask, TaskResultItem taskResultItem) {
        if (taskResultItem.getTaskFailedStatus() == TaskFailedStatus.LICENSE_BROKEN_SE) {
            taskResultItem.putAdditionalItem(d[1], new ArrayList<String>(this.i()));
            taskResultItem.putAdditionalItem(d[0], this.applicationController.getLicenseType().getLivePlanUpgradeStringKeySet(new ApplicationLivePlanInfoProvider(this.applicationController, CampaignTerm.EXPIRED_CHECK_DIALOG), LicenseType.RENEW_STRING_KEY));
        }
    }

    @NotNull
    protected TaskResultItem createTaskResultItem(TypedTask typedTask) {
        TaskFailedStatus taskFailedStatus;
        TaskResultStatus taskResultStatus;
        CompositeOperation compositeOperation;
        block6: {
            block5: {
                assert (typedTask.getOperation() instanceof CompositeOperation) : d[3];
                compositeOperation = (CompositeOperation)typedTask.getOperation();
                if (!this.a((Operation)compositeOperation) || this.c() >= 0L) break block5;
                taskResultStatus = TaskResultStatus.FAILED;
                taskFailedStatus = TaskFailedStatus.LICENSE_BROKEN_SE;
                if (!CommonsTaskTitleFactory.c) break block6;
            }
            taskFailedStatus = this.a(compositeOperation.getAllOperations());
            taskResultStatus = this.a(typedTask, taskFailedStatus);
        }
        assert (taskFailedStatus != TaskFailedStatus.WITHOUT_EXCEPTION || taskResultStatus != TaskResultStatus.FAILED) : d[4];
        TaskResultItem taskResultItem = new TaskResultItem(taskResultStatus, taskFailedStatus, Instant.ofEpochMilli(compositeOperation.getStartTime() + compositeOperation.getOperationTime()).atZone(ZoneId.systemDefault()).toLocalDateTime(), this.a.incrementAndGet(), typedTask.getTaskInfo(), this.createActionComponentConfigurator(typedTask, taskResultStatus), typedTask.isResultApplied(), (OperationStatistic)typedTask.getStatistic(), typedTask.getProjectInfo());
        this.putAdditionalData(typedTask, taskResultItem);
        return taskResultItem;
    }

    private long c() {
        ApplicationParametersImpl applicationParametersImpl = this.applicationController.getParameters();
        return applicationParametersImpl.getLivePlanExpiredDays();
    }

    private List<String> i() {
        Date date = this.applicationController.getKBUpdateDate();
        List list = SearchEngineList.getInstance().getSearchEngineTypes();
        SearchEngineType[] searchEngineTypeArray = list.toArray(new SearchEngineType[list.size()]);
        return ((Stream)SearchEngineUtils.sortByPriority(Arrays.asList(SearchEngineKnowledgeBaseDataModel.getBrokenSearchEngines((SearchEngineType[])searchEngineTypeArray, (Date)date, (Date)new Date()))).stream().sequential()).map(SearchEngineType::getName).collect(Collectors.toList());
    }

    private boolean a(Operation operation) {
        boolean bl2 = CommonsTaskTitleFactory.c;
        if (operation instanceof CompositeOperation) {
            for (Operation operation2 : ((CompositeOperation)operation).getAllOperations()) {
                boolean bl3 = this.a(operation2);
                if (bl3) {
                    return true;
                }
                if (!bl2) continue;
            }
            return false;
        }
        return operation.getExceptionsList().stream().anyMatch(throwable -> throwable instanceof SearchEngineParserBrokenException);
    }

    private TaskResultStatus a(TypedTask typedTask, TaskFailedStatus taskFailedStatus) {
        OperationState operationState = typedTask.getOperation().getOperationState();
        switch (operationState) {
            case OK: {
                return taskFailedStatus == TaskFailedStatus.WITHOUT_EXCEPTION || taskFailedStatus == TaskFailedStatus.UNKNOWN ? this.getOKTaskResultStatus(typedTask, taskFailedStatus) : TaskResultStatus.FAILED;
            }
            case STOPPED: {
                return TaskResultStatus.STOPPED;
            }
        }
        return TaskResultStatus.FAILED;
    }

    @NotNull
    private TaskFailedStatus a(List<Operation> list) {
        List list2 = list.stream().filter(Operation::isFailed).map(Operation::getException).filter(Objects::nonNull).map(this::a).collect(Collectors.toList());
        if (list2.contains(TaskFailedStatus.NO_INTERNET_CONNECTION)) {
            return TaskFailedStatus.NO_INTERNET_CONNECTION;
        }
        list2.removeIf(taskFailedStatus -> taskFailedStatus == TaskFailedStatus.WITHOUT_EXCEPTION || taskFailedStatus == TaskFailedStatus.NO_INTERNET_CONNECTION);
        if (list2.isEmpty()) {
            return TaskFailedStatus.WITHOUT_EXCEPTION;
        }
        long l2 = list.stream().filter(operation -> operation.getClass() != CheckInternetConnectionOperation.class).count();
        if ((long)list2.size() == l2) {
            return TaskFailedStatus.ALL_TASKS_FAILED;
        }
        list2.removeIf(taskFailedStatus -> taskFailedStatus == TaskFailedStatus.UNKNOWN);
        assert (list2.size() == 0 || new HashSet(list2).size() == 1) : d[2];
        if (list2.isEmpty()) {
            return TaskFailedStatus.UNKNOWN;
        }
        return (TaskFailedStatus)list2.get(0);
    }

    @NotNull
    private TaskFailedStatus a(Throwable throwable) {
        return this.b.getOrDefault(throwable.getClass(), TaskFailedStatus.UNKNOWN);
    }

    @NotNull
    private IActionComponent.ActionType a(TypedTask typedTask, TaskResultStatus taskResultStatus) {
        IActionComponent.ActionType actionType;
        boolean bl2 = CommonsTaskTitleFactory.c;
        switch (taskResultStatus) {
            case DONE_WITH_ERRORS: 
            case SUCCESS: {
                actionType = IActionComponent.ActionType.VIEW;
                if (!bl2) break;
            }
            case FAILED: 
            case DONE_WITHOUT_RESULT: {
                IActionComponent.ActionType actionType2 = actionType = typedTask.getTaskInfo().isScheduled() ? IActionComponent.ActionType.RUN : IActionComponent.ActionType.TRY;
                if (!bl2) break;
            }
            case STOPPED: {
                Object STATS = typedTask.getStatistic();
                if (STATS == null) {
                    actionType = IActionComponent.ActionType.UNKNOWN;
                    if (!bl2) break;
                }
                IActionComponent.ActionType actionType3 = STATS.hasResult() && typedTask.isResultApplied() ? IActionComponent.ActionType.VIEW : (actionType = typedTask.getTaskInfo().isScheduled() ? IActionComponent.ActionType.RUN : IActionComponent.ActionType.TRY);
                if (!bl2) break;
            }
            default: {
                actionType = IActionComponent.ActionType.UNKNOWN;
            }
        }
        return actionType;
    }

    protected Consumer<IActionComponent> createActionComponentConfigurator(TypedTask<? extends TaskType, ? extends Operation, ? extends OperationStatistic> typedTask, TaskResultStatus taskResultStatus) {
        Consumer<IActionComponent> consumer = null;
        Optional<Runnable> optional = typedTask.getViewAction();
        Optional<Runnable> optional2 = typedTask.getRestartAction();
        if (optional.isPresent() || optional2.isPresent()) {
            IActionComponent.ActionType actionType = this.a(typedTask, taskResultStatus);
            switch (actionType) {
                case VIEW: 
                case TRY: {
                    if (!optional.isPresent()) break;
                    Runnable runnable = optional.get();
                    consumer = iActionComponent -> {
                        iActionComponent.setClickAction(runnable);
                        iActionComponent.setType(actionType);
                    };
                    break;
                }
                case RUN: {
                    if (!optional2.isPresent()) break;
                    Runnable runnable = optional2.get();
                    ScheduledTaskInfo scheduledTaskInfo = (ScheduledTaskInfo)typedTask.getTaskInfo();
                    long l2 = scheduledTaskInfo.getId();
                    consumer = iActionComponent -> {
                        e e2 = new e((IActionComponent)iActionComponent, l2, null);
                        TaskManager<TypedTask> taskManager = this.applicationController.getTaskManager();
                        taskManager.addTaskAddedListener((TaskAddedListener)e2);
                        taskManager.addTaskRemovedListener((TaskRemovedListener)e2);
                        iActionComponent.setEnabled(!e2.contains(taskManager.getMergedSnapshotList()));
                        iActionComponent.setReleaseAction(() -> {
                            taskManager.removeTaskAddedListener((TaskAddedListener)e2);
                            taskManager.removeTaskRemovedListener((TaskRemovedListener)e2);
                        });
                        iActionComponent.setClickAction(runnable);
                        iActionComponent.setType(actionType);
                    };
                }
            }
        }
        if (consumer == null) {
            consumer = iActionComponent -> {};
        }
        return consumer;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\ru{G\u0016\u001eynM\u0007\u0004xsJ\u001d\u0015ynZ";
        int n3 = 4;
        block14: while (true) {
            char[] cArray;
            block19: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block18: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block18;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block19;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 65;
                                break;
                            }
                            case 1: {
                                n9 = 60;
                                break;
                            }
                            case 2: {
                                n9 = 54;
                                break;
                            }
                            case 3: {
                                n9 = 14;
                                break;
                            }
                            default: {
                                n9 = 66;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 4: {
                    LIMIT_EXCEEDED_TEXT = string.intern();
                    string2 = "\ru{G\u0016\u001eynM\u0007\u0004xsJ\u001d\u0014nz";
                    n3 = 5;
                    continue block14;
                }
                case 5: {
                    LIMIT_EXCEEDED_URL = string.intern();
                    string2 = "\u0014lrO\u0016\u0004czG\u0001\u0004reK\u001d\u0012hdG\f\u0006c}K\u001b\u001eosZ";
                    n3 = -1;
                    continue block14;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0003nyE\u0007\u000fceK\u001d\u0000xrG\u0016\bsxO\u000e\u001exwZ\u0003\u001ewsW";
                    n3 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0016TS`b\u0014r}@\r\u0016r\u0016}6 HC}'2\u001cAk0$\u001cDk/.JSjb,IEzb#Y\u0016}6 E\u0016a,-E\u0016A,$\u001cEz#5IE";
                    n3 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0015TS.-1YDo6(SX./4OB. $\u001c_`15]Xm'aSP.\u0001.QFa1(HSA2$NWz+.R";
                    n3 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0016NY`%aHW})aZWg.aOBo64O\u0016|'\"SQ`+2Y\u0018.\u0016 O].! RXa6a^S.$ UZ.5)YX.#-P\u0016}7#HW})2\u001cE{!\"YE}";
                    n3 = 3;
                    continue block14;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        d = stringArray3;
    }
}

