/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.util;

import com.agilemind.commons.application.controllers.ApplicationControllerImpl;
import com.agilemind.commons.application.data.IProjectLocation;
import com.agilemind.commons.application.data.IProjectMetaData;
import com.agilemind.commons.application.data.Project;
import com.agilemind.commons.application.data.ProjectMetaData;
import com.agilemind.commons.application.modules.storage.StorageType;
import com.agilemind.commons.application.modules.storage.project.ProjectEntry;
import com.agilemind.commons.application.modules.storage.project.ProjectStorage;
import com.agilemind.commons.application.modules.storage.project.ProjectStorageFactory;
import com.agilemind.commons.application.util.BrowserPreviewSettings;
import com.agilemind.commons.application.util.CompressedProjectFileFilter;
import com.agilemind.commons.application.util.ProjectCorruptException;
import com.agilemind.commons.application.util.ProjectLoaderSaver;
import com.agilemind.commons.application.util.h;
import com.agilemind.commons.data.Database;
import com.agilemind.commons.io.IOUtils;
import com.agilemind.commons.mvc.controllers.Controller;
import com.agilemind.commons.mvc.util.ApplicationIOUtils;
import com.agilemind.commons.util.ThreadSafeUtil;
import com.agilemind.commons.util.errorproof.ExecuteAndReturn;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineStorageProjectLoaderSaver<P extends Project>
implements ProjectLoaderSaver<P> {
    private static final Logger a;
    private static final File b;
    private final ApplicationControllerImpl<P> c;
    private final StorageType d;
    private static final String[] f;

    public OnlineStorageProjectLoaderSaver(ApplicationControllerImpl<P> applicationControllerImpl, StorageType storageType) {
        this.c = applicationControllerImpl;
        this.d = storageType;
    }

    @Override
    public P loadProject(String string) throws IOException, InterruptedException {
        File file = OnlineStorageProjectLoaderSaver.createTmpProjectFolder(this.d);
        File file2 = OnlineStorageProjectLoaderSaver.createTmpProjectFile(file);
        ProjectEntry projectEntry = this.c().downloadFile(string, file2);
        File file3 = file2;
        if (IOUtils.isZipFile((File)file3)) {
            file3 = OnlineStorageProjectLoaderSaver.createTmpProjectFile(file);
            try {
                IOUtils.unzipFile((File)file2, (File)file3);
                if (!file2.delete()) {
                    a.error(f[0], (Object)file2.getAbsolutePath());
                }
            }
            catch (IOException iOException) {
                throw new ProjectCorruptException(iOException, file2);
            }
        }
        File file4 = file3;
        return (P)((Project)ThreadSafeUtil.invokeWaitAndReturn((ExecuteAndReturn)new h(this, file4, projectEntry)));
    }

    @Override
    public boolean saveProject(P p2) throws IOException, InterruptedException {
        boolean bl2;
        block23: {
            boolean bl3;
            block25: {
                block24: {
                    boolean bl4;
                    block22: {
                        boolean bl5;
                        File file;
                        block21: {
                            IProjectMetaData iProjectMetaData;
                            File file2;
                            block20: {
                                File file3;
                                block19: {
                                    bl4 = BrowserPreviewSettings.f;
                                    file2 = p2.getDatabase().getFile();
                                    if (e || file2 != null) break block19;
                                    throw new AssertionError();
                                }
                                if (!file2.exists()) {
                                    a.error(f[4], (Object)file2.getAbsolutePath());
                                    file3 = OnlineStorageProjectLoaderSaver.createTmpProjectFolder(this.d);
                                    file2 = OnlineStorageProjectLoaderSaver.createTmpProjectFile(file3);
                                }
                                file3 = file2;
                                ThreadSafeUtil.invokeAndWaitEx(() -> {
                                    Database database = p2.getDatabase();
                                    database.save(file3, false);
                                });
                                iProjectMetaData = ((Project)p2).getMetadata();
                                if (e || iProjectMetaData != null) break block20;
                                throw new AssertionError();
                            }
                            file = file2;
                            bl5 = false;
                            IProjectLocation iProjectLocation = iProjectMetaData.getLocation();
                            if (iProjectLocation.getStorageType() == StorageType.DROPBOX && !this.b(iProjectLocation.getPath())) break block21;
                            file = OnlineStorageProjectLoaderSaver.createTmpProjectFile(file2.getParentFile());
                            IOUtils.zipFile((File)file2, (File)file);
                            bl5 = true;
                        }
                        ProjectEntry projectEntry = this.c().updateFile(((Project)p2).getMetadata().getProjectEntry(), file);
                        ((Project)p2).setMetadata(new ProjectMetaData(this.d, projectEntry));
                        if (!bl5 || file.delete()) break block22;
                        a.error(f[3], (Object)file.getAbsolutePath());
                    }
                    bl2 = true;
                    if (!Controller.g) break block23;
                    if (!bl4) break block24;
                    bl3 = false;
                    break block25;
                }
                bl3 = true;
            }
            BrowserPreviewSettings.f = bl3;
        }
        return bl2;
    }

    @Override
    public boolean saveAsProject(P p2, String string) throws IOException, InterruptedException {
        File file = OnlineStorageProjectLoaderSaver.createTmpProjectFolder(this.d);
        File file2 = OnlineStorageProjectLoaderSaver.createTmpProjectFile(file);
        ThreadSafeUtil.invokeAndWaitEx(() -> {
            Database database = p2.getDatabase();
            database.save(file2, false);
        });
        File file3 = OnlineStorageProjectLoaderSaver.createTmpProjectFile(file);
        IOUtils.zipFile((File)file2, (File)file3);
        ProjectEntry projectEntry = this.c().uploadFile(string, file3);
        ((Project)p2).setMetadata(new ProjectMetaData(this.d, projectEntry));
        if (!file3.delete()) {
            a.error(f[5], (Object)file3.getAbsolutePath());
        }
        return true;
    }

    private ProjectStorage<ProjectEntry> c() throws IOException {
        ProjectStorageFactory projectStorageFactory = this.c.getProjectStorageFactory();
        return projectStorageFactory.getStorage(this.d);
    }

    private boolean b(String string) {
        CompressedProjectFileFilter compressedProjectFileFilter = this.c.getCompressedProjectFileFilter();
        return compressedProjectFileFilter.isCompressedFile(string);
    }

    public static File createTmpProjectFile(File file) throws IOException {
        File file2 = IOUtils.createRandomFile((File)file, (String)"");
        if (!file2.createNewFile()) {
            a.error(f[2], (Object)file.getAbsolutePath());
        }
        if (!file2.canWrite()) {
            a.error(f[1], (Object)file2.getAbsolutePath());
        }
        file2.deleteOnExit();
        return file2;
    }

    public static File createTmpProjectFolder(StorageType storageType) {
        File file = IOUtils.createRandomFolder((File)new File(b, storageType.getId()));
        if (!file.exists()) {
            a.error(f[6], (Object)storageType, (Object)b.getAbsolutePath());
        }
        file.deleteOnExit();
        return file;
    }

    static /* synthetic */ ApplicationControllerImpl access$000(OnlineStorageProjectLoaderSaver onlineStorageProjectLoaderSaver) {
        return onlineStorageProjectLoaderSaver.c;
    }

    static /* synthetic */ StorageType access$100(OnlineStorageProjectLoaderSaver onlineStorageProjectLoaderSaver) {
        return onlineStorageProjectLoaderSaver.d;
    }

    static /* synthetic */ Logger access$200() {
        return a;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0014\u0018Xie#YRbf2\rS'i8\u0014Fuo$\nSc*1\u0010Zb*,\u0004";
        int n3 = -1;
        block15: while (true) {
            char[] cArray;
            block20: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block19: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block19;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block20;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 87;
                                break;
                            }
                            case 1: {
                                n9 = 121;
                                break;
                            }
                            case 2: {
                                n9 = 54;
                                break;
                            }
                            case 3: {
                                n9 = 7;
                                break;
                            }
                            default: {
                                n9 = 10;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0014\u0018Xie#YAuc#\u001c\u0016ndw\u001f_kow\u0002K";
                    n3 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0014\u0018Xie#YUuo6\rS'~:\t\u0016wx8\u0013Sd~w\u001f_kow\u0010X'q*";
                    n3 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0014\u0018Xie#YRbf2\rS'i8\u0014Fuo$\nSc*1\u0010Zb*,\u0004";
                    n3 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0014\u0018Xie#YPnd3YFue=\u001cUs*1\u0010Zb*,\u0004";
                    n3 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0014\u0018Xie#YRbf2\rS'i8\u0014Fuo$\nSc*1\u0010Zb*,\u0004";
                    n3 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0014\u0018Xie#YUuo6\rS'~:\t\u0016ae;\u001dSu*1\u0016D'z%\u0016\\bi#\n\u0016|ww\u0010X'q*";
                    n3 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "#\u0014Fwx8\u0013Sd~$";
                    n3 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        f = stringArray3;
        a = LoggerFactory.getLogger(OnlineStorageProjectLoaderSaver.class);
        b = new File(ApplicationIOUtils.getApplicationDir(), f[7]);
    }
}

