/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.util.tableclipboard;

import com.agilemind.commons.application.controllers.ApplicationControllerImpl;
import com.agilemind.commons.application.controllers.quicksearch.AvailableColumnsFilter;
import com.agilemind.commons.application.gui.ctable.ClipboardTable;
import com.agilemind.commons.application.modules.license.LicenseType;
import com.agilemind.commons.application.util.datatransfer.TransferableData;
import com.agilemind.commons.application.util.settings.LicenseTypeUtils;
import com.agilemind.commons.application.views.MessageDialogProvider;
import com.agilemind.commons.gui.locale.keysets.BundleOptionPaneStringKeySet;
import com.agilemind.commons.gui.locale.keysets.OptionPaneStringKeySet;
import com.agilemind.commons.localization.stringkey.CommonsStringKey;
import com.agilemind.commons.localization.stringkey.StringKey;
import com.agilemind.commons.mvc.controllers.Controller;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.event.ActionEvent;
import java.util.function.Supplier;
import javax.swing.AbstractAction;

public class CopyToClipboardAction
extends AbstractAction {
    private final Supplier<? extends ClipboardTable> a;
    private final Controller b;
    private final boolean c;
    private static final String d;

    public CopyToClipboardAction(Supplier<? extends ClipboardTable> supplier, Controller controller) {
        this(supplier, controller, true);
    }

    public CopyToClipboardAction(Supplier<? extends ClipboardTable> supplier, Controller controller, boolean bl2) {
        this.a = supplier;
        this.b = controller;
        this.c = bl2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.i()) {
            ClipboardTable clipboardTable = this.c();
            Controller controller = this.j();
            AvailableColumnsFilter availableColumnsFilter = controller.getThisProvider(AvailableColumnsFilter.class);
            TransferableData transferableData = clipboardTable.getTransferableData(availableColumnsFilter, TransferableData.Type.Keyword);
            if (transferableData != null) {
                CopyToClipboardAction.copyToSystemClipboard(transferableData, this.j(), clipboardTable);
            }
        }
    }

    private ClipboardTable c() {
        return this.a.get();
    }

    public static void copyToSystemClipboard(TransferableData transferableData, Controller controller, ClipboardOwner clipboardOwner) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            clipboard.setContents(transferableData, clipboardOwner);
        }
        catch (IllegalStateException illegalStateException) {
            MessageDialogProvider.showMessageDialog(controller, (OptionPaneStringKeySet)new BundleOptionPaneStringKeySet((StringKey)new CommonsStringKey(d)), 0);
        }
    }

    private boolean i() {
        if (this.c) {
            Controller controller = this.j();
            return LicenseTypeUtils.isAllowed(() -> ((ApplicationControllerImpl)controller.getApplicationController()).getLicenseType(), LicenseType.COPY_AS_TEXT, controller);
        }
        return true;
    }

    private Controller j() {
        return this.b;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "'d\u000e5?%x\n)a3j\f\"&*l=#?=%\u0013)<7j\u0019)".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 68;
                            break;
                        }
                        case 1: {
                            n7 = 11;
                            break;
                        }
                        case 2: {
                            n7 = 126;
                            break;
                        }
                        case 3: {
                            n7 = 76;
                            break;
                        }
                        default: {
                            n7 = 79;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        d = new String(cArray).intern();
    }
}

