/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.openjdk.jmh.profile.ProfilerException;

class ProfilerUtils {
    ProfilerUtils() {
    }

    public static OptionSet parseInitLine(String initLine, OptionParser parser) throws ProfilerException {
        String s;
        OptionSet set;
        parser.accepts("help", "Display help.");
        NonOptionArgumentSpec nonOptions = parser.nonOptions();
        String[] split = initLine.split(";");
        for (int c = 0; c < split.length; ++c) {
            if (split[c].isEmpty()) continue;
            split[c] = "-" + split[c];
        }
        try {
            set = parser.parse(split);
        }
        catch (OptionException e) {
            try {
                StringWriter sw = new StringWriter();
                sw.append(e.getMessage());
                sw.append("\n");
                parser.printHelpOn((Writer)sw);
                throw new ProfilerException(sw.toString());
            }
            catch (IOException e1) {
                throw new ProfilerException(e1);
            }
        }
        if (set.has("help")) {
            try {
                StringWriter sw = new StringWriter();
                parser.printHelpOn((Writer)sw);
                throw new ProfilerException(sw.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((s = (String)set.valueOf((OptionSpec)nonOptions)) != null && !s.isEmpty()) {
            throw new ProfilerException("Unhandled options: " + s + " in " + initLine);
        }
        return set;
    }
}

