/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.ByteArrayOutputStream;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.openjdk.jmh.util.InputStreamDrainer;
import sun.misc.Unsafe;

public class Utils {
    private static final Unsafe U;
    private static final ConcurrentMap<String, Pattern> PATTERNS;

    private Utils() {
    }

    public static Pattern lazyCompile(String pattern) {
        Pattern patt = (Pattern)PATTERNS.get(pattern);
        if (patt == null) {
            patt = Pattern.compile(pattern);
            PATTERNS.put(pattern, patt);
        }
        return patt;
    }

    public static <T extends Comparable<T>> T min(Collection<T> ts) {
        Comparable min = null;
        for (Comparable t : ts) {
            if (min == null) {
                min = t;
                continue;
            }
            min = min.compareTo(t) < 0 ? min : t;
        }
        return (T)min;
    }

    public static <T extends Comparable<T>> T max(Collection<T> ts) {
        Comparable max = null;
        for (Comparable t : ts) {
            if (max == null) {
                max = t;
                continue;
            }
            max = max.compareTo(t) > 0 ? max : t;
        }
        return (T)max;
    }

    public static String[] concat(String[] t1, String[] t2) {
        String[] r = new String[t1.length + t2.length];
        System.arraycopy(t1, 0, r, 0, t1.length);
        System.arraycopy(t2, 0, r, t1.length, t2.length);
        return r;
    }

    public static String join(Collection<String> src, String delim) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : src) {
            if (first) {
                first = false;
            } else {
                sb.append(delim);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String join(String[] src, String delim) {
        return Utils.join(Arrays.asList(src), delim);
    }

    public static Collection<String> splitQuotedEscape(String src) {
        ArrayList<String> results = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        for (char ch : src.toCharArray()) {
            if (ch == ' ' && !escaped) {
                String s = sb.toString();
                if (s.isEmpty()) continue;
                results.add(s);
                sb = new StringBuilder();
                continue;
            }
            if (ch == '\"') {
                escaped ^= true;
                continue;
            }
            sb.append(ch);
        }
        String s = sb.toString();
        if (!s.isEmpty()) {
            results.add(s);
        }
        return results;
    }

    public static int sum(int[] arr) {
        int sum = 0;
        for (int i : arr) {
            sum += i;
        }
        return sum;
    }

    public static int roundUp(int v, int quant) {
        if (v % quant == 0) {
            return v;
        }
        return (v / quant + 1) * quant;
    }

    public static String throwableToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        pw.close();
        return sw.toString();
    }

    public static int[] unmarshalIntArray(String src) {
        String[] ss = src.split("=");
        int[] arr = new int[ss.length];
        int cnt = 0;
        for (String s : ss) {
            arr[cnt] = Integer.valueOf(s.trim());
            ++cnt;
        }
        return arr;
    }

    public static String marshalIntArray(int[] arr) {
        StringBuilder sb = new StringBuilder();
        for (int i : arr) {
            sb.append(i);
            sb.append("=");
        }
        return sb.toString();
    }

    public static int figureOutHotCPUs() {
        ExecutorService service = Executors.newCachedThreadPool();
        int warmupTime = 1000;
        long lastChange = System.currentTimeMillis();
        ArrayList futures = new ArrayList();
        futures.add(service.submit(new BurningTask()));
        int max = 0;
        while (System.currentTimeMillis() - lastChange < (long)warmupTime) {
            int cur = Runtime.getRuntime().availableProcessors();
            if (cur <= max) continue;
            max = cur;
            lastChange = System.currentTimeMillis();
            futures.add(service.submit(new BurningTask()));
        }
        for (Future future : futures) {
            future.cancel(true);
        }
        service.shutdown();
        return max;
    }

    public static Charset guessConsoleEncoding() {
        Object res;
        Field f;
        try {
            Console console = System.console();
            if (console != null) {
                f = Console.class.getDeclaredField("cs");
                f.setAccessible(true);
                res = f.get(console);
                if (res instanceof Charset) {
                    return (Charset)res;
                }
                Method m = Console.class.getDeclaredMethod("encoding", new Class[0]);
                m.setAccessible(true);
                res = m.invoke(null, new Object[0]);
                if (res instanceof String) {
                    return Charset.forName((String)res);
                }
            }
        }
        catch (Exception console) {
            // empty catch block
        }
        try {
            PrintStream out = System.out;
            if (out != null) {
                String encoding;
                f = PrintStream.class.getDeclaredField("charOut");
                f.setAccessible(true);
                res = f.get(out);
                if (res instanceof OutputStreamWriter && (encoding = ((OutputStreamWriter)res).getEncoding()) != null) {
                    return Charset.forName(encoding);
                }
            }
        }
        catch (Exception out) {
            // empty catch block
        }
        String prop = System.getProperty("sun.stdout.encoding");
        if (prop != null) {
            try {
                return Charset.forName(prop);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Charset.defaultCharset();
    }

    public static void reflow(PrintWriter pw, String src, int width, int indent) {
        StringTokenizer tokenizer = new StringTokenizer(src);
        int curWidth = indent;
        Utils.indent(pw, indent);
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            pw.print(next);
            pw.print(" ");
            if ((curWidth += next.length() + 1) <= width) continue;
            pw.println();
            Utils.indent(pw, indent);
            curWidth = 0;
        }
        pw.println();
    }

    private static void indent(PrintWriter pw, int indent) {
        for (int i = 0; i < indent; ++i) {
            pw.print(" ");
        }
    }

    public static Collection<String> rewrap(String lines) {
        ArrayList<String> result = new ArrayList<String>();
        String[] words = lines.split("[ \n]");
        String line = "";
        int cols = 0;
        for (String w : words) {
            line = line + w + " ";
            if ((cols += w.length()) <= 40) continue;
            result.add(line);
            line = "";
            cols = 0;
        }
        if (!line.trim().isEmpty()) {
            result.add(line);
        }
        return result;
    }

    public static void check(Class<?> klass, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            Utils.check(klass, fieldName);
        }
    }

    public static void check(Class<?> klass, String fieldName) {
        long off;
        long requiredGap = 128L;
        long markerBegin = Utils.getOffset(klass, "markerBegin");
        long markerEnd = Utils.getOffset(klass, "markerEnd");
        if (markerEnd - (off = Utils.getOffset(klass, fieldName)) < 128L || off - markerBegin < 128L) {
            throw new IllegalStateException("Consistency check failed for " + fieldName + ", off = " + off + ", markerBegin = " + markerBegin + ", markerEnd = " + markerEnd);
        }
    }

    public static long getOffset(Class<?> klass, String fieldName) {
        while (true) {
            try {
                Field f = klass.getDeclaredField(fieldName);
                return U.objectFieldOffset(f);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if ((klass = klass.getSuperclass()) != null) continue;
                throw new IllegalStateException("Can't find field \"" + fieldName + "\"");
            }
            break;
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").contains("indows");
    }

    public static String getCurrentJvm() {
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + "java" + (Utils.isWindows() ? ".exe" : "");
    }

    public static String getCurrentJvmVersion() {
        return "JDK " + System.getProperty("java.version") + ", VM " + System.getProperty("java.vm.version");
    }

    public static String getCurrentOSVersion() {
        return System.getProperty("os.name") + ", " + System.getProperty("os.arch") + ", " + System.getProperty("os.version");
    }

    public static long getPid() {
        int idx;
        String DELIM = "@";
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (name != null && (idx = name.indexOf("@")) != -1) {
            String str = name.substring(0, name.indexOf("@"));
            try {
                return Long.valueOf(str);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalStateException("Process PID is not a number: " + str);
            }
        }
        throw new IllegalStateException("Unsupported PID format: " + name);
    }

    public static Collection<String> tryWith(String ... cmd) {
        ArrayList<String> messages = new ArrayList<String>();
        try {
            Process p = new ProcessBuilder(cmd).start();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStreamDrainer errDrainer = new InputStreamDrainer(p.getErrorStream(), baos);
            InputStreamDrainer outDrainer = new InputStreamDrainer(p.getInputStream(), baos);
            errDrainer.start();
            outDrainer.start();
            int err = p.waitFor();
            errDrainer.join();
            outDrainer.join();
            if (err != 0) {
                messages.add(baos.toString());
            }
        }
        catch (IOException ex) {
            return Collections.singleton(ex.getMessage());
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
        return messages;
    }

    public static Collection<String> runWith(List<String> cmd) {
        ArrayList<String> messages = new ArrayList<String>();
        try {
            Process p = new ProcessBuilder(cmd).start();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStreamDrainer errDrainer = new InputStreamDrainer(p.getErrorStream(), baos);
            InputStreamDrainer outDrainer = new InputStreamDrainer(p.getInputStream(), baos);
            errDrainer.start();
            outDrainer.start();
            int err = p.waitFor();
            errDrainer.join();
            outDrainer.join();
            messages.add(baos.toString());
        }
        catch (IOException ex) {
            return Collections.singleton(ex.getMessage());
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
        return messages;
    }

    public static <T> Iterable<T> adaptForLoop(final Iterator<T> it) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return it;
            }
        };
    }

    static {
        try {
            Field unsafe = Unsafe.class.getDeclaredField("theUnsafe");
            unsafe.setAccessible(true);
            U = (Unsafe)unsafe.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        PATTERNS = new ConcurrentHashMap<String, Pattern>();
    }

    static class BurningTask
    implements Runnable {
        BurningTask() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
            }
        }
    }
}

