/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.modules.concurrent.util.operations;

import com.agilemind.commons.localization.IStringKey;
import com.agilemind.commons.localization.exception.ILocalizedException;
import com.agilemind.commons.localization.stringkey.CommonsStringKey;
import com.agilemind.commons.localization.stringkey.OperationConstants;
import com.agilemind.commons.modules.concurrent.util.OperationLogger;
import com.agilemind.commons.modules.concurrent.util.operations.OperationState;
import com.agilemind.commons.modules.concurrent.util.operations.events.OperationProgressEvent;
import com.agilemind.commons.modules.concurrent.util.operations.events.OperationProgressListener;
import com.agilemind.commons.modules.concurrent.util.operations.events.OperationStateEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class Operation
implements OperationLogger {
    private static final Logger a;
    private static final Marker b;
    private final IStringKey c;
    private final boolean d;
    private final boolean e;
    private String f;
    private final Object g;
    private OperationState h;
    private final List<OperationProgressListener> i;
    private final List<OperationLogger> j;
    private long k;
    private long l;
    private Throwable m;
    private String n;
    private String o;
    public static boolean p;
    private static final String[] q;

    Operation(IStringKey iStringKey, boolean bl, boolean bl2) {
        int n = OperationState.c;
        this.g = new Object();
        this.h = OperationState.STARTING;
        this.i = new CopyOnWriteArrayList<OperationProgressListener>();
        this.j = new ArrayList<OperationLogger>();
        this.c = iStringKey;
        this.n = iStringKey.getString();
        this.d = bl;
        this.e = bl2;
        if (p) {
            OperationState.c = ++n;
        }
    }

    public void executeOperation() {
        this.k = System.currentTimeMillis();
        try {
            this.setState(OperationState.RUNNING);
            this.log(OperationConstants.STARTING_STRING_KEY.getString());
            if (a.isDebugEnabled()) {
                a.debug(this.getLogPrefix() + q[1]);
            }
            this.execute();
            if (!this.e) {
                this.checkStopped();
                this.setState(OperationState.OK);
                this.log(OperationConstants.DONE_STATUS.getString());
            }
        }
        catch (InterruptedException interruptedException) {
            this.log(OperationConstants.STOPPED_STRING_KEY.getString());
            this.setState(OperationState.STOPPED);
        }
        catch (Throwable throwable) {
            Operation operation = this;
            String string = throwable instanceof ILocalizedException ? ((ILocalizedException)throwable).getText() : new CommonsStringKey(q[0]).getString();
            operation.log(string);
            this.a(throwable);
            Operation operation2 = this;
            OperationState operationState = this.h == OperationState.STOPPING ? OperationState.STOPPED : OperationState.FAILED;
            operation2.setState(operationState);
        }
    }

    protected String getLogPrefix() {
        String string = this.getClass().getSimpleName();
        if (StringUtils.isEmpty((CharSequence)string)) {
            string = this.getClass().getName();
        }
        if (StringUtils.isEmpty((CharSequence)string)) {
            string = q[5];
        }
        StringBuilder stringBuilder = new StringBuilder().append(q[6]);
        String string2 = StringUtils.isBlank((CharSequence)this.n) ? q[4] : this.n;
        return stringBuilder.append(string2).append(q[7]).append(string).append("]").toString();
    }

    protected abstract void execute() throws Exception;

    public abstract void stop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkStopped() throws InterruptedException {
        OperationState operationState;
        Object object = this.g;
        synchronized (object) {
            operationState = this.h;
        }
        if (operationState == OperationState.STOPPING) {
            throw new InterruptedException();
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canStop() {
        Object object = this.g;
        synchronized (object) {
            if (this.h == OperationState.RUNNING) return true;
            if (this.h != OperationState.STARTING) return false;
            return true;
        }
    }

    public void addOperationProgressListener(OperationProgressListener operationProgressListener) {
        this.i.add(operationProgressListener);
    }

    public void removeOperationProgressListener(OperationProgressListener operationProgressListener) {
        this.i.remove(operationProgressListener);
    }

    void a() {
        this.i.clear();
    }

    void b() {
        int n = OperationState.c;
        OperationProgressEvent operationProgressEvent = new OperationProgressEvent(this, this.getCompletePercent());
        for (OperationProgressListener operationProgressListener : this.i) {
            operationProgressListener.progressChanged(operationProgressEvent);
            if (n == 0) continue;
        }
    }

    protected void operationSuccess() {
    }

    protected void operationFinished() {
    }

    private void a(Throwable throwable) {
        a.error("", throwable);
        this.m = throwable;
    }

    public boolean hasException(Class<? extends Throwable> clazz) {
        return clazz.isInstance(this.m);
    }

    public Throwable getException() {
        return this.m;
    }

    public List<Throwable> getExceptionsList() {
        List<Throwable> list = this.m == null ? Collections.emptyList() : Collections.singletonList(this.m);
        return list;
    }

    public abstract double getCompletePercent();

    public abstract double getFailedPercent();

    public abstract int getRealSubOperationCount();

    protected abstract double getRealCompletePercent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(OperationState operationState) {
        boolean bl = false;
        Object object = this.g;
        synchronized (object) {
            a.debug(b, this.getLogPrefix() + q[2], (Object)this.h, (Object)operationState);
            if (operationState != this.h && Operation.a(this.h, operationState)) {
                a.debug(b, this.getLogPrefix() + q[3], (Object)this.h, (Object)operationState);
                this.h = operationState;
                bl = true;
            }
        }
        if (bl) {
            object = new OperationStateEvent(this, operationState);
            if (operationState == OperationState.OK) {
                this.operationSuccess();
            }
            if (operationState.a) {
                this.l = System.currentTimeMillis();
                this.operationFinished();
            }
            this.i.forEach(arg_0 -> Operation.a((OperationStateEvent)object, arg_0));
        }
    }

    private static boolean a(OperationState operationState, OperationState operationState2) {
        return Operation.b(operationState, operationState2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean b(OperationState operationState, OperationState operationState2) {
        switch (operationState) {
            case STARTING: {
                if (operationState2 == OperationState.RUNNING) return true;
                if (operationState2 == OperationState.STOPPING) return true;
                return false;
            }
            case RUNNING: {
                if (operationState2 == OperationState.STOPPING) return true;
                if (operationState2 == OperationState.OK) return true;
                if (operationState2 == OperationState.FAILED) return true;
                return false;
            }
            case STOPPING: {
                if (operationState2 != OperationState.STOPPED) return false;
                return true;
            }
            case STOPPED: 
            case OK: 
            case FAILED: {
                return false;
            }
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationState getOperationState() {
        Object object = this.g;
        synchronized (object) {
            return this.h;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailed() {
        Object object = this.g;
        synchronized (object) {
            return this.h == OperationState.FAILED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogger(OperationLogger operationLogger) {
        List<OperationLogger> list = this.j;
        synchronized (list) {
            this.j.add(operationLogger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogger(OperationLogger operationLogger) {
        List<OperationLogger> list = this.j;
        synchronized (list) {
            this.j.remove(operationLogger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationLogger[] getOperationLoggers() {
        OperationLogger[] operationLoggerArray;
        List<OperationLogger> list = this.j;
        synchronized (list) {
            operationLoggerArray = this.j.toArray(new OperationLogger[this.j.size()]);
        }
        return operationLoggerArray;
    }

    @Override
    public void log(String string) {
        OperationLogger[] operationLoggerArray;
        int n = OperationState.c;
        this.f = string;
        for (OperationLogger operationLogger : operationLoggerArray = this.getOperationLoggers()) {
            operationLogger.log(string);
            if (n == 0) continue;
        }
    }

    public long getOperationTime() {
        if (this.k == 0L) {
            return 0L;
        }
        long l = this.l == 0L ? System.currentTimeMillis() - this.k : this.l - this.k;
        return l;
    }

    public String getName() {
        return this.n;
    }

    public IStringKey getNameKey() {
        return this.c;
    }

    public String getOperationStatus() {
        return this.f;
    }

    public boolean isDeterminate() {
        return this.d;
    }

    public boolean isComposite() {
        return this.e;
    }

    public String toString() {
        return this.getName();
    }

    public String getPrevName(Operation operation) {
        block6: {
            if (this.o == null) {
                block5: {
                    List<Operation> list = operation.getTreePath(this);
                    if (list.size() <= 1) break block5;
                    this.o = list.get(list.size() - 2).getName();
                    if (OperationState.c == 0) break block6;
                }
                this.o = "";
            }
        }
        return this.o;
    }

    public long getStartTime() {
        return this.k;
    }

    public List<Operation> getTreePath(Operation operation) {
        ArrayList<Operation> arrayList = new ArrayList<Operation>();
        this.a(arrayList, operation);
        Collections.reverse(arrayList);
        return arrayList;
    }

    abstract boolean a(List<Operation> var1, Operation var2);

    public String getCommand(boolean bl) {
        return null;
    }

    public abstract void cleanup();

    private static /* synthetic */ void a(OperationStateEvent operationStateEvent, OperationProgressListener operationProgressListener) {
        operationProgressListener.operationStateChanged(operationStateEvent);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block31: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block30: {
                String string;
                String[] stringArray = new String[8];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n4 = 0;
                String string2 = "/t//\u00134m%3\\3p+)\u00073*,<\u001b,a.";
                int n5 = -1;
                block21: while (true) {
                    char[] cArray3;
                    block29: {
                        int n6;
                        int n7;
                        char[] cArray4;
                        block28: {
                            char[] cArray5 = string2.toCharArray();
                            n3 = 0;
                            int n8 = cArray5.length;
                            cArray4 = cArray5;
                            n7 = n8;
                            if (n8 <= 1) break block28;
                            cArray3 = cArray4;
                            n6 = n7;
                            if (n7 <= n3) break block29;
                        }
                        do {
                            char[] cArray6 = cArray4;
                            char[] cArray7 = cArray4;
                            int n9 = n3;
                            while (true) {
                                int n10;
                                char c2 = cArray6[n9];
                                switch (n3 % 5) {
                                    case 0: {
                                        n10 = 64;
                                        break;
                                    }
                                    case 1: {
                                        n10 = 4;
                                        break;
                                    }
                                    case 2: {
                                        n10 = 74;
                                        break;
                                    }
                                    case 3: {
                                        n10 = 93;
                                        break;
                                    }
                                    default: {
                                        n10 = 114;
                                    }
                                }
                                cArray6[n9] = (char)(c2 ^ n10);
                                ++n3;
                                cArray4 = cArray7;
                                n7 = n7;
                                if (n7 != 0) break;
                                cArray7 = cArray4;
                                n6 = n7;
                                n9 = n7;
                                cArray6 = cArray4;
                            }
                            cArray3 = cArray4;
                            n6 = n7;
                        } while (n7 > n3);
                    }
                    string = new String(cArray3);
                    switch (n5) {
                        default: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 1;
                            string2 = "`a28\u00115p/s\\n";
                            n5 = 0;
                            continue block21;
                        }
                        case 0: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 2;
                            string2 = "\u0013p+)\u0017`p8$\u001b.cj>\u001a!j-8R&v%0H;yj)\u001d`>1 R3p+)\u0017";
                            n5 = 1;
                            continue block21;
                        }
                        case 1: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 3;
                            string2 = "\u0013p+)\u0017`G\"<\u001c'a.}\u00142k'g\t=$>2Rz\u007f7";
                            n5 = 2;
                            continue block21;
                        }
                        case 2: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 4;
                            string2 = "\u000eK\u0015\u00133\rA";
                            n5 = 3;
                            continue block21;
                        }
                        case 3: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 5;
                            string2 = "\u000eK\u0015\u001e>\u0001W\u0019\u0002<\u0001I\u000f";
                            n5 = 4;
                            continue block21;
                        }
                        case 4: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 6;
                            string2 = "\u000ft//\u00134m%3Rb";
                            n5 = 5;
                            continue block21;
                        }
                        case 5: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 7;
                            string2 = "b_";
                            n5 = 6;
                            continue block21;
                        }
                        case 6: 
                    }
                    break;
                }
                stringArray2[n4] = string.intern();
                q = stringArray3;
                a = LoggerFactory.getLogger(Operation.class);
                char[] cArray8 = "\u0013P\u000b\t7".toCharArray();
                n3 = 0;
                int n11 = cArray8.length;
                cArray2 = cArray8;
                n2 = n11;
                if (n11 <= 1) break block30;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block31;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n12 = n3;
                while (true) {
                    int n13;
                    char c3 = cArray9[n12];
                    switch (n3 % 5) {
                        case 0: {
                            n13 = 64;
                            break;
                        }
                        case 1: {
                            n13 = 4;
                            break;
                        }
                        case 2: {
                            n13 = 74;
                            break;
                        }
                        case 3: {
                            n13 = 93;
                            break;
                        }
                        default: {
                            n13 = 114;
                        }
                    }
                    cArray9[n12] = (char)(c3 ^ n13);
                    ++n3;
                    cArray2 = cArray10;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray10 = cArray2;
                    n = n2;
                    n12 = n2;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        b = MarkerFactory.getMarker((String)new String(cArray).intern());
    }
}

