/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.factors.impl.parsers;

import com.agilemind.commons.io.pagereader.PageReader;
import com.agilemind.commons.io.pagereader.PageReaderContent;
import com.agilemind.commons.io.searchengine.captcha.SearchEngineManager;
import com.agilemind.commons.io.searchengine.robots.data.RobotsResult;
import com.agilemind.commons.io.utils.IOLogger;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.factors.SearchEngineFactorsList;
import com.agilemind.factors.impl.parsers.SingleFactorParser;
import com.agilemind.factors.util.RestrictedFromIndexUtil;
import java.io.IOException;
import java.util.Date;

public class RestrictedFromIndexParser
extends SingleFactorParser<RobotsResult> {
    public RestrictedFromIndexParser() {
        super(SearchEngineFactorsList.ROBOTS_FACTOR_TYPE);
    }

    @Override
    public RobotsResult check(PageReader pageReader, SearchEngineManager searchEngineManager, IOLogger iOLogger, UnicodeURL unicodeURL, Date date) throws InterruptedException {
        PageReaderContent pageReaderContent;
        RobotsResult robotsResult = new RobotsResult();
        robotsResult.setRobotsResult(RestrictedFromIndexUtil.getRobotsTxtResult(pageReader, unicodeURL));
        try {
            pageReaderContent = pageReader.getContent(unicodeURL);
        }
        catch (IOException iOException) {
            return robotsResult;
        }
        robotsResult.setXRobotsNofollowResult(RestrictedFromIndexUtil.getXRobotsNoFollowResult(pageReaderContent));
        robotsResult.setXRobotsNoindexResult(RestrictedFromIndexUtil.getXRobotsNoIndexResult(pageReaderContent));
        robotsResult.setNoFollowResult(RestrictedFromIndexUtil.getNoFollowResult(pageReaderContent));
        robotsResult.setNoIndexResult(RestrictedFromIndexUtil.getNoIndexResult(pageReaderContent));
        return robotsResult;
    }
}

