/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.factors.impl.parsers;

import com.agilemind.commons.io.pagereader.PageReader;
import com.agilemind.commons.io.searchengine.captcha.SearchEngineManager;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngineList;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngineQuery;
import com.agilemind.commons.io.searchengine.searchengines.SearchResults;
import com.agilemind.commons.io.searchengine.searchengines.data.ISearchEngineSettings;
import com.agilemind.commons.io.searchengine.searchengines.type.SearchEngineType;
import com.agilemind.commons.io.utils.IOLogger;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.factors.SearchEngineFactorType;
import com.agilemind.factors.impl.parsers.SearchEngineFactorParser;
import java.io.IOException;
import java.util.Date;

public class SearchEnginePopularityParser
extends SearchEngineFactorParser<Long> {
    static final boolean d = !SearchEnginePopularityParser.class.desiredAssertionStatus();

    protected SearchEnginePopularityParser(ISearchEngineSettings iSearchEngineSettings, SearchEngineFactorType<Long> searchEngineFactorType, SearchEngineType searchEngineType) {
        super(iSearchEngineSettings, searchEngineFactorType, searchEngineType);
        if (!d && !searchEngineType.hasResultsCount()) {
            throw new AssertionError();
        }
    }

    @Override
    public Long check(PageReader pageReader, SearchEngineManager searchEngineManager, IOLogger iOLogger, UnicodeURL unicodeURL, Date date) throws IOException, InterruptedException {
        SearchEngine searchEngine = this.createSearchEngine();
        SearchResults searchResults = searchEngine.search(pageReader, searchEngineManager, iOLogger, (SearchEngineQuery)new SearchEngineQuery.BackLink(unicodeURL), date);
        return searchResults.getNumberOfResults();
    }

    @Override
    public SearchEngine createSearchEngine() {
        return SearchEngineList.getInstance().get(this.searchEngineSettings, this.searchEngineType);
    }
}

