/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.winreg;

import com.github.sarxos.winreg.internal.WindowsPreferencesBuilder;
import java.util.prefs.Preferences;

public enum HKey {
    HKCR(Integer.MIN_VALUE, WindowsPreferencesBuilder.getHKCR()),
    HKCU(-2147483647, Preferences.userRoot()),
    HKLM(-2147483646, Preferences.systemRoot()),
    HKU(-2147483645, WindowsPreferencesBuilder.getHKU()),
    HKCC(-2147483643, WindowsPreferencesBuilder.getHKCC());

    private int hex = 0;
    private Preferences root = null;

    private HKey(int hex, Preferences root) {
        this.hex = hex;
        this.root = root;
    }

    public int hex() {
        return this.hex;
    }

    public Preferences root() {
        return this.root;
    }

    public static HKey fromHex(int hex) {
        HKey[] hks;
        for (HKey hk : hks = HKey.values()) {
            if (hk.hex() != hex) continue;
            return hk;
        }
        return null;
    }
}

