/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.winreg.internal;

import com.github.sarxos.winreg.HKey;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public final class ReflectedMethods {
    private static final Logger LOG = Logger.getLogger(ReflectedMethods.class.getName());
    private static final Class<?> IC = Integer.TYPE;
    private static final Class<?> BAC = byte[].class;
    private static final Method OPEN_KEY = ReflectedMethods.setupMethod("WindowsRegOpenKey", new Class[]{IC, BAC, IC});
    private static final Method CLOSE_KEY = ReflectedMethods.setupMethod("WindowsRegCloseKey", new Class[]{IC});
    private static final Method QUERY_VALUE_EX = ReflectedMethods.setupMethod("WindowsRegQueryValueEx", new Class[]{IC, BAC});
    private static final Method ENUM_VALUE = ReflectedMethods.setupMethod("WindowsRegEnumValue", new Class[]{IC, IC, IC});
    private static final Method QUERY_INFO_KEY = ReflectedMethods.setupMethod("WindowsRegQueryInfoKey1", new Class[]{IC});
    private static final Method ENUM_KEY_EX = ReflectedMethods.setupMethod("WindowsRegEnumKeyEx", new Class[]{IC, IC, IC});
    private static final Method CREATE_KEY_EX = ReflectedMethods.setupMethod("WindowsRegCreateKeyEx", new Class[]{IC, BAC});
    private static final Method SET_VALUE_EX = ReflectedMethods.setupMethod("WindowsRegSetValueEx", new Class[]{IC, BAC, BAC});
    private static final Method DELETE_VALUE = ReflectedMethods.setupMethod("WindowsRegDeleteValue", new Class[]{IC, BAC});
    private static final Method DELETE_KEY = ReflectedMethods.setupMethod("WindowsRegDeleteKey", new Class[]{IC, BAC});
    private static final String NATIVE_ENCODING = System.getProperty("sun.jnu.encoding", null);

    private static Method setupMethod(String name, Class<?>[] args) {
        Method method = null;
        try {
            method = HKey.HKCU.root().getClass().getDeclaredMethod(name, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        method.setAccessible(true);
        return method;
    }

    public static int deleteValue(Preferences root, int hkey, String key, String value) throws Exception {
        int[] handles = ReflectedMethods.keyOpen(root, hkey, key, 983103);
        int rc = (Integer)ReflectedMethods.invoke(DELETE_VALUE, root, handles[0], value);
        ReflectedMethods.keyClose(root, handles);
        return rc;
    }

    public static int deleteKey(Preferences root, int hkey, String key) throws Exception {
        return (Integer)ReflectedMethods.invoke(DELETE_KEY, root, hkey, key);
    }

    public static String readString(Preferences root, int hkey, String key, String value, String charsetName) throws Exception {
        int[] handles = ReflectedMethods.keyOpen(root, hkey, key, 131097);
        byte[] valb = (byte[])ReflectedMethods.invoke(QUERY_VALUE_EX, root, handles[0], value);
        ReflectedMethods.keyClose(root, handles);
        return ReflectedMethods.strFromNativeBytes(valb, charsetName);
    }

    public static Map<String, String> readStringValues(Preferences root, int hkey, String key, String charsetName) throws Exception {
        int[] handles = ReflectedMethods.keyOpen(root, hkey, key, 131097);
        int[] info = (int[])ReflectedMethods.invoke(QUERY_INFO_KEY, root, handles[0]);
        int count = info[0];
        int maxlen = info[3];
        HashMap<String, String> results = new HashMap<String, String>();
        for (int index = 0; index < count; ++index) {
            byte[] name = (byte[])ReflectedMethods.invoke(ENUM_VALUE, root, handles[0], index, maxlen + 1);
            String strName = ReflectedMethods.strFromNativeBytes(name, charsetName);
            String value = ReflectedMethods.readString(root, hkey, key, strName, charsetName);
            results.put(strName.trim(), value);
        }
        ReflectedMethods.keyClose(root, handles);
        return results;
    }

    public static List<String> readStringSubKeys(Preferences root, int hkey, String key, String charsetName) throws Exception {
        int[] handles = ReflectedMethods.keyOpen(root, hkey, key, 131097);
        int[] info = (int[])ReflectedMethods.invoke(QUERY_INFO_KEY, root, handles[0]);
        int count = info[0];
        int maxlen = info[3];
        ArrayList<String> results = new ArrayList<String>();
        for (int index = 0; index < count; ++index) {
            byte[] name = (byte[])ReflectedMethods.invoke(ENUM_KEY_EX, root, handles[0], index, maxlen + 1);
            results.add(ReflectedMethods.strFromNativeBytes(name, charsetName));
        }
        ReflectedMethods.keyClose(root, handles);
        return results;
    }

    public static int[] createKey(Preferences root, int hkey, String key) throws Exception {
        int[] handles = (int[])ReflectedMethods.invoke(CREATE_KEY_EX, root, hkey, key);
        ReflectedMethods.keyClose(root, handles);
        return handles;
    }

    public static void writeStringValue(Preferences root, int hkey, String key, String valueName, String value) throws Exception {
        int[] handles = ReflectedMethods.keyOpen(root, hkey, key, 983103);
        ReflectedMethods.invoke(SET_VALUE_EX, root, handles[0], valueName, value);
        ReflectedMethods.keyClose(root, handles);
    }

    private static Object invoke(Method method, Preferences root, Object ... args) throws Exception {
        Object[] arguments = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg instanceof Integer) {
                arguments[i] = arg;
                continue;
            }
            if (!(arg instanceof String)) continue;
            arguments[i] = ReflectedMethods.strToNativeBytes(arg.toString());
        }
        return method.invoke((Object)root, arguments);
    }

    private static int[] keyOpen(Preferences root, int hkey, String key, int access) throws Exception {
        int[] handles = (int[])ReflectedMethods.invoke(OPEN_KEY, root, hkey, key, access);
        if (handles[1] != 0) {
            throw new IllegalAccessException("Cannot open " + (Object)((Object)HKey.fromHex(hkey)) + "\\" + key);
        }
        return handles;
    }

    private static void keyClose(Preferences root, int[] handles) throws Exception {
        ReflectedMethods.invoke(CLOSE_KEY, root, handles[0]);
    }

    private static byte[] strToNativeBytes(String str) {
        byte[] bytes = null;
        try {
            bytes = str.getBytes(NATIVE_ENCODING);
        }
        catch (Exception e) {
            bytes = str.getBytes();
        }
        byte[] result = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        result[bytes.length] = 0;
        return result;
    }

    private static String strFromNativeBytes(byte[] bytes, String charsetName) {
        String result;
        if (bytes == null) {
            return null;
        }
        if (charsetName == null) {
            charsetName = NATIVE_ENCODING;
        }
        try {
            result = new String(bytes, charsetName);
        }
        catch (Exception e) {
            result = new String(bytes);
        }
        return result == null ? null : result.trim();
    }

    private ReflectedMethods() {
    }
}

