/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.winreg.internal;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class WindowsPreferencesBuilder {
    private static final Logger LOG = Logger.getLogger(WindowsPreferencesBuilder.class.getName());
    private static final byte[] WINDOWS_ROOT_PATH = WindowsPreferencesBuilder.stringToByteArray("");
    public static final int HKCR_VALUE = Integer.MIN_VALUE;
    public static final int HKCU_VALUE = -2147483647;
    public static final int HKLM_VALUE = -2147483646;
    public static final int HKU_VALUE = -2147483645;
    public static final int HKCC_VALUE = -2147483643;
    private static Preferences hkcr = null;
    private static Preferences hkcu = Preferences.userRoot();
    private static Preferences hklm = Preferences.systemRoot();
    private static Preferences hku = null;
    private static Preferences hkcc = null;

    public static Preferences getHKCR() {
        return hkcr;
    }

    public static Preferences getHKCU() {
        return hkcu;
    }

    public static Preferences getHKLM() {
        return hklm;
    }

    public static Preferences getHKU() {
        return hku;
    }

    public static Preferences getHKCC() {
        return hkcc;
    }

    private static byte[] stringToByteArray(String str) {
        byte[] result = new byte[str.length() + 1];
        for (int i = 0; i < str.length(); ++i) {
            result[i] = (byte)str.charAt(i);
        }
        result[str.length()] = 0;
        return result;
    }

    static {
        Class<?> clazz = Preferences.userRoot().getClass();
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(Integer.TYPE, byte[].class);
            constructor.setAccessible(true);
            hkcr = (Preferences)constructor.newInstance(Integer.MIN_VALUE, WINDOWS_ROOT_PATH);
            hku = (Preferences)constructor.newInstance(-2147483645, WINDOWS_ROOT_PATH);
            hkcc = (Preferences)constructor.newInstance(-2147483643, WINDOWS_ROOT_PATH);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Cannot instantiate preferences", e);
        }
    }
}

