/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;

public class CssPercentage
extends CssCheckableValue {
    public static final int type = 4;
    private BigDecimal c;
    private BigDecimal d;
    private static final String[] e;

    @Override
    public final int getType() {
        return 4;
    }

    public CssPercentage() {
        this.d = this.c = BigDecimal.ZERO;
    }

    public CssPercentage(int n) {
        this(new BigDecimal(n));
    }

    public CssPercentage(float f2) {
        this(new BigDecimal(f2));
    }

    public CssPercentage(BigDecimal bigDecimal) {
        this.c = BigDecimal.ZERO;
        this.d = bigDecimal;
    }

    @Override
    public void set(String string, ApplContext applContext) throws InvalidParamException {
        int n = string.length();
        if (string.charAt(n - 1) != '%') {
            throw new InvalidParamException(e[7], string, applContext);
        }
        this.d = new BigDecimal(string.substring(0, n - 1));
    }

    @Override
    public void setValue(BigDecimal bigDecimal) {
        this.d = bigDecimal;
    }

    @Override
    public Object get() {
        return new Float(this.d.floatValue());
    }

    public BigDecimal getValue() {
        return this.d;
    }

    @Override
    public boolean isPositive() {
        return this.d.signum() >= 0;
    }

    @Override
    public boolean isStrictlyPositive() {
        return this.d.signum() == 1;
    }

    @Override
    public boolean isZero() {
        return BigDecimal.ZERO.compareTo(this.d) == 0;
    }

    public float floatValue() {
        return this.d.floatValue();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.d.toPlainString()).append('%');
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof CssPercentage && this.d.equals(((CssPercentage)object).d);
    }

    @Override
    public CssPercentage getPercentage() throws InvalidParamException {
        return this;
    }

    @Override
    public void checkPositiveness(ApplContext applContext, CssProperty cssProperty) throws InvalidParamException {
        if (!this.isPositive()) {
            throw new InvalidParamException(e[1], this.toString(), cssProperty.getPropertyName(), applContext);
        }
    }

    @Override
    public void checkStrictPositiveness(ApplContext applContext, CssProperty cssProperty) throws InvalidParamException {
        if (!this.isStrictlyPositive()) {
            throw new InvalidParamException(e[3], this.toString(), cssProperty.getPropertyName(), applContext);
        }
    }

    @Override
    public void warnPositiveness(ApplContext applContext, CssProperty cssProperty) {
        if (!this.isPositive()) {
            applContext.getFrame().addWarning(e[6], this.toString());
        }
    }

    public void checkLowerEqualThan(ApplContext applContext, double d2, CssProperty cssProperty) throws InvalidParamException {
        BigDecimal bigDecimal = BigDecimal.valueOf(d2);
        if (this.d.compareTo(bigDecimal) > 0) {
            throw new InvalidParamException(e[2], this.toString(), bigDecimal.toPlainString(), applContext);
        }
    }

    public void warnLowerEqualThan(ApplContext applContext, double d2, CssProperty cssProperty) {
        BigDecimal bigDecimal = BigDecimal.valueOf(d2);
        if (this.d.compareTo(bigDecimal) > 0) {
            String[] stringArray = new String[]{this.toString(), bigDecimal.toPlainString() + '%'};
            applContext.getFrame().addWarning(e[0], stringArray);
        }
    }

    @Override
    public void checkEqualsZero(ApplContext applContext, CssProperty cssProperty) throws InvalidParamException {
        if (!this.isZero()) {
            throw new InvalidParamException(e[8], this.toString(), e[9], applContext);
        }
    }

    @Override
    public void warnEqualsZero(ApplContext applContext, CssProperty cssProperty) {
        if (!this.isZero()) {
            applContext.getFrame().addWarning(e[5], e[4]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u000f+6\u001dD\u000654\u0019Z";
        int n2 = -1;
        block17: while (true) {
            char[] cArray;
            block22: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block21: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block21;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block22;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 99;
                                break;
                            }
                            case 1: {
                                n8 = 68;
                                break;
                            }
                            case 2: {
                                n8 = 65;
                                break;
                            }
                            case 3: {
                                n8 = 120;
                                break;
                            }
                            default: {
                                n8 = 54;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\r!&\u0019B\n2$U@\u0002(4\u001d";
                    n2 = 0;
                    continue block17;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\u000f+6\u001dD\u000654\u0019Z";
                    n2 = 1;
                    continue block17;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\u001003\u0011U\u0017(8UF\f7(\f_\u0015!";
                    n2 = 2;
                    continue block17;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\u0013!3\u001bS\r0 \u001fS";
                    n2 = 3;
                    continue block17;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\u0019!3\u0017";
                    n2 = 4;
                    continue block17;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "\r!&\u0019B\n2$";
                    n2 = 5;
                    continue block17;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "\u0013!3\u001bS\r0 \u001fS";
                    n2 = 6;
                    continue block17;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "\u0019!3\u0017";
                    n2 = 7;
                    continue block17;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "\u0013!3\u001bS\r0 \u001fS";
                    n2 = 8;
                    continue block17;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        e = stringArray3;
    }
}

