/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.crawler.operation;

import com.agilemind.commons.io.pagereader.HandledPageReader;
import com.agilemind.commons.io.pagereader.IConnectionSettings;
import com.agilemind.commons.io.pagereader.IPageReaderHandler;
import com.agilemind.commons.io.pagereader.PageReader;
import com.agilemind.commons.io.pagereader.PageReaderFactory;
import com.agilemind.commons.io.pagereader.PageReaderHandler;
import com.agilemind.commons.localization.IStringKey;
import com.agilemind.commons.localization.stringkey.StringKey;
import com.agilemind.commons.localization.util.CachedLocalizedStringKey;
import com.agilemind.commons.modules.concurrent.util.OperationLogger;
import com.agilemind.commons.modules.concurrent.util.operations.ConcurrentCompositeOperation;
import com.agilemind.commons.modules.concurrent.util.operations.Operation;
import com.agilemind.commons.util.Charset;
import com.agilemind.commons.util.Pair;
import com.agilemind.commons.util.ThreadSafeUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import com.agilemind.commons.util.Util;
import com.agilemind.crawler.CrawlerContext;
import com.agilemind.crawler.CrawlingStorage;
import com.agilemind.crawler.fetcher.FetchResults;
import com.agilemind.crawler.fetcher.PageFetcher;
import com.agilemind.crawler.operation.CrawlerRootOperation;
import com.agilemind.crawler.operation.RateLimitQueueOperationManager;
import com.agilemind.crawler.operation.c;
import com.agilemind.crawler.operation.f;
import com.agilemind.crawler.parser.PageParser;
import com.agilemind.crawler.parser.ParseResults;
import com.agilemind.crawler.to.CrawlerPage;
import com.agilemind.crawler.to.CrawlerResourceContainer;
import com.agilemind.crawler.to.LimitTaskExecutor;
import com.agilemind.crawler.to.UrlData;
import com.agilemind.crawler.to.UrlID;
import com.agilemind.crawler.util.AbstractLimitedManager;
import com.agilemind.crawler.util.CrawlingUtil;
import com.agilemind.sitescan.util.operations.AbstractFetchRobotsTxtOperation;
import com.agilemind.websiteauditor.data.ResourceSourceType;
import com.agilemind.websiteauditor.data.api.ISiteCrawlingSettings;
import com.agilemind.websiteauditor.util.WebsiteAuditorStringKey;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlerOperation
extends ConcurrentCompositeOperation {
    private static final Logger a;
    static final CachedLocalizedStringKey b;
    private Consumer<FetchResults> c;
    private Consumer<ParseResults> d;
    private final CrawlerContext e;
    private final CrawlingStorage f;
    private final PageReader g;
    private boolean h;
    private AtomicInteger i;
    static final boolean j;
    private static final String[] B;

    CrawlerOperation(CrawlerContext crawlerContext, CrawlingStorage crawlingStorage, UnicodeURL ... unicodeURLArray) {
        this(crawlerContext, crawlingStorage, Arrays.asList(unicodeURLArray));
    }

    CrawlerOperation(CrawlerContext crawlerContext, CrawlingStorage crawlingStorage, Iterable<UnicodeURL> iterable) {
        int n2 = CrawlerRootOperation.d;
        super((IStringKey)new WebsiteAuditorStringKey(B[1]));
        this.c = null;
        this.d = null;
        this.h = true;
        this.i = new AtomicInteger(0);
        this.e = crawlerContext;
        this.f = crawlingStorage;
        this.g = this.a(crawlerContext);
        LimitTaskExecutor<UrlData, UrlData> limitTaskExecutor = (arg_0, arg_1, arg_2) -> this.a(crawlerContext, crawlingStorage, arg_0, arg_1, arg_2);
        PriorityBlockingQueue priorityBlockingQueue = new PriorityBlockingQueue(100000, CrawlerOperation::a);
        AbstractLimitedManager<UrlData> abstractLimitedManager = this.a(crawlerContext, crawlingStorage, limitTaskExecutor);
        abstractLimitedManager.setQueue(priorityBlockingQueue);
        for (UnicodeURL unicodeURL : iterable) {
            UrlData urlData = new UrlData(crawlerContext.createId(unicodeURL), 0, 0);
            if (crawlingStorage.startCrawlIfNeeded(urlData)) {
                abstractLimitedManager.start(urlData);
            }
            if (n2 == 0) continue;
            int n3 = WebsiteAuditorStringKey.b;
            WebsiteAuditorStringKey.b = ++n3;
            break;
        }
    }

    protected void execute() throws IOException, InterruptedException {
        this.log(new WebsiteAuditorStringKey(B[0]).getString());
        super.execute();
    }

    protected void operationFinished() {
        super.operationFinished();
        this.g.dispose();
    }

    private PageReader a(CrawlerContext crawlerContext) {
        PageReader pageReader;
        ISiteCrawlingSettings iSiteCrawlingSettings = crawlerContext.getCrawlingSettings();
        PageReader pageReader2 = pageReader = iSiteCrawlingSettings.isUseInternalBrowser() ? PageReaderFactory.getInstance((IConnectionSettings)crawlerContext.getConnectionSettings()).createJavaScriptPageReader() : PageReaderFactory.getInstance((IConnectionSettings)crawlerContext.getConnectionSettings()).createAjaxPageReaderForNonSearchEngine();
        if (iSiteCrawlingSettings.isUseUserAgent()) {
            pageReader.getPageReaderSettings().setUserAgent(iSiteCrawlingSettings.getUserAgent());
        }
        return new HandledPageReader(pageReader, (IPageReaderHandler)new PageReaderHandler(crawlerContext.getAuthorizationRequester()));
    }

    @NotNull
    private AbstractLimitedManager<UrlData> a(CrawlerContext crawlerContext, CrawlingStorage crawlingStorage, LimitTaskExecutor<UrlData, UrlData> limitTaskExecutor) {
        ISiteCrawlingSettings iSiteCrawlingSettings = crawlerContext.getCrawlingSettings();
        double d2 = iSiteCrawlingSettings.isUseRequestLimit() ? iSiteCrawlingSettings.getRequestPerSecond() : 0.0;
        return new f(this, limitTaskExecutor, d2, crawlerContext, iSiteCrawlingSettings, crawlingStorage);
    }

    private void a(UnicodeURL unicodeURL, CrawlerContext crawlerContext) {
        c c2 = new c(this, unicodeURL, crawlerContext, unicodeURL);
        try {
            ThreadSafeUtil.invokeAndWait(() -> this.a(c2));
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void addSubOperationAndInc(Operation operation) {
        this.i.incrementAndGet();
        this.addSubOperation(operation);
    }

    private void a(Consumer<UrlData> consumer, CrawlingStorage crawlingStorage, CrawlerContext crawlerContext) {
        crawlingStorage.removeEachClickLeafPagesIf(arg_0 -> CrawlerOperation.a(consumer, crawlerContext, arg_0));
    }

    public boolean haveRobots(UrlData urlData) {
        return this.f.getRobotsManager().haveRobots(urlData.getUrlID().host());
    }

    private void a(UrlData urlData, Consumer<UrlData> consumer, OperationLogger operationLogger, PageReader pageReader, CrawlerContext crawlerContext, CrawlingStorage crawlingStorage) throws Exception {
        int n2;
        block8: {
            n2 = CrawlerRootOperation.d;
            UnicodeURL unicodeURL = urlData.getUrlID().getUrl();
            String string = UnicodeURLUtil.getIdnHostWithoutWWW((UnicodeURL)unicodeURL);
            if (!CrawlingUtil.isInternal(crawlerContext.getProjectUrl(), unicodeURL, crawlerContext.getCrawlingSettings().isUseSubDomain()) || crawlingStorage.getRobotsManager().haveRobots(string)) break block8;
            operationLogger.log(b.getString());
            crawlingStorage.getRobotsManager().waitUpdateRobots(string);
            operationLogger.log(RateLimitQueueOperationManager.l.getString());
        }
        PageFetcher pageFetcher = crawlingStorage.getFetcherPool().get();
        Iterable<FetchResults> iterable = pageFetcher.simpleFetch(urlData, pageReader, crawlerContext, crawlingStorage);
        for (FetchResults fetchResults : iterable) {
            Util.checkInterrupted();
            if (this.c != null) {
                this.c.accept(fetchResults);
            }
            PageParser pageParser = crawlingStorage.getParserPool().get();
            this.a(consumer, crawlerContext, crawlingStorage, fetchResults, pageParser);
            crawlingStorage.getParserPool().put(pageParser);
            if (n2 == 0) continue;
        }
        crawlingStorage.getFetcherPool().put(pageFetcher);
    }

    private void a(Consumer<UrlData> consumer, CrawlerContext crawlerContext, CrawlingStorage crawlingStorage, FetchResults fetchResults, PageParser pageParser) throws IOException, InterruptedException {
        pageParser.parseResource(crawlerContext, crawlingStorage, fetchResults, arg_0 -> this.a(fetchResults, consumer, arg_0));
    }

    private void a(ParseResults parseResults, FetchResults fetchResults, Consumer<UrlData> consumer) {
        block11: {
            block8: {
                int n2;
                block10: {
                    CrawlerPage crawlerPage;
                    ISiteCrawlingSettings iSiteCrawlingSettings;
                    block9: {
                        n2 = CrawlerRootOperation.d;
                        iSiteCrawlingSettings = this.e.getCrawlingSettings();
                        if (!parseResults.isPage()) break block8;
                        crawlerPage = parseResults.getPage();
                        if (!parseResults.needRedirect()) break block9;
                        this.a(this.e, consumer, parseResults, fetchResults.getRedirectDepth());
                        if (n2 == 0) break block10;
                    }
                    if (!iSiteCrawlingSettings.isUseDepthLimit() || iSiteCrawlingSettings.getClickDepthLimit() + 1 >= parseResults.getClickDepth()) {
                        this.a(crawlerPage);
                        crawlerPage.getResourcesContainers().stream().filter(arg_0 -> this.a(parseResults, arg_0)).forEach(arg_0 -> CrawlerOperation.a(consumer, parseResults, fetchResults, arg_0));
                    }
                }
                if (n2 == 0) break block11;
            }
            this.f.putResource(parseResults.getResource());
        }
        if (this.d != null) {
            this.d.accept(parseResults);
        }
    }

    protected void a(CrawlerPage crawlerPage) {
        this.f.putPage(crawlerPage);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(CrawlerContext crawlerContext, Consumer<UrlData> consumer, ParseResults parseResults, int n2) {
        void var6_11;
        CrawlerPage crawlerPage;
        block14: {
            crawlerPage = parseResults.getPage();
            try {
                UnicodeURL unicodeURL = new UnicodeURL(crawlerPage.getPageInfo().getRedirectUrl(), Charset.UTF8);
                UrlID urlID = crawlerContext.createId(unicodeURL);
                Pair<UrlID, Integer> pair = this.f.getRedirectedIfNeeded(parseResults.getPage().getUrlID(), urlID, n2);
                if (pair == null) break block14;
                if (!(j || pair.getA() != null && pair.getB() != null)) {
                    throw new AssertionError();
                }
                UrlData urlData = new UrlData((UrlID)pair.getA(), parseResults.getClickDepth(), (Integer)pair.getB() + 1);
                if (this.f.startCrawlIfNeeded(urlData)) {
                    consumer.accept(urlData);
                }
            }
            catch (MalformedURLException malformedURLException) {
                a.debug("", (Throwable)malformedURLException);
            }
        }
        try {
            CrawlerResourceContainer crawlerResourceContainer = new CrawlerResourceContainer(crawlerContext.createId(new UnicodeURL(crawlerPage.getPageInfo().getRedirectUrl(), Charset.UTF8)), ResourceSourceType.REDIRECT_HEADER);
        }
        catch (MalformedURLException malformedURLException) {
            if (!j && crawlerPage.getPageInfo().getRedirectUrl() == null) {
                throw new AssertionError();
            }
            CrawlerResourceContainer crawlerResourceContainer = new CrawlerResourceContainer(crawlerPage.getPageInfo().getRedirectUrl(), ResourceSourceType.REDIRECT_HEADER);
        }
        crawlerPage.add((CrawlerResourceContainer)var6_11);
        this.a(crawlerPage);
    }

    @NotNull
    private String a(UrlData urlData) {
        return urlData.getUrlID().getUrl().toString();
    }

    CrawlingStorage A() {
        return this.f;
    }

    public CrawlerContext getContext() {
        return this.e;
    }

    public void executeOperation() {
        this.h = false;
        super.executeOperation();
    }

    CrawlerOperation a(Consumer<FetchResults> consumer) {
        if (!j && !this.h) {
            throw new AssertionError();
        }
        if (!j && this.c != null) {
            throw new AssertionError();
        }
        this.c = consumer;
        return this;
    }

    CrawlerOperation b(Consumer<ParseResults> consumer) {
        if (!j && !this.h) {
            throw new AssertionError();
        }
        if (!j && this.d != null) {
            throw new AssertionError();
        }
        this.d = consumer;
        return this;
    }

    public double getCompletePercent() {
        int n2 = this.f.getTotalResourceCount();
        double d2 = Math.round(100.0 * (double)this.f.getFinishResourceCount() / (double)n2);
        if (!(j || d2 >= 0.0 && d2 <= 100.0)) {
            throw new AssertionError(d2);
        }
        return d2;
    }

    public int getRealSubOperationCount() {
        return this.f.getTotalResourceCount() + this.i.get();
    }

    public Consumer<FetchResults> getFetchAdditionalConsumer() {
        return this.c;
    }

    public Consumer<ParseResults> getParseAdditionalConsumer() {
        return this.d;
    }

    private static void a(Consumer consumer, ParseResults parseResults, FetchResults fetchResults, CrawlerResourceContainer crawlerResourceContainer) {
        consumer.accept(new UrlData(crawlerResourceContainer.getUrlID(), parseResults.getClickDepth(), fetchResults.getRedirectDepth()));
    }

    private boolean a(ParseResults parseResults, CrawlerResourceContainer crawlerResourceContainer) {
        return crawlerResourceContainer.getUrlID() != null && this.f.startCrawlIfNeeded(new UrlData(crawlerResourceContainer.getUrlID(), parseResults.getClickDepth(), 0));
    }

    private void a(FetchResults fetchResults, Consumer consumer, ParseResults parseResults) {
        this.a(parseResults, fetchResults, consumer);
    }

    private static boolean a(Consumer consumer, CrawlerContext crawlerContext, UrlID urlID) {
        try {
            Util.checkInterrupted();
            if (urlID != null) {
                consumer.accept(new UrlData(urlID, crawlerContext.getCrawlingSettings().getClickDepthLimit() + 1, 0));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    private void a(AbstractFetchRobotsTxtOperation abstractFetchRobotsTxtOperation) {
        this.addSubOperationAndInc((Operation)abstractFetchRobotsTxtOperation);
    }

    private static int a(UrlData urlData, UrlData urlData2) {
        return Integer.compare(urlData.getClickDepth(), urlData2.getClickDepth());
    }

    private void a(CrawlerContext crawlerContext, CrawlingStorage crawlingStorage, UrlData urlData, Consumer consumer, OperationLogger operationLogger) throws Exception {
        this.a(urlData, consumer, operationLogger, this.g, crawlerContext, crawlingStorage);
    }

    static CrawlingStorage a(CrawlerOperation crawlerOperation) {
        return crawlerOperation.f;
    }

    static void a(CrawlerOperation crawlerOperation, UnicodeURL unicodeURL, CrawlerContext crawlerContext) {
        crawlerOperation.a(unicodeURL, crawlerContext);
    }

    static void a(CrawlerOperation crawlerOperation, Consumer consumer, CrawlingStorage crawlingStorage, CrawlerContext crawlerContext) {
        crawlerOperation.a(consumer, crawlingStorage, crawlerContext);
    }

    static String a(CrawlerOperation crawlerOperation, UrlData urlData) {
        return crawlerOperation.a(urlData);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = ":<+\u0010\u001c!%!\fS&8/\u0016\b&b<\r\u0012!\u000f<\u0003\n9% \u0005";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 85;
                                break;
                            }
                            case 1: {
                                n9 = 76;
                                break;
                            }
                            case 2: {
                                n9 = 78;
                                break;
                            }
                            case 3: {
                                n9 = 98;
                                break;
                            }
                            default: {
                                n9 = 125;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = ":<+\u0010\u001c!%!\fS6>/\u0015\u00110>`\f\u001c8)";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = ":<+\u0010\u001c!%!\fS&8/\u0016\b&b9\u0003\u0014!\u001e!\u0000\u0012!";
                    n3 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        B = stringArray3;
        j = !CrawlerOperation.class.desiredAssertionStatus();
        a = LoggerFactory.getLogger(CrawlerOperation.class);
        b = new CachedLocalizedStringKey((StringKey)new WebsiteAuditorStringKey(B[2]));
    }
}

