/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.sitescan.data.audit;

import com.agilemind.commons.application.modules.io.searchengine.data.SearchEngineFactor;
import com.agilemind.commons.application.modules.io.searchengine.data.api.IPopularityHistoryMap;
import com.agilemind.commons.application.modules.io.searchengine.data.api.IPopularityMap;
import com.agilemind.commons.localization.util.LocalizedStringUtil;
import com.agilemind.commons.util.StatusCodeConstants;
import com.agilemind.commons.util.StringURLUtil;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import com.agilemind.commons.util.Util;
import com.agilemind.factors.FactorType;
import com.agilemind.factors.IFactorParser;
import com.agilemind.factors.SearchEngineFactorsList;
import com.agilemind.factors.data.PageInfo;
import com.agilemind.factors.data.PageInfoKeys;
import com.agilemind.sitescan.data.HttpResponseCode;
import com.agilemind.sitescan.data.HttpResponseCodeGroup;
import com.agilemind.sitescan.data.audit.DomainAuditResultView;
import com.agilemind.sitescan.data.audit.PagesAuditResultView;
import com.agilemind.sitescan.data.audit.ResourcesAuditResultView;
import com.agilemind.sitescan.data.audit.SiteAuditFactorType;
import com.agilemind.sitescan.data.audit.SiteAuditResultView;
import com.agilemind.sitescan.data.audit.factor.ISiteAuditFactorType;
import com.agilemind.sitescan.data.audit.factor.SiteAuditResultType;
import com.agilemind.sitescan.data.audit.factor.domain.DomainAuditFactor;
import com.agilemind.sitescan.data.audit.factor.domain.DomainAuditFactorFactory;
import com.agilemind.sitescan.data.audit.factor.domain.DomainAuditFactorType;
import com.agilemind.sitescan.data.audit.factor.domain.result.DomainAuditResult;
import com.agilemind.sitescan.data.audit.factor.pages.PagesAuditFactor;
import com.agilemind.sitescan.data.audit.factor.pages.PagesAuditFactorFactory;
import com.agilemind.sitescan.data.audit.factor.pages.PagesAuditFactorType;
import com.agilemind.sitescan.data.audit.factor.pages.result.PagesAuditResult;
import com.agilemind.sitescan.data.audit.factor.resources.ResourceAuditFactorFactory;
import com.agilemind.sitescan.data.audit.factor.resources.ResourcesAuditFactor;
import com.agilemind.sitescan.data.audit.factor.resources.ResourcesAuditFactorType;
import com.agilemind.sitescan.data.audit.factor.resources.result.ResourcesAuditResult;
import com.agilemind.sitescan.modules.siteaudit.data.ISiteAuditFactorsModel;
import com.agilemind.sitescan.modules.siteaudit.data.SiteAuditFactorsModel;
import com.agilemind.websiteauditor.data.ImageResourceSource;
import com.agilemind.websiteauditor.data.PageContainer;
import com.agilemind.websiteauditor.data.Resource;
import com.agilemind.websiteauditor.data.ResourceSource;
import com.agilemind.websiteauditor.data.ResourceSourceType;
import com.agilemind.websiteauditor.data.ResourceType;
import com.agilemind.websiteauditor.data.api.IPage;
import com.agilemind.websiteauditor.data.api.IResource;
import com.agilemind.websiteauditor.util.WebsiteAuditorStringKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SiteAuditUtil {
    public static int b;
    private static final String[] a;

    public static <T extends Resource> List<T> getResourcesWithoutRedirect(List<T> list) {
        return list.stream().filter(SiteAuditUtil::a).collect(Collectors.toList());
    }

    public static <T extends IResource> List<T> getResourcesWithHttpResponseCode(List<T> list, HttpResponseCodeGroup httpResponseCodeGroup) {
        return list.stream().filter(arg_0 -> SiteAuditUtil.a(httpResponseCodeGroup, arg_0)).collect(Collectors.toList());
    }

    public static <T extends IResource> List<T> getResourcesWithHttpResponseCode(List<T> list, HttpResponseCode httpResponseCode) {
        return list.stream().filter(arg_0 -> SiteAuditUtil.a(httpResponseCode, arg_0)).collect(Collectors.toList());
    }

    public static Map<String, List<IPage>> getPagesWithDuplicateTitle(List<IPage> list) {
        return SiteAuditUtil.getPagesWithDuplicateTag(list, PageInfoKeys.title);
    }

    public static Map<String, List<IPage>> getPagesWithDuplicateMetaDescription(List<IPage> list) {
        return SiteAuditUtil.getPagesWithDuplicateTag(list, PageInfoKeys.description);
    }

    public static Map<String, List<IPage>> getPagesWithDuplicateTag(List<IPage> list, PageInfoKeys pageInfoKeys) {
        int n2 = SiteAuditFactorType.g;
        TreeMap<String, List<IPage>> treeMap = new TreeMap<String, List<IPage>>(SiteAuditUtil::a);
        for (IPage object : list) {
            block17: {
                if (!SiteAuditUtil.a(object)) break block17;
                if (n2 == 0) continue;
                int n3 = WebsiteAuditorStringKey.b;
                WebsiteAuditorStringKey.b = ++n3;
            }
            if (!SiteAuditUtil.b(object) && n2 == 0) continue;
            if (SiteAuditUtil.a(pageInfoKeys, object) && n2 == 0) continue;
            SearchEngineFactor searchEngineFactor = object.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);
            String string = (String)((PageInfo)searchEngineFactor.getFactorValue()).get((Object)pageInfoKeys);
            if (IFactorParser.NOT_FOUND.equals(string) && n2 == 0) continue;
            ArrayList<IPage> arrayList = (ArrayList<IPage>)treeMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<IPage>();
                treeMap.put(string, arrayList);
            }
            if (!SiteAuditUtil.a(arrayList, object)) {
                arrayList.add(object);
            }
            if (n2 == 0) continue;
        }
        Iterator<Object> iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (((List)entry.getValue()).size() < 2) {
                iterator.remove();
            }
            if (n2 == 0) continue;
        }
        return treeMap;
    }

    public static List<IPage> getPagesWithMissingEmptyTitleTag(List<IPage> list) {
        return SiteAuditUtil.getPagesWithMissingEmptyTag(list, PageInfoKeys.title);
    }

    public static List<IPage> getPagesWithMissingEmptyMetaDescriptionTag(List<IPage> list) {
        return SiteAuditUtil.getPagesWithMissingEmptyTag(list, PageInfoKeys.description);
    }

    public static List<IPage> getPagesWithMissingEmptyTag(List<IPage> list, PageInfoKeys pageInfoKeys) {
        int n2 = SiteAuditFactorType.g;
        ArrayList<IPage> arrayList = new ArrayList<IPage>();
        for (IPage iPage : list) {
            block10: {
                SearchEngineFactor searchEngineFactor = iPage.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);
                if (searchEngineFactor != null) {
                    block11: {
                        PageInfo pageInfo = (PageInfo)searchEngineFactor.getFactorValue();
                        if (PageInfo.isNyc((PageInfo)pageInfo) || pageInfo.isNa()) break block10;
                        String string = (String)pageInfo.get((Object)pageInfoKeys);
                        if (string == null) break block10;
                        if (string.trim().length() == 0) break block11;
                        if (!IFactorParser.NOT_FOUND.equals(string)) break block10;
                    }
                    arrayList.add(iPage);
                }
            }
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    public static boolean isBrokenLink(PageContainer pageContainer) {
        Object t2 = pageContainer.getResourceSource();
        ResourceSourceType resourceSourceType = ((ResourceSource)t2).getResourceSourceType();
        if (!resourceSourceType.isLinkType()) {
            return false;
        }
        if (pageContainer.getUrl() == null) {
            boolean bl;
            block17: {
                block16: {
                    String string = ((ResourceSource)pageContainer.getResourceSource()).getLink();
                    if (StringUtil.isEmpty((String)string) || StatusCodeConstants.isUnsupportedProtocol((String)string)) break block16;
                    if (StatusCodeConstants.isBinaryData((String)string)) break block16;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
            return bl;
        }
        IResource iResource = pageContainer.getResource();
        if (iResource == null) {
            return false;
        }
        Integer n2 = iResource.getHttpStatusCode();
        if (n2 == null) {
            return false;
        }
        return SiteAuditUtil.isBrokenStatusCode(n2);
    }

    public static boolean isBrokenImage(PageContainer pageContainer) {
        Integer n2;
        IResource iResource;
        block22: {
            block18: {
                Object t2 = pageContainer.getResourceSource();
                ResourceSourceType resourceSourceType = ((ResourceSource)t2).getResourceSourceType();
                if (resourceSourceType == ResourceSourceType.IMG_TAG || resourceSourceType == ResourceSourceType.IMG_SRC_SET_TAG) break block18;
                return false;
            }
            if (pageContainer.getUrl() == null) {
                boolean bl;
                block21: {
                    block20: {
                        block19: {
                            String string = ((ResourceSource)pageContainer.getResourceSource()).getLink();
                            if (StringUtil.isEmpty((String)string)) break block19;
                            if (StatusCodeConstants.isUnsupportedProtocol((String)string)) break block20;
                            if (StatusCodeConstants.isBinaryData((String)string)) break block20;
                        }
                        bl = true;
                        break block21;
                    }
                    bl = false;
                }
                return bl;
            }
            iResource = pageContainer.getResource();
            if (iResource == null) {
                return false;
            }
            n2 = iResource.getHttpStatusCode();
            if (n2 == null || !SiteAuditUtil.isBrokenStatusCode(n2)) break block22;
            return true;
        }
        String string = iResource.getContentType();
        return SiteAuditUtil.isBrokenImageContentType(string, n2);
    }

    public static boolean isBrokenImageContentType(String string, @Nullable Integer n2) {
        boolean bl;
        block11: {
            block10: {
                if (IFactorParser.NA_DATA.equals(string) || n2 == null) break block10;
                if (HttpResponseCodeGroup.RES_3XX.accept(n2)) break block10;
                if (a[0].equalsIgnoreCase(string)) break block10;
                if (ResourceType.recognizeByContentType(string) == ResourceType.IMAGES) break block10;
                bl = true;
                break block11;
            }
            bl = false;
        }
        return bl;
    }

    public static boolean isBrokenStatusCode(int n2) {
        boolean bl;
        block12: {
            block11: {
                block10: {
                    if (n2 == -1 || n2 == -3) break block10;
                    if (n2 == -4) break block10;
                    if (HttpResponseCodeGroup.RES_4XX.accept(n2)) break block10;
                    if (!HttpResponseCodeGroup.RES_5XX.accept(n2)) break block11;
                }
                bl = true;
                break block12;
            }
            bl = false;
        }
        return bl;
    }

    public static boolean isEmptyAltText(PageContainer pageContainer) {
        block4: {
            Object t2 = pageContainer.getResourceSource();
            ResourceSourceType resourceSourceType = ((ResourceSource)t2).getResourceSourceType();
            if (resourceSourceType == ResourceSourceType.IMG_TAG || resourceSourceType == ResourceSourceType.IMG_SRC_SET_TAG) break block4;
            return false;
        }
        return StringUtil.isEmpty((String)((ImageResourceSource)pageContainer.getResourceSource()).getAltText());
    }

    private static boolean a(IPage iPage) {
        Integer n2 = iPage.getHttpStatusCode();
        if (n2 == null) {
            return true;
        }
        boolean bl = n2 != 200;
        return bl;
    }

    private static boolean b(IPage iPage) {
        SearchEngineFactor searchEngineFactor = iPage.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);
        if (searchEngineFactor != null) {
            PageInfo pageInfo = (PageInfo)searchEngineFactor.getFactorValue();
            UnicodeURL unicodeURL = pageInfo.getCanonicalUrl();
            if (unicodeURL == null) {
                return true;
            }
            UnicodeURL unicodeURL2 = iPage.getUrl();
            return unicodeURL2.equals((Object)unicodeURL);
        }
        return true;
    }

    private static boolean a(PageInfoKeys pageInfoKeys, IPage iPage) {
        boolean bl;
        block13: {
            block12: {
                PageInfo pageInfo;
                block11: {
                    SearchEngineFactor searchEngineFactor = iPage.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);
                    if (searchEngineFactor == null) {
                        return true;
                    }
                    pageInfo = (PageInfo)searchEngineFactor.getFactorValue();
                    if (pageInfo != null && !pageInfo.isRedirect()) break block11;
                    return true;
                }
                String string = (String)pageInfo.get((Object)pageInfoKeys);
                if (!StringUtil.isEmpty((String)string) && !LocalizedStringUtil.NA_STRING.getString().equals(string)) break block12;
                bl = true;
                break block13;
            }
            bl = false;
        }
        return bl;
    }

    private static boolean a(List<IPage> list, IPage iPage) {
        return Util.contains(list, (Object)iPage, SiteAuditUtil::a);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ISiteAuditFactorsModel createSiteAuditFactorsModel(List<IPage> list, List<IResource> list2, IPopularityHistoryMap iPopularityHistoryMap) throws Exception {
        int n2 = SiteAuditFactorType.g;
        Map<SiteAuditFactorType, SiteAuditResultView> map = Collections.synchronizedMap(new EnumMap(SiteAuditFactorType.class));
        block11: for (SiteAuditFactorType siteAuditFactorType : SiteAuditFactorType.values()) {
            if (!siteAuditFactorType.isSupported() && n2 == 0) continue;
            ISiteAuditFactorType iSiteAuditFactorType = siteAuditFactorType.getSiteAuditFactorType();
            SiteAuditResultType siteAuditResultType = iSiteAuditFactorType.getResultType();
            switch (siteAuditResultType) {
                case DOMAIN: {
                    SiteAuditUtil.a(map, (DomainAuditFactorType)iSiteAuditFactorType, siteAuditFactorType, iPopularityHistoryMap);
                    if (n2 == 0) continue block11;
                }
                case PAGES: {
                    SiteAuditUtil.a(map, (PagesAuditFactorType)iSiteAuditFactorType, siteAuditFactorType, list);
                    if (n2 == 0) continue block11;
                }
                case RESOURCES: {
                    SiteAuditUtil.a(map, (ResourcesAuditFactorType)iSiteAuditFactorType, siteAuditFactorType, list2);
                    if (n2 == 0) continue block11;
                }
                default: {
                    throw new IllegalArgumentException((Object)((Object)siteAuditResultType) + a[1]);
                }
            }
        }
        SiteAuditFactorsModel siteAuditFactorsModel = new SiteAuditFactorsModel(map);
        if (WebsiteAuditorStringKey.b == 0) return siteAuditFactorsModel;
        SiteAuditFactorType.g = ++n2;
        return siteAuditFactorsModel;
    }

    private static void a(Map<SiteAuditFactorType, SiteAuditResultView> map, ResourcesAuditFactorType resourcesAuditFactorType, SiteAuditFactorType siteAuditFactorType, List<IResource> list) throws Exception {
        ResourcesAuditFactor resourcesAuditFactor = ResourceAuditFactorFactory.createResourcesAuditFactor(resourcesAuditFactorType);
        ResourcesAuditResult resourcesAuditResult = resourcesAuditFactor.getResourcesAuditResult(list);
        map.put(siteAuditFactorType, new ResourcesAuditResultView(siteAuditFactorType, resourcesAuditResult));
    }

    private static void a(Map<SiteAuditFactorType, SiteAuditResultView> map, PagesAuditFactorType pagesAuditFactorType, SiteAuditFactorType siteAuditFactorType, List<IPage> list) throws Exception {
        PagesAuditFactor pagesAuditFactor = PagesAuditFactorFactory.createPagesAuditFactor(pagesAuditFactorType);
        PagesAuditResult pagesAuditResult = pagesAuditFactor.getPagesAuditResult(list);
        map.put(siteAuditFactorType, new PagesAuditResultView(siteAuditFactorType, pagesAuditResult));
    }

    private static void a(Map<SiteAuditFactorType, SiteAuditResultView> map, DomainAuditFactorType domainAuditFactorType, SiteAuditFactorType siteAuditFactorType, IPopularityHistoryMap iPopularityHistoryMap) throws Exception {
        DomainAuditFactor domainAuditFactor = DomainAuditFactorFactory.createDomainAuditFactor(domainAuditFactorType);
        DomainAuditResult domainAuditResult = domainAuditFactor.getDomainAuditResult((IPopularityMap)iPopularityHistoryMap);
        map.put(siteAuditFactorType, new DomainAuditResultView(siteAuditFactorType, domainAuditResult));
    }

    @NotNull
    public static <P extends IPage> Map<UnicodeURL, List<P>> getResourcePagesMap(Iterable<? extends P> iterable) {
        HashMap<UnicodeURL, List<P>> hashMap = new HashMap<UnicodeURL, List<P>>();
        iterable.forEach(arg_0 -> SiteAuditUtil.a(hashMap, arg_0));
        return hashMap;
    }

    private static void a(Map map, IPage iPage) {
        iPage.getPageContainers().forEach(arg_0 -> SiteAuditUtil.a(map, iPage, arg_0));
    }

    private static void a(Map map, IPage iPage, PageContainer pageContainer) {
        map.computeIfAbsent(pageContainer.getUrl(), SiteAuditUtil::a).add(iPage);
    }

    private static List a(UnicodeURL unicodeURL) {
        return new ArrayList();
    }

    private static int a(IPage iPage, IPage iPage2) {
        String string = StringURLUtil.removeTrailingSlash((String)StringURLUtil.removeWWW((String)UnicodeURLUtil.removeProtocol((UnicodeURL)iPage.getUrl())));
        String string2 = StringURLUtil.removeTrailingSlash((String)StringURLUtil.removeWWW((String)UnicodeURLUtil.removeProtocol((UnicodeURL)iPage2.getUrl())));
        return string.compareTo(string2);
    }

    private static int a(String string, String string2) {
        return Util.compare((Object)StringUtil.toLowerCase((String)StringUtil.trim((String)string)), (Object)StringUtil.toLowerCase((String)StringUtil.trim((String)string2)));
    }

    private static boolean a(HttpResponseCode httpResponseCode, IResource iResource) {
        Integer n2 = iResource.getHttpStatusCode();
        if (n2 == null) {
            return false;
        }
        boolean bl = httpResponseCode.getCode() == n2.intValue();
        return bl;
    }

    private static boolean a(HttpResponseCodeGroup httpResponseCodeGroup, IResource iResource) {
        Integer n2 = iResource.getHttpStatusCode();
        if (n2 == null) {
            return false;
        }
        return httpResponseCodeGroup.accept(n2);
    }

    private static boolean a(Resource resource) {
        boolean bl;
        block5: {
            block4: {
                Integer n2 = resource.getHttpStatusCode();
                if (n2 != null && HttpResponseCodeGroup.RES_3XX.accept(n2)) break block4;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "@Ukb`BDogfO\ntm}DQ6}}S@zc";
        int n3 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block13;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 33;
                                break;
                            }
                            case 1: {
                                n9 = 37;
                                break;
                            }
                            case 2: {
                                n9 = 27;
                                break;
                            }
                            case 3: {
                                n9 = 14;
                                break;
                            }
                            default: {
                                n9 = 9;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0001Ktz)HHkblL@uzlE";
                    n3 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        a = stringArray3;
    }
}

