/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.sitescan.data.audit.factor.domain.factor;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.io.searchengine.data.api.IPopularityMap;
import com.agilemind.commons.application.modules.io.searchengine.data.api.ISearchEngineFactor;
import com.agilemind.factors.FactorType;
import com.agilemind.factors.SearchEngineFactorsList;
import com.agilemind.factors.data.DomainInfo;
import com.agilemind.sitescan.data.audit.factor.domain.DomainAuditFactor;
import com.agilemind.sitescan.data.audit.factor.domain.result.DomainAuditResult;

public class FixedProtocolVersionsAuditFactor
implements DomainAuditFactor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DomainAuditResult getDomainAuditResult(IPopularityMap iPopularityMap) throws Exception {
        ISearchEngineFactor iSearchEngineFactor = iPopularityMap.getFactor((FactorType)SearchEngineFactorsList.DOMAIN_INFO_FACTOR_TYPE);
        if (iSearchEngineFactor == null) {
            return new DomainAuditResult(AuditStatusType.NOT_YET_CHECKED);
        }
        DomainInfo.ProtocolResult protocolResult = ((DomainInfo)iSearchEngineFactor.getFactorValue()).getFixedProtocol();
        if (protocolResult == null) {
            return new DomainAuditResult(AuditStatusType.N_A);
        }
        switch (protocolResult) {
            case FIXED: {
                return new DomainAuditResult(AuditStatusType.OK, false);
            }
            case NOT_FIXED: {
                return new DomainAuditResult(AuditStatusType.WARNING, true);
            }
            case SSL_ERROR: {
                return new DomainAuditResult(AuditStatusType.ERROR, true);
            }
        }
        return new DomainAuditResult(AuditStatusType.N_A);
    }
}

