/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.sitescan.report.util.extractors;

import com.agilemind.commons.io.searchengine.validator.ILinkInfo;
import com.agilemind.commons.io.searchengine.validator.LinkInfoImpl;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.factors.IFactorParser;
import com.agilemind.factors.SearchEngineFactorsList;
import com.agilemind.factors.data.PageInfo;
import com.agilemind.sitescan.report.util.extractors.PageResultExtractor;
import com.agilemind.sitescan.report.util.extractors.WAFactorValueExtractor;
import com.agilemind.websiteauditor.data.api.IPage;
import java.net.MalformedURLException;
import org.jetbrains.annotations.Nullable;

public class RedirectPageExtractor
implements PageResultExtractor<ILinkInfo> {
    final WAFactorValueExtractor<PageInfo, IPage> a = new WAFactorValueExtractor(SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);

    public int compare(ILinkInfo iLinkInfo, ILinkInfo iLinkInfo2) {
        if (iLinkInfo == null && iLinkInfo2 == null) {
            return 0;
        }
        if (iLinkInfo == null) {
            return -1;
        }
        if (iLinkInfo2 == null) {
            return 1;
        }
        return DEFAULT_COMPARATOR.compare(iLinkInfo.getDomain(), iLinkInfo2.getDomain());
    }

    @Nullable
    public ILinkInfo extract(IPage iPage) {
        PageInfo pageInfo = this.a.extract(iPage);
        return RedirectPageExtractor.a(pageInfo);
    }

    static ILinkInfo a(PageInfo pageInfo) {
        UnicodeURL unicodeURL;
        if (pageInfo == null) {
            return null;
        }
        String string = pageInfo.getTitle();
        if (string == null) {
            string = IFactorParser.NA_DATA;
        }
        try {
            unicodeURL = new UnicodeURL(pageInfo.getRedirectUrl());
        }
        catch (MalformedURLException malformedURLException) {
            unicodeURL = null;
        }
        return new LinkInfoImpl(unicodeURL).setName(string).setTextLink(true);
    }
}

