/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.websiteauditor.data.service;

import com.agilemind.commons.application.modules.projectmanager.ProjectId;
import com.agilemind.commons.application.service.event.ProjectEventPublisher;
import com.agilemind.commons.application.util.RecordUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.sitescan.util.RankingFactorResult;
import com.agilemind.websiteauditor.data.WebsiteAuditorPage;
import com.agilemind.websiteauditor.data.WebsiteAuditorPageList;
import com.agilemind.websiteauditor.data.api.IPage;
import com.agilemind.websiteauditor.data.service.AnalyzeKeywordsService;
import com.agilemind.websiteauditor.data.service.AnalyzeKeywordsServiceImpl;
import com.agilemind.websiteauditor.data.service.ContentAuditService;
import com.agilemind.websiteauditor.data.service.ContentAuditServiceImpl;
import com.agilemind.websiteauditor.data.service.ContentAuditStatus;
import com.agilemind.websiteauditor.data.service.PageAnalysisService;
import com.agilemind.websiteauditor.data.service.event.PageAnalysisAddedEvent;
import com.agilemind.websiteauditor.data.service.event.PageAnalysisDeletedEvent;
import com.agilemind.websiteauditor.data.service.event.PageAnalysisUpdatedEvent;
import com.agilemind.websiteauditor.util.PageResult;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class PageAnalysisServiceImpl
implements PageAnalysisService {
    private final WebsiteAuditorPageList a;
    private final WebsiteAuditorPageList b;
    private final ProjectEventPublisher c;
    static final boolean d;
    private static final String[] e;

    public PageAnalysisServiceImpl(WebsiteAuditorPageList websiteAuditorPageList, WebsiteAuditorPageList websiteAuditorPageList2, ProjectEventPublisher projectEventPublisher) {
        this.a = websiteAuditorPageList;
        this.b = websiteAuditorPageList2;
        this.c = projectEventPublisher;
    }

    @Override
    public List<? extends IPage> getPages() {
        return this.b.getList();
    }

    @Override
    public void addPage(long l2, Collection<String> collection) {
        WebsiteAuditorPage websiteAuditorPage = (WebsiteAuditorPage)RecordUtil.findById((long)l2, (Iterable)((Object)this.b));
        if (websiteAuditorPage != null) {
            throw new IllegalArgumentException(e[2]);
        }
        RecordUtil.findByIdOptional((long)l2, (Iterable)((Object)this.a)).ifPresent(arg_0 -> this.b(collection, arg_0));
    }

    @Override
    public void addPages(Collection<UnicodeURL> collection) {
        this.a.stream().filter(arg_0 -> PageAnalysisServiceImpl.a(collection, arg_0)).collect(Collectors.toList()).forEach(this::a);
    }

    private void a(WebsiteAuditorPage websiteAuditorPage) {
        if (!this.b.contains(websiteAuditorPage)) {
            this.b.add(websiteAuditorPage);
            this.c.publishProjectEvent(arg_0 -> this.c(websiteAuditorPage, arg_0));
        }
    }

    @Override
    public boolean isPageAnalyzed(long l2) {
        return RecordUtil.findByIdOptional((long)l2, (Iterable)((Object)this.b)).isPresent();
    }

    @Override
    public void removePage(long l2) {
        RecordUtil.findByIdOptional((long)l2, (Iterable)((Object)this.b)).ifPresent(this::b);
    }

    private void b(WebsiteAuditorPage websiteAuditorPage) {
        if (this.b.contains(websiteAuditorPage)) {
            websiteAuditorPage.setContent(null);
            websiteAuditorPage.setOptimizationContent(null);
            websiteAuditorPage.setThumbnail(null);
            websiteAuditorPage.setThumbnailMobile(null);
            websiteAuditorPage.getImportantKeywords().clear();
            this.b.remove(websiteAuditorPage);
            this.c.publishProjectEvent(arg_0 -> this.b(websiteAuditorPage, arg_0));
        }
    }

    @Override
    public void clear() {
        this.b.stream().collect(Collectors.toList()).forEach(this::b);
    }

    @Override
    public void updatePage(long l2, PageResult pageResult) {
        RecordUtil.findByIdOptional((long)l2, (Iterable)((Object)this.b)).ifPresent(arg_0 -> this.a(pageResult, arg_0));
    }

    @Override
    public AnalyzeKeywordsService getAnalyzeKeywordsService(long l2) {
        return RecordUtil.findByIdOptional((long)l2, (Iterable)((Object)this.b)).map(this::d).orElseThrow(PageAnalysisServiceImpl::B);
    }

    @Override
    public ContentAuditService getContentAuditService(long l2) {
        return RecordUtil.findByIdOptional((long)l2, (Iterable)((Object)this.b)).map(this::c).orElseThrow(PageAnalysisServiceImpl::A);
    }

    @Override
    public Optional<IPage> findWebsiteAuditorPage(UnicodeURL unicodeURL) {
        WebsiteAuditorPage websiteAuditorPage = this.b.stream().filter(arg_0 -> PageAnalysisServiceImpl.a(unicodeURL, arg_0)).findFirst().orElse(null);
        return Optional.ofNullable(websiteAuditorPage);
    }

    private static boolean a(UnicodeURL unicodeURL, WebsiteAuditorPage websiteAuditorPage) {
        return unicodeURL.equals((Object)websiteAuditorPage.getUrl());
    }

    private static IllegalArgumentException A() {
        return new IllegalArgumentException(e[0]);
    }

    private ContentAuditServiceImpl c(WebsiteAuditorPage websiteAuditorPage) {
        return new ContentAuditServiceImpl(websiteAuditorPage, this.c);
    }

    private static IllegalArgumentException B() {
        return new IllegalArgumentException(e[1]);
    }

    private AnalyzeKeywordsServiceImpl d(WebsiteAuditorPage websiteAuditorPage) {
        return new AnalyzeKeywordsServiceImpl(websiteAuditorPage, this.c);
    }

    private void a(PageResult pageResult, WebsiteAuditorPage websiteAuditorPage) {
        int n2 = ContentAuditStatus.b;
        websiteAuditorPage.setContent(pageResult.getContent());
        if (websiteAuditorPage.getOptimizationContent() == null) {
            websiteAuditorPage.setOptimizationContent(pageResult.getContent());
        }
        for (RankingFactorResult rankingFactorResult : pageResult.getRankingFactorResults()) {
            rankingFactorResult.apply(websiteAuditorPage.getPopularityMap());
            if (n2 == 0) continue;
        }
        websiteAuditorPage.setThumbnail(pageResult.getPageThumbnail());
        websiteAuditorPage.setThumbnailMobile(pageResult.getMobilePageThumbnail());
        this.c.publishProjectEvent(arg_0 -> this.a(websiteAuditorPage, arg_0));
    }

    private PageAnalysisUpdatedEvent a(WebsiteAuditorPage websiteAuditorPage, ProjectId projectId) {
        return new PageAnalysisUpdatedEvent(this, projectId, websiteAuditorPage);
    }

    private PageAnalysisDeletedEvent b(WebsiteAuditorPage websiteAuditorPage, ProjectId projectId) {
        return new PageAnalysisDeletedEvent(this, projectId, websiteAuditorPage);
    }

    private PageAnalysisAddedEvent c(WebsiteAuditorPage websiteAuditorPage, ProjectId projectId) {
        return new PageAnalysisAddedEvent(this, projectId, websiteAuditorPage);
    }

    private static boolean a(Collection collection, WebsiteAuditorPage websiteAuditorPage) {
        return collection.contains(websiteAuditorPage.getUrl());
    }

    private void b(Collection collection, WebsiteAuditorPage websiteAuditorPage) {
        block4: {
            if (d || websiteAuditorPage.getImportantKeywords().isEmpty()) break block4;
            throw new AssertionError();
        }
        collection.stream().forEach(arg_0 -> PageAnalysisServiceImpl.a(websiteAuditorPage, arg_0));
        this.a(websiteAuditorPage);
    }

    private static void a(WebsiteAuditorPage websiteAuditorPage, String string) {
        websiteAuditorPage.getImportantKeywords().addImportantKeyword(string);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "Rm\u0003\u0017Slc\u0010R\u0012lm\b\u000b\tgh";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block15;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 2;
                                break;
                            }
                            case 1: {
                                n9 = 12;
                                break;
                            }
                            case 2: {
                                n9 = 100;
                                break;
                            }
                            case 3: {
                                n9 = 114;
                                break;
                            }
                            default: {
                                n9 = 115;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "Rm\u0003\u0017Slc\u0010R\u0012lm\b\u000b\tgh";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "Rm\u0003\u0017Sc`\u0016\u0017\u0012fuD\u0013\u001dc`\u001d\b\u0016f";
                    n3 = 1;
                    continue block11;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        e = stringArray3;
        d = !PageAnalysisServiceImpl.class.desiredAssertionStatus();
    }
}

