/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.websiteauditor.data.service.resource;

import com.agilemind.commons.application.modules.io.searchengine.data.PopularityMap;
import com.agilemind.commons.application.modules.io.searchengine.data.SearchEngineFactor;
import com.agilemind.commons.application.modules.license.TrialManager;
import com.agilemind.commons.data.Record;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.crawler.parser.ParseResults;
import com.agilemind.crawler.to.CrawlerPage;
import com.agilemind.crawler.to.CrawlerResource;
import com.agilemind.crawler.util.CrawlingUtil;
import com.agilemind.factors.FactorType;
import com.agilemind.factors.SearchEngineFactorsList;
import com.agilemind.factors.data.PageInfo;
import com.agilemind.websiteauditor.data.PageContainer;
import com.agilemind.websiteauditor.data.Resource;
import com.agilemind.websiteauditor.data.ResourceType;
import com.agilemind.websiteauditor.data.ResourcesList;
import com.agilemind.websiteauditor.data.WebsiteAuditorPage;
import com.agilemind.websiteauditor.data.WebsiteAuditorPageList;
import com.agilemind.websiteauditor.data.WebsiteAuditorProject;
import com.agilemind.websiteauditor.data.api.IPage;
import com.agilemind.websiteauditor.data.api.IResource;
import com.agilemind.websiteauditor.data.service.resource.ResourcesBackup;
import com.agilemind.websiteauditor.data.service.resource.ResourcesMapper;
import com.agilemind.websiteauditor.data.service.resource.ResourcesService;
import com.agilemind.websiteauditor.data.service.resource.UpdateContext;
import com.agilemind.websiteauditor.data.service.task.crawlersupport.CrawlerTaskUtil;
import com.agilemind.websiteauditor.data.service.task.crawlersupport.OrphanTagDictionary;
import com.agilemind.websiteauditor.util.WebsiteAuditorStringKey;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ResourcesServiceImpl
implements ResourcesService {
    private final WebsiteAuditorProject a;
    private final WebsiteAuditorPageList b;
    private final ResourcesList c;
    private Supplier<OrphanTagDictionary> d;
    private TrialManager e;
    static final boolean f;
    private static final String g;

    public ResourcesServiceImpl(TrialManager trialManager, WebsiteAuditorProject websiteAuditorProject) {
        this.e = trialManager;
        this.a = websiteAuditorProject;
        this.b = websiteAuditorProject.getPages();
        this.c = websiteAuditorProject.getOnlyResources();
        this.d = Suppliers.memoize(OrphanTagDictionary::new);
    }

    @Override
    public List<IPage> getPages() {
        return Collections.unmodifiableList(this.b.getList());
    }

    @Override
    public List<IResource> getOnlyResources() {
        return Collections.unmodifiableList(this.c.getList());
    }

    @Override
    public List<IResource> getAllResources() {
        return Stream.concat(this.b.stream(), this.c.stream()).collect(Collectors.toList());
    }

    @Override
    public boolean hasPages() {
        return !this.b.isEmpty();
    }

    @Override
    public boolean hasResources() {
        return !this.c.isEmpty() || !this.b.isEmpty();
    }

    @Override
    public ResourcesBackup getBackup() {
        ResourcesBackup resourcesBackup = new ResourcesBackup();
        resourcesBackup.b(this.a.getOpenInTabsWebsiteAuditorPageList().getList());
        resourcesBackup.a(this.b.getList());
        return resourcesBackup;
    }

    @Override
    public void clear() {
        if (!f && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        this.c.clear();
        this.b.clear();
    }

    @Override
    public void addResults(Iterable<ParseResults> iterable, UpdateContext updateContext) {
        int n2 = UpdateContext.f;
        int n3 = this.calcLicenseRecordLimit();
        for (ParseResults parseResults : iterable) {
            block3: {
                Resource resource;
                block5: {
                    block4: {
                        if (!updateContext.getFilter().test(parseResults.getResource())) break block3;
                        if (!parseResults.isPage()) break block4;
                        resource = this.a(parseResults, updateContext);
                        if (n2 == 0) break block5;
                    }
                    resource = this.b(parseResults, updateContext);
                }
                resource.setTrialRecord(--n3 <= 0);
            }
            if (n2 == 0) continue;
        }
    }

    @Override
    public void updateResource(IResource iResource, CrawlerResource crawlerResource) {
        CrawlerTaskUtil.fillResourceFactors(crawlerResource, iResource);
    }

    @Override
    public void updatePage(IPage iPage, CrawlerPage crawlerPage, ResourcesMapper resourcesMapper) {
        CrawlerTaskUtil.updatePageInfo(iPage, crawlerPage, false);
        CrawlerTaskUtil.fillResourceFactors(crawlerPage, iPage);
        List list = crawlerPage.getResourcesContainers().stream().filter(CrawlerTaskUtil::needCreateNewPageContainer).map(CrawlerTaskUtil::createNewPageContainer).collect(Collectors.toList());
        list.stream().filter(ResourcesServiceImpl::b).forEach(arg_0 -> ResourcesServiceImpl.a(resourcesMapper, arg_0));
        iPage.setPageContainers(list);
    }

    @Override
    public List<IPage> addPages(Collection<UnicodeURL> collection) {
        int n2 = UpdateContext.f;
        if (!f && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        WebsiteAuditorPageList websiteAuditorPageList = this.a.getPages();
        List<WebsiteAuditorPage> list = collection.stream().map(arg_0 -> ResourcesServiceImpl.a(websiteAuditorPageList, arg_0)).collect(Collectors.toList());
        websiteAuditorPageList.addAll(list);
        list.forEach(this::a);
        if (collection.size() > 10 && !(collection instanceof Set)) {
            collection = new HashSet<UnicodeURL>(collection);
        }
        ResourcesList resourcesList = this.a.getOnlyResources();
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        Iterator iterator = resourcesList.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (collection.contains(resource.getUrl())) {
                arrayList.add(resource);
            }
            if (n2 == 0) continue;
        }
        resourcesList.removeAll(arrayList);
        ArrayList<IPage> arrayList2 = new ArrayList<IPage>(list);
        if (WebsiteAuditorStringKey.b != 0) {
            UpdateContext.f = ++n2;
        }
        return arrayList2;
    }

    private void a(WebsiteAuditorPage websiteAuditorPage) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setNYC(true);
        pageInfo.setClickDepth(Integer.valueOf(-2));
        PopularityMap popularityMap = websiteAuditorPage.getPopularityMap();
        SearchEngineFactor searchEngineFactor = new SearchEngineFactor((Record)popularityMap, SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE, (Comparable)pageInfo);
        popularityMap.put((FactorType)SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE, searchEngineFactor);
    }

    @Override
    public Collection<IPage> getPages(Collection<UnicodeURL> collection) {
        if (!f && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return this.b.stream().filter(arg_0 -> ResourcesServiceImpl.a(collection, arg_0)).collect(Collectors.toSet());
    }

    private WebsiteAuditorPage a(ParseResults parseResults, UpdateContext updateContext) {
        if (!f && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        CrawlerPage crawlerPage = parseResults.getPage();
        UnicodeURL unicodeURL = crawlerPage.getUrl();
        String string = crawlerPage.getContentType();
        WebsiteAuditorPage websiteAuditorPage = new WebsiteAuditorPage(this.b, unicodeURL, ResourceType.recognizeByContentType(string));
        ResourcesBackup resourcesBackup = updateContext.getOldData();
        if (resourcesBackup != null) {
            resourcesBackup.a(websiteAuditorPage);
        }
        if (crawlerPage.getOrphanSources() != null) {
            CrawlerTaskUtil.handleOrphanCase(this.a, crawlerPage.getOrphanSources(), websiteAuditorPage, this.d.get());
        }
        CrawlerTaskUtil.updatePageInfo(websiteAuditorPage, crawlerPage, false);
        CrawlerTaskUtil.updateStatisticsFactorsPage(websiteAuditorPage, crawlerPage, arg_0 -> this.a(updateContext, arg_0));
        CrawlerTaskUtil.fillResourceFactors(crawlerPage, websiteAuditorPage);
        List list = crawlerPage.getResourcesContainers().stream().filter(CrawlerTaskUtil::needCreateNewPageContainer).map(CrawlerTaskUtil::createNewPageContainer).collect(Collectors.toList());
        list.stream().filter(ResourcesServiceImpl::a).forEach(arg_0 -> ResourcesServiceImpl.a(updateContext, arg_0));
        websiteAuditorPage.getPageContainers().addAll(list);
        updateContext.getMapper().registerResource(websiteAuditorPage);
        this.b.add(websiteAuditorPage);
        return websiteAuditorPage;
    }

    private Resource b(ParseResults parseResults, UpdateContext updateContext) {
        if (!f && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        CrawlerResource crawlerResource = parseResults.getResource();
        UnicodeURL unicodeURL = crawlerResource.getUrl();
        ResourceType resourceType = ResourceType.recognizeTypeByContentTypOrByExtensions(crawlerResource.getContentType(), unicodeURL);
        Resource resource = new Resource((Record)this.c, unicodeURL, resourceType);
        resource.setExternal(!CrawlingUtil.isInternal(updateContext.getProjectUrl(), unicodeURL, updateContext.getCrawlerContext().getCrawlingSettings().isUseSubDomain()));
        CrawlerTaskUtil.fillResourceFactors(crawlerResource, resource);
        updateContext.getMapper().registerResource(resource);
        this.c.add(resource);
        return resource;
    }

    @Override
    public IResource addResource(UnicodeURL unicodeURL, boolean bl, boolean bl2) {
        Resource resource = new Resource((Record)this.c, unicodeURL, ResourceType.recognizeType(unicodeURL));
        resource.setTrialRecord(bl);
        resource.setExternal(!CrawlingUtil.isInternal(this.a.getProjectUrl(), unicodeURL, bl2));
        this.c.add(resource);
        return resource;
    }

    @Override
    public IPage addPage(UnicodeURL unicodeURL, boolean bl) {
        WebsiteAuditorPage websiteAuditorPage = new WebsiteAuditorPage(this.b, unicodeURL, ResourceType.recognizeType(unicodeURL));
        websiteAuditorPage.setTrialRecord(bl);
        this.b.add(websiteAuditorPage);
        return websiteAuditorPage;
    }

    @Override
    public void removeResources(Set<UnicodeURL> set) {
        Set<Resource> set2 = this.c.stream().filter(arg_0 -> ResourcesServiceImpl.a(set, arg_0)).collect(Collectors.toSet());
        set2.forEach(arg_0 -> ((ResourcesList)this.c).remove(arg_0));
    }

    @Override
    public int calcLicenseRecordLimit() {
        int n2;
        boolean bl = this.e.isTrial();
        int n3 = n2 = bl ? 500 : Integer.MAX_VALUE;
        if (bl) {
            n2 = (int)((long)n2 - this.a.getAllResources().stream().filter(ResourcesServiceImpl::a).count());
        }
        return n2;
    }

    @Override
    public boolean isAllPagesNoHttps() {
        return ResourcesServiceImpl.isAllPagesNoHttps(this.getPages());
    }

    @Override
    public Map<UnicodeURL, List<IPage>> getResourcePagesMap() {
        return ResourcesServiceImpl.getResourcePagesMap(this.getPages());
    }

    @NotNull
    public static <P extends IPage> Map<UnicodeURL, List<P>> getResourcePagesMap(Iterable<? extends P> iterable) {
        HashMap<UnicodeURL, List<P>> hashMap = new HashMap<UnicodeURL, List<P>>();
        iterable.forEach(arg_0 -> ResourcesServiceImpl.a(hashMap, arg_0));
        return hashMap;
    }

    public static <P extends IPage> boolean isAllPagesNoHttps(Iterable<P> iterable) {
        return StreamSupport.stream(iterable.spliterator(), true).filter(ResourcesServiceImpl::a).count() == 0L;
    }

    private static boolean a(IPage iPage) {
        return g.equalsIgnoreCase(iPage.getUrl().getProtocol());
    }

    private static void a(Map map, IPage iPage) {
        iPage.getPageContainers().forEach(arg_0 -> ResourcesServiceImpl.a(map, iPage, arg_0));
    }

    private static void a(Map map, IPage iPage, PageContainer pageContainer) {
        map.computeIfAbsent(pageContainer.getUrl(), ResourcesServiceImpl::a).add(iPage);
    }

    private static List a(UnicodeURL unicodeURL) {
        return new ArrayList();
    }

    private static boolean a(Resource resource) {
        return !resource.isTrialRecord();
    }

    private static boolean a(Set set, Resource resource) {
        return set.contains(resource.getUrl());
    }

    private static void a(UpdateContext updateContext, PageContainer pageContainer) {
        updateContext.getMapper().updateResource(pageContainer.getUrl(), pageContainer::setResource);
    }

    private static boolean a(PageContainer pageContainer) {
        return pageContainer.getUrl() != null;
    }

    private boolean a(UpdateContext updateContext, UnicodeURL unicodeURL) {
        return CrawlingUtil.isInternal(this.a.getProjectUrl(), unicodeURL, updateContext.getCrawlerContext().getCrawlingSettings().isUseSubDomain());
    }

    private static boolean a(Collection collection, WebsiteAuditorPage websiteAuditorPage) {
        return collection.contains(websiteAuditorPage.getUrl());
    }

    private static WebsiteAuditorPage a(WebsiteAuditorPageList websiteAuditorPageList, UnicodeURL unicodeURL) {
        return new WebsiteAuditorPage(websiteAuditorPageList, unicodeURL, ResourceType.recognizeType(unicodeURL));
    }

    private static void a(ResourcesMapper resourcesMapper, PageContainer pageContainer) {
        resourcesMapper.updateResource(pageContainer.getUrl(), pageContainer::setResource);
    }

    private static boolean b(PageContainer pageContainer) {
        return pageContainer.getUrl() != null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "\u001eAp3A".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 118;
                            break;
                        }
                        case 1: {
                            n7 = 53;
                            break;
                        }
                        case 2: {
                            n7 = 4;
                            break;
                        }
                        case 3: {
                            n7 = 67;
                            break;
                        }
                        default: {
                            n7 = 50;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        g = new String(cArray).intern();
        f = !ResourcesServiceImpl.class.desiredAssertionStatus();
    }
}

