/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.websiteauditor.data.service.resource;

import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.crawler.CrawlerContext;
import com.agilemind.crawler.to.CrawlerResource;
import com.agilemind.crawler.util.CrawlingUtil;
import com.agilemind.websiteauditor.data.ResourceType;
import com.agilemind.websiteauditor.data.api.ISiteCrawlingSettings;
import com.agilemind.websiteauditor.data.service.resource.ResourcesBackup;
import com.agilemind.websiteauditor.data.service.resource.ResourcesMapper;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class UpdateContext {
    private final ResourcesMapper a;
    private final ResourcesBackup b;
    private final CrawlerContext c;
    private UnicodeURL d;
    private Predicate<CrawlerResource> e;
    public static int f;

    public UpdateContext(UnicodeURL unicodeURL, ResourcesMapper resourcesMapper, CrawlerContext crawlerContext, @Nullable ResourcesBackup resourcesBackup) {
        this.d = unicodeURL;
        this.a = resourcesMapper;
        this.b = resourcesBackup;
        this.c = crawlerContext;
        this.e = this.A();
    }

    private Predicate<CrawlerResource> A() {
        Collection<String> collection;
        ISiteCrawlingSettings iSiteCrawlingSettings = this.c.getCrawlingSettings();
        HashSet hashSet = Sets.newHashSet(iSiteCrawlingSettings.getWebResources());
        Predicate<CrawlerResource> predicate = arg_0 -> UpdateContext.a(hashSet, arg_0);
        if (iSiteCrawlingSettings.isUseExcludeFilter()) {
            collection = iSiteCrawlingSettings.getExcludeFilters();
            predicate = predicate.and(arg_0 -> UpdateContext.b(collection, arg_0));
        }
        if (iSiteCrawlingSettings.isUseIncludeFilter()) {
            collection = iSiteCrawlingSettings.getIncludeFilters();
            predicate = predicate.and(arg_0 -> UpdateContext.a(collection, arg_0));
        }
        return predicate;
    }

    public Predicate<CrawlerResource> getFilter() {
        return this.e;
    }

    public UnicodeURL getProjectUrl() {
        return this.d;
    }

    public ResourcesMapper getMapper() {
        return this.a;
    }

    @Nullable
    public ResourcesBackup getOldData() {
        return this.b;
    }

    public CrawlerContext getCrawlerContext() {
        return this.c;
    }

    private static boolean a(Collection collection, CrawlerResource crawlerResource) {
        return CrawlingUtil.allowFilter(collection, crawlerResource.getUrl(), true);
    }

    private static boolean b(Collection collection, CrawlerResource crawlerResource) {
        return CrawlingUtil.allowFilter(collection, crawlerResource.getUrl(), false);
    }

    private static boolean a(Set set, CrawlerResource crawlerResource) {
        return set.contains((Object)ResourceType.recognizeTypeByContentTypOrByExtensions(crawlerResource.getContentType(), crawlerResource.getUrl()));
    }
}

