/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.websiteauditor.modules.audit.page.technical;

import com.agilemind.websiteauditor.modules.audit.page.technical.TechnicalPageAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.TechnicalPageAuditFactorType;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.BlockedMixedContentResourcesAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.BrokenLinksAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.BrokenResourcesAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.ConflictingCharacterEncodingAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.DofollowExternalLinksOnPage;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.DuplicateRelCanonicalAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.DynamicUrlAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.MobileFriendlyPageAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.NumberLinksOnPageAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.PageRestrictedFromIndexingAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.PageStatusCodeAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.PageUsesFramesAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.PageUsesMetaRefreshAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.PageUsesRelCanonicalAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.ResourceRestrictedFromIndexingAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.UrlLengthAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.W3CCssErrorsWarningsAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.W3CHtmlErrorsWarningsAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.googlepagespeed.FullPageSizeAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.googlepagespeed.NumberFallOutsideAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.googlepagespeed.NumberNotMinifiedAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.googlepagespeed.NumberPluginsAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.googlepagespeed.NumberRedirectAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.googlepagespeed.NumberRenderBlockingAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.googlepagespeed.NumberSmallFontAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.googlepagespeed.NumberSmallTapAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.googlepagespeed.NumberUncachableResourcesAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.googlepagespeed.NumberUncompressedImagesAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.googlepagespeed.NumberUncompressedResourcesAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.googlepagespeed.ResponseTimeAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.googlepagespeed.ViewportConfiguredPageAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.googlepagespeed.VisibleContentPrioritizedAuditFactor;
import com.agilemind.websiteauditor.util.WebsiteAuditorStringKey;

public class TechnicalAuditFactorFactory {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TechnicalPageAuditFactor createPageAuditFactor(TechnicalPageAuditFactorType technicalPageAuditFactorType) {
        int n2 = TechnicalPageAuditFactorType.b;
        switch (technicalPageAuditFactorType) {
            case PAGE_STATUS_CODE: {
                return new PageStatusCodeAuditFactor();
            }
            case PAGE_RESTRICTED_FROM_INDEXING: {
                return new PageRestrictedFromIndexingAuditFactor();
            }
            case RESOURCES_RESTRICTED_FROM_INDEXING: {
                return new ResourceRestrictedFromIndexingAuditFactor();
            }
            case PAGE_USES_META_REFRESH: {
                return new PageUsesMetaRefreshAuditFactor();
            }
            case PAGE_USES_REL_CANONICAL: {
                return new PageUsesRelCanonicalAuditFactor();
            }
            case BLOCKED_MIXED_CONTENT: {
                return new BlockedMixedContentResourcesAuditFactor();
            }
            case DUPLICATE_REL_CANONICAL_CODE: {
                return new DuplicateRelCanonicalAuditFactor();
            }
            case CONFLICTING_CHARACTER_ENCODING: {
                return new ConflictingCharacterEncodingAuditFactor();
            }
            case PAGE_USES_FRAMES: {
                return new PageUsesFramesAuditFactor();
            }
            case W3C_HTML_ERRORS_WARNINGS: {
                return new W3CHtmlErrorsWarningsAuditFactor();
            }
            case W3C_CSS_ERRORS_WARNINGS: {
                return new W3CCssErrorsWarningsAuditFactor();
            }
            case DYNAMIC_URL: {
                return new DynamicUrlAuditFactor();
            }
            case URL_LENGTH: {
                return new UrlLengthAuditFactor();
            }
            case BROKEN_RESOURCES: {
                return new BrokenResourcesAuditFactor();
            }
            case BROKEN_LINKS: {
                return new BrokenLinksAuditFactor();
            }
            case NUMBER_OF_LINKS_ON_PAGE: {
                return new NumberLinksOnPageAuditFactor();
            }
            case DOFOLLOW_EXT_LINKS_OM_PAGE: {
                return new DofollowExternalLinksOnPage();
            }
            case PAGE_SIZE: {
                return new FullPageSizeAuditFactor();
            }
            case SERVER_RESPONSE_TIME: {
                return new ResponseTimeAuditFactor();
            }
            case PAGE_MANY_REDIRECTS: {
                return new NumberRedirectAuditFactor();
            }
            case NUMBER_UNCOMPRESSED_RESOURCES: {
                return new NumberUncompressedResourcesAuditFactor();
            }
            case NUMBER_UNCOMPRESSED_IMAGES: {
                return new NumberUncompressedImagesAuditFactor();
            }
            case NUMBER_UNCACHEABLE_RESOURCES: {
                return new NumberUncachableResourcesAuditFactor();
            }
            case NUMBER_RESOURCES_NOT_MINIFIED: {
                return new NumberNotMinifiedAuditFactor();
            }
            case NUMBER_RENDERBLOCKING_JS_CSS: {
                return new NumberRenderBlockingAuditFactor();
            }
            case VISIBLE_CONTENT_IS_PRIORITIZED: {
                return new VisibleContentPrioritizedAuditFactor();
            }
            case MOBILE_FRIENDLY: {
                return new MobileFriendlyPageAuditFactor();
            }
            case VIEWPORT_IS_CONFIGURED: {
                return new ViewportConfiguredPageAuditFactor();
            }
            case NUMBER_TOO_SMALL_FONT: {
                return new NumberSmallFontAuditFactor();
            }
            case NUMBER_TOO_SMALL_TAP: {
                return new NumberSmallTapAuditFactor();
            }
            case NUMBER_FALL_OUTSIDE_VIEWPORT: {
                return new NumberFallOutsideAuditFactor();
            }
            case NUMBER_PLUGINS: {
                NumberPluginsAuditFactor numberPluginsAuditFactor = new NumberPluginsAuditFactor();
                if (n2 != 0) {
                    int n3 = WebsiteAuditorStringKey.b;
                    WebsiteAuditorStringKey.b = ++n3;
                }
                return numberPluginsAuditFactor;
            }
        }
        throw new IllegalArgumentException(technicalPageAuditFactorType.name());
    }
}

