/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.websiteauditor.modules.audit.page.technical.factor;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.audit.page.PageAuditResult;
import com.agilemind.commons.application.modules.audit.page.onpage.result.ListPageAuditResult;
import com.agilemind.factors.data.PageInfo;
import com.agilemind.sitescan.data.audit.SiteAuditUtil;
import com.agilemind.websiteauditor.data.PageContainer;
import com.agilemind.websiteauditor.data.api.IPage;
import com.agilemind.websiteauditor.modules.audit.page.technical.TechnicalPageAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.PageRestrictedFromIndexingAuditFactor;
import java.util.ArrayList;

public class BrokenLinksAuditFactor
implements TechnicalPageAuditFactor {
    @Override
    public PageAuditResult getResult(IPage iPage) throws Exception {
        int n2 = PageRestrictedFromIndexingAuditFactor.b;
        PageInfo pageInfo = iPage.getPageInfo();
        if (PageInfo.isNyc((PageInfo)pageInfo)) {
            return new ListPageAuditResult(AuditStatusType.NOT_YET_CHECKED);
        }
        if (pageInfo.isNa()) {
            return new ListPageAuditResult(AuditStatusType.N_A);
        }
        ArrayList<PageContainer> arrayList = new ArrayList<PageContainer>();
        for (PageContainer pageContainer : iPage.getPageContainers()) {
            if (SiteAuditUtil.isBrokenLink(pageContainer)) {
                arrayList.add(pageContainer);
            }
            if (n2 == 0) continue;
        }
        ListPageAuditResult listPageAuditResult = arrayList.isEmpty() ? new ListPageAuditResult(AuditStatusType.OK, arrayList) : new ListPageAuditResult(AuditStatusType.WARNING, arrayList);
        return listPageAuditResult;
    }
}

