/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.websiteauditor.modules.audit.page.technical.factor;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.audit.page.PageAuditResult;
import com.agilemind.commons.application.modules.audit.page.onpage.result.YesNoPageAuditResult;
import com.agilemind.factors.data.BooleanResult;
import com.agilemind.factors.data.PageInfo;
import com.agilemind.websiteauditor.data.api.IPage;
import com.agilemind.websiteauditor.modules.audit.page.technical.TechnicalPageAuditFactor;

public class ConflictingCharacterEncodingAuditFactor
implements TechnicalPageAuditFactor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PageAuditResult getResult(IPage iPage) throws Exception {
        PageInfo pageInfo = iPage.getPageInfo();
        if (PageInfo.isNyc((PageInfo)pageInfo)) {
            return new YesNoPageAuditResult(AuditStatusType.NOT_YET_CHECKED);
        }
        if (pageInfo.isNa()) {
            return new YesNoPageAuditResult(AuditStatusType.N_A);
        }
        BooleanResult booleanResult = pageInfo.isConflictingCharacterEncoding();
        if (booleanResult == null) {
            return new YesNoPageAuditResult(AuditStatusType.NOT_YET_CHECKED);
        }
        switch (booleanResult) {
            case TRUE: {
                return new YesNoPageAuditResult(AuditStatusType.WARNING, AuditStatusType.WARNING);
            }
            case FALSE: {
                return new YesNoPageAuditResult(AuditStatusType.OK, AuditStatusType.WARNING);
            }
        }
        return new YesNoPageAuditResult(AuditStatusType.N_A, AuditStatusType.WARNING);
    }
}

