/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.websiteauditor.modules.audit.page.technical.factor;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.audit.page.PageAuditResult;
import com.agilemind.commons.application.modules.audit.page.onpage.result.YesNoPageAuditResult;
import com.agilemind.commons.application.modules.io.searchengine.data.PopularityMap;
import com.agilemind.commons.application.modules.io.searchengine.data.api.ISearchEngineFactor;
import com.agilemind.factors.FactorType;
import com.agilemind.factors.SearchEngineFactorsList;
import com.agilemind.factors.data.BooleanResult;
import com.agilemind.websiteauditor.data.api.IPage;
import com.agilemind.websiteauditor.modules.audit.page.technical.TechnicalPageAuditFactor;

public class MobileFriendlyPageAuditFactor
implements TechnicalPageAuditFactor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PageAuditResult getResult(IPage iPage) throws Exception {
        PopularityMap popularityMap = iPage.getPopularityMap();
        ISearchEngineFactor iSearchEngineFactor = popularityMap.getFactor((FactorType)SearchEngineFactorsList.MOBILE_FRIENDLY);
        if (iSearchEngineFactor == null) {
            return new YesNoPageAuditResult(AuditStatusType.NOT_YET_CHECKED);
        }
        BooleanResult booleanResult = (BooleanResult)iSearchEngineFactor.getFactorValue();
        switch (booleanResult) {
            case TRUE: {
                return new YesNoPageAuditResult(AuditStatusType.OK, AuditStatusType.WARNING, AuditStatusType.OK);
            }
            case FALSE: {
                return new YesNoPageAuditResult(AuditStatusType.WARNING, AuditStatusType.WARNING, AuditStatusType.OK);
            }
        }
        return new YesNoPageAuditResult(AuditStatusType.N_A, AuditStatusType.WARNING, AuditStatusType.OK);
    }
}

