/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.websiteauditor.modules.audit.page.technical.factor;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.audit.page.PageAuditResult;
import com.agilemind.commons.application.modules.audit.page.onpage.result.YesNoPageAuditResult;
import com.agilemind.factors.data.PageInfo;
import com.agilemind.websiteauditor.data.api.IPage;
import com.agilemind.websiteauditor.modules.audit.page.technical.TechnicalPageAuditFactor;

public class PageUsesFramesAuditFactor
implements TechnicalPageAuditFactor {
    @Override
    public PageAuditResult getResult(IPage iPage) throws Exception {
        PageInfo pageInfo = iPage.getPageInfo();
        if (PageInfo.isNyc((PageInfo)pageInfo)) {
            return new YesNoPageAuditResult(AuditStatusType.NOT_YET_CHECKED, AuditStatusType.WARNING);
        }
        if (pageInfo.isNa()) {
            return new YesNoPageAuditResult(AuditStatusType.N_A, AuditStatusType.WARNING);
        }
        Integer n2 = pageInfo.getFrames();
        if (n2 == null) {
            return new YesNoPageAuditResult(AuditStatusType.NOT_YET_CHECKED, AuditStatusType.WARNING);
        }
        YesNoPageAuditResult yesNoPageAuditResult = n2 > 0 ? new YesNoPageAuditResult(AuditStatusType.WARNING, AuditStatusType.WARNING) : new YesNoPageAuditResult(AuditStatusType.OK, AuditStatusType.WARNING);
        return yesNoPageAuditResult;
    }
}

