/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.websiteauditor.modules.audit.page.technical.factor.googlepagespeed;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.audit.page.PageAuditResult;
import com.agilemind.commons.application.modules.io.searchengine.data.SearchEngineFactor;
import com.agilemind.factors.FactorType;
import com.agilemind.factors.SearchEngineFactorsList;
import com.agilemind.factors.data.BooleanResult;
import com.agilemind.factors.data.googlepagespeed.GooglePageSpeedMobile;
import com.agilemind.websiteauditor.data.api.IPage;
import com.agilemind.websiteauditor.modules.audit.page.technical.TechnicalPageAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.googlepagespeed.AbstractListAuditFactor;
import com.agilemind.websiteauditor.modules.audit.page.technical.factor.googlepagespeed.result.ViewportIsConfiguredAuditResult;

public class ViewportConfiguredPageAuditFactor
implements TechnicalPageAuditFactor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PageAuditResult getResult(IPage iPage) throws Exception {
        BooleanResult booleanResult;
        boolean bl = AbstractListAuditFactor.b;
        SearchEngineFactor searchEngineFactor = iPage.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.GOOGLE_PAGE_SPEED_MOBILE);
        if (searchEngineFactor == null) {
            return new ViewportIsConfiguredAuditResult(AuditStatusType.NOT_YET_CHECKED);
        }
        GooglePageSpeedMobile googlePageSpeedMobile = (GooglePageSpeedMobile)searchEngineFactor.getFactorValue();
        AuditStatusType auditStatusType = AuditStatusType.NOT_YET_CHECKED;
        int n2 = 0;
        if (googlePageSpeedMobile == null || (booleanResult = googlePageSpeedMobile.getConfigureViewport()) == null) return new ViewportIsConfiguredAuditResult(auditStatusType, n2);
        switch (booleanResult) {
            case TRUE: {
                auditStatusType = AuditStatusType.OK;
                if (!bl) return new ViewportIsConfiguredAuditResult(auditStatusType, n2);
            }
            case FALSE: {
                auditStatusType = AuditStatusType.WARNING;
                n2 = googlePageSpeedMobile.getViewPortWidth();
                if (!bl) return new ViewportIsConfiguredAuditResult(auditStatusType, n2);
            }
            case NA: {
                auditStatusType = AuditStatusType.N_A;
                return new ViewportIsConfiguredAuditResult(auditStatusType, n2);
            }
        }
        return new ViewportIsConfiguredAuditResult(auditStatusType, n2);
    }
}

