/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.websiteauditor.modules.report.services.project;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.audit.page.PageAuditResult;
import com.agilemind.commons.application.modules.audit.page.PageOptimizationUtil;
import com.agilemind.commons.application.modules.audit.page.onpage.IAuditKeyword;
import com.agilemind.commons.application.modules.audit.page.onpage.IAuditPage;
import com.agilemind.commons.application.modules.audit.page.onpage.result.KeywordsInTagAuditResult;
import com.agilemind.commons.application.modules.audit.page.onpage.statistics.KeywordInTagStatistic;
import com.agilemind.commons.application.modules.audit.page.onpage.statistics.KeywordInTagStatisticBuilder;
import com.agilemind.commons.io.utils.BinaryFile;
import com.agilemind.commons.util.PairArrayList;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.Util;
import com.agilemind.factors.data.PageInfo;
import com.agilemind.htmlparser.data.HTMLElementInfo;
import com.agilemind.htmlparser.data.HTMLTag;
import com.agilemind.htmlparser.data.IPageData;
import com.agilemind.htmlparser.tfidf.TfIdfUtil;
import com.agilemind.websiteauditor.data.api.IPage;
import com.agilemind.websiteauditor.data.service.WebsiteAuditorProjectService;
import com.agilemind.websiteauditor.modules.audit.data.HTMLElementKeywordsData;
import com.agilemind.websiteauditor.modules.audit.data.HTMLTagInfo;
import com.agilemind.websiteauditor.modules.audit.data.PageAuditResultView;
import com.agilemind.websiteauditor.modules.audit.page.PageAuditFactorType;
import com.agilemind.websiteauditor.modules.audit.util.KeywordsAndCompetitorsUtil;
import com.agilemind.websiteauditor.modules.audit.util.PageAuditUtil;
import com.agilemind.websiteauditor.modules.pageaudit.data.IPageAuditFactorsModel;
import com.agilemind.websiteauditor.modules.pageaudit.data.PageAuditFactorsModel;
import com.agilemind.websiteauditor.modules.report.services.IKeywordUsageWidgetService;
import com.agilemind.websiteauditor.modules.report.services.IKeywordUsageWidgetService$PageElement;
import com.agilemind.websiteauditor.modules.report.services.IOnPageOptimizationDetailsWidgetService;
import com.agilemind.websiteauditor.modules.report.services.IPageAnalysisSummaryWidgetService;
import com.agilemind.websiteauditor.modules.report.services.IPageAuditFactorsSummaryWidgetService;
import com.agilemind.websiteauditor.modules.report.services.IPageDetailsWidgetService;
import com.agilemind.websiteauditor.modules.report.services.KeywordUsage;
import com.agilemind.websiteauditor.modules.report.util.details.competitors.KeywordTableData;
import com.agilemind.websiteauditor.util.WebsiteAuditorStringKey;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.DoubleSummaryStatistics;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.htmlparser.util.ParserException;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageAnalysisWidgetService
implements IPageAnalysisSummaryWidgetService,
IPageAuditFactorsSummaryWidgetService,
IOnPageOptimizationDetailsWidgetService,
IPageDetailsWidgetService,
IKeywordUsageWidgetService {
    private static final Logger a;
    private final IPage b;
    private final Supplier<IPageAuditFactorsModel> c;
    private final UnicodeURL d;
    private Double e;
    static final boolean f;
    public static int g;
    private static final String[] h;

    public PageAnalysisWidgetService(WebsiteAuditorProjectService websiteAuditorProjectService, IPage iPage) {
        this.b = iPage;
        this.c = Suppliers.memoize(() -> this.b(iPage));
        this.d = websiteAuditorProjectService.getDomain();
    }

    private PageAuditFactorsModel a(IPage iPage) {
        try {
            return PageAuditUtil.createPageAuditFactorsModel(iPage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new PageAuditFactorsModel();
        }
    }

    @Override
    public UnicodeURL getPageUrl() {
        return this.b.getUrl();
    }

    @Override
    public UnicodeURL getDomain() {
        return this.d;
    }

    @Override
    public long getPageSize() {
        Long l2;
        PageInfo pageInfo = this.b.getPageInfo();
        long l3 = -1L;
        if (pageInfo != null && (l2 = pageInfo.getFullSize()) != null) {
            l3 = l2;
        }
        return l3;
    }

    @Override
    public BinaryFile getMobileThumbnail() {
        return this.b.getThumbnailMobile();
    }

    @Override
    public BinaryFile getPageThumbnail() {
        return this.b.getThumbnail();
    }

    @Override
    public String getPageTitle() {
        PageInfo pageInfo = this.b.getPageInfo();
        String string = pageInfo != null ? pageInfo.getTitle() : null;
        return string;
    }

    @Override
    public Date getReportCreationDate() {
        return new Date();
    }

    @Override
    public double getOptimizationRate() {
        if (this.e == null) {
            try {
                this.e = PageOptimizationUtil.getOptimizationRate((IAuditPage)this.b, this.b.getImportantKeywordsList());
            }
            catch (Exception exception) {
                a.error("", (Throwable)exception);
                this.e = -1.0;
            }
        }
        return this.e;
    }

    @Override
    public int getErrorStatuesCount(Collection<PageAuditFactorType> collection) {
        return this.a(AuditStatusType.ERROR, collection);
    }

    @Override
    public int getWarningStatuesCount(Collection<PageAuditFactorType> collection) {
        return this.a(AuditStatusType.WARNING, collection);
    }

    @Override
    public int getInfoStatuesCount(Collection<PageAuditFactorType> collection) {
        return this.a(AuditStatusType.INFO, collection);
    }

    private int a(AuditStatusType auditStatusType, Collection<PageAuditFactorType> collection) {
        int n2 = g;
        int n3 = 0;
        for (PageAuditFactorType pageAuditFactorType : collection) {
            block8: {
                if (f || pageAuditFactorType != null) break block8;
                throw new AssertionError();
            }
            if (!pageAuditFactorType.isSupported() && n2 == 0) continue;
            PageAuditResultView pageAuditResultView = this.c.get().getFactorResult(pageAuditFactorType);
            PageAuditResult pageAuditResult = pageAuditResultView.getAuditResult();
            AuditStatusType auditStatusType2 = pageAuditResult.getAuditStatusType();
            if (auditStatusType2 == auditStatusType) {
                n3 += pageAuditResult.getResultValue();
            }
            if (n2 == 0) continue;
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public KeywordUsage getKeywordUsage(String string, IKeywordUsageWidgetService$PageElement iKeywordUsageWidgetService$PageElement) throws ParserException, InterruptedException {
        switch (iKeywordUsageWidgetService$PageElement) {
            case PAGE: {
                return this.a(string, HTMLTag.TITLE, HTMLTag.META_DESCRIPTION, HTMLTag.META_KEYWORDS, HTMLTag.BODY, HTMLTag.IMAGE);
            }
            case TITLE: {
                return this.a(string, HTMLTag.TITLE);
            }
            case META: {
                return this.a(string, HTMLTag.META_DESCRIPTION, HTMLTag.META_KEYWORDS);
            }
            case BODY: {
                return this.a(string, HTMLTag.BODY);
            }
            case IMAGES: {
                return this.a(string, HTMLTag.IMAGE);
            }
        }
        throw new IllegalArgumentException(h[0] + (Object)((Object)iKeywordUsageWidgetService$PageElement));
    }

    @Override
    public List<String> getAnalyzeKeywords() {
        return Util.transform(this.b.getImportantKeywordsList(), IAuditKeyword::getKeyword);
    }

    private KeywordUsage a(String string, HTMLTag ... keywordInTagStatistic) throws ParserException, InterruptedException {
        int n2 = g;
        int n3 = 0;
        int n4 = 0;
        IPageData iPageData = this.b.getPageData();
        IAuditKeyword iAuditKeyword = this.b.getImportantKeywordsList().stream().filter(arg_0 -> PageAnalysisWidgetService.a(string, arg_0)).findAny().orElse(null);
        for (HTMLTag hTMLTag : keywordInTagStatistic) {
            HTMLElementInfo hTMLElementInfo = iPageData.getHTMLElementInfo(hTMLTag);
            n3 += hTMLElementInfo.getKeywordCount(string);
            n4 += hTMLElementInfo.getWordsCount();
            if (n2 == 0) continue;
        }
        if (iAuditKeyword == null) {
            return new KeywordUsage(n3, 0.0);
        }
        KeywordInTagStatistic keywordInTagStatistic2 = KeywordInTagStatisticBuilder.buildSum((String)string, (Iterable)iAuditKeyword.getCompetitorPages(), (HTMLTag[])keywordInTagStatistic);
        return new KeywordUsage(n3, TfIdfUtil.calcTfIdf((long)n3, (long)n4, (double)keywordInTagStatistic2.getIdf()));
    }

    @Override
    public List<KeywordTableData> getCompetitorsData(PageAuditFactorType pageAuditFactorType) throws Exception {
        int n2 = g;
        HTMLTag hTMLTag = PageAuditFactorType.getHtmlTag(pageAuditFactorType);
        if (hTMLTag == null) {
            throw new IllegalArgumentException(pageAuditFactorType.name());
        }
        TreeSet<KeywordTableData> treeSet = new TreeSet<KeywordTableData>(PageAnalysisWidgetService::a);
        for (IAuditKeyword iAuditKeyword : this.b.getImportantKeywordsList()) {
            treeSet.add(PageAnalysisWidgetService.a(this.b, iAuditKeyword, hTMLTag));
            if (n2 == 0) continue;
            int n3 = WebsiteAuditorStringKey.b;
            WebsiteAuditorStringKey.b = ++n3;
            break;
        }
        return new ArrayList<KeywordTableData>(treeSet);
    }

    private static KeywordTableData a(IPage iPage, IAuditKeyword iAuditKeyword, HTMLTag hTMLTag) throws ParserException, InterruptedException {
        KeywordTableData keywordTableData;
        block4: {
            keywordTableData = new KeywordTableData();
            keywordTableData.setKeyword(iAuditKeyword.getKeyword());
            keywordTableData.setThisPage(PageAnalysisWidgetService.b(iPage, iAuditKeyword, hTMLTag));
            keywordTableData.setCompetitorInfoList(PageAnalysisWidgetService.a(iAuditKeyword, hTMLTag));
            PageAnalysisWidgetService.a(keywordTableData, iAuditKeyword, hTMLTag);
            if (f || keywordTableData.assertNotNull().isEmpty()) break block4;
            throw new AssertionError((Object)(Arrays.toString(keywordTableData.assertNotNull().toArray()) + h[1]));
        }
        return keywordTableData;
    }

    private static HTMLTagInfo b(IPage iPage, IAuditKeyword iAuditKeyword, HTMLTag hTMLTag) throws ParserException, InterruptedException {
        if (IPageData.EMPTY.equals(iPage.getPageData())) {
            return new HTMLTagInfo(-1, -1, -1.0);
        }
        return KeywordsAndCompetitorsUtil.getKeywordUsage(iPage, iAuditKeyword, hTMLTag);
    }

    private static void a(KeywordTableData keywordTableData, IAuditKeyword iAuditKeyword, HTMLTag hTMLTag) throws ParserException, InterruptedException {
        IntSummaryStatistics intSummaryStatistics = PageOptimizationUtil.getStatCompetitorsKeywordCount((IAuditKeyword)iAuditKeyword, (HTMLTag)hTMLTag);
        IntSummaryStatistics intSummaryStatistics2 = PageOptimizationUtil.getStatCompetitorsWordCount((IAuditKeyword)iAuditKeyword, (HTMLTag)hTMLTag);
        DoubleSummaryStatistics doubleSummaryStatistics = PageOptimizationUtil.getStatTf((IAuditKeyword)iAuditKeyword, (HTMLTag)hTMLTag);
        double d2 = KeywordsAndCompetitorsUtil.calcIdf(iAuditKeyword, hTMLTag);
        keywordTableData.setMinCompetitors(new HTMLTagInfo(intSummaryStatistics.getMin(), intSummaryStatistics2.getMin(), PageAnalysisWidgetService.a(doubleSummaryStatistics.getMin(), d2)));
        keywordTableData.setMaxCompetitors(new HTMLTagInfo(intSummaryStatistics.getMax(), intSummaryStatistics2.getMax(), PageAnalysisWidgetService.a(doubleSummaryStatistics.getMax(), d2)));
        keywordTableData.setAvgCompetitors(new HTMLTagInfo(KeywordsAndCompetitorsUtil.average(intSummaryStatistics), KeywordsAndCompetitorsUtil.average(intSummaryStatistics2), PageAnalysisWidgetService.a(doubleSummaryStatistics.getAverage(), d2)));
    }

    private static double a(double d2, double d3) {
        if (d2 == -1.0) {
            return -1.0;
        }
        return d2 * d3;
    }

    private static PairArrayList<UnicodeURL, HTMLTagInfo> a(IAuditKeyword iAuditKeyword, HTMLTag hTMLTag) throws ParserException, InterruptedException {
        int n2 = g;
        double d2 = KeywordsAndCompetitorsUtil.calcIdf(iAuditKeyword, hTMLTag);
        PairArrayList pairArrayList = new PairArrayList();
        for (IAuditPage iAuditPage : iAuditKeyword.getCompetitorPages()) {
            pairArrayList.add((Object)iAuditPage.getUrl(), (Object)KeywordsAndCompetitorsUtil.formCompetitorTagInfo(hTMLTag, iAuditPage, iAuditKeyword, d2));
            if (n2 == 0) continue;
        }
        return pairArrayList;
    }

    @Override
    public List<HTMLElementKeywordsData> getKeywordsData(PageAuditFactorType pageAuditFactorType) throws Exception {
        int n2 = g;
        HTMLTag hTMLTag = PageAuditFactorType.getHtmlTag(pageAuditFactorType);
        if (hTMLTag == null) {
            throw new IllegalArgumentException(pageAuditFactorType.name());
        }
        KeywordsInTagAuditResult keywordsInTagAuditResult = (KeywordsInTagAuditResult)this.getPagesAuditResult(pageAuditFactorType);
        ArrayList<HTMLElementKeywordsData> arrayList = new ArrayList<HTMLElementKeywordsData>(KeywordsAndCompetitorsUtil.formKeywordData(this.b, hTMLTag, keywordsInTagAuditResult));
        if (WebsiteAuditorStringKey.b != 0) {
            g = ++n2;
        }
        return arrayList;
    }

    @Override
    public PageAuditResult getPagesAuditResult(PageAuditFactorType pageAuditFactorType) {
        return this.c.get().getFactorResult(pageAuditFactorType).getAuditResult();
    }

    @Override
    public PageAuditResultView getPageAuditResultView(PageAuditFactorType pageAuditFactorType) {
        return this.c.get().getFactorResult(pageAuditFactorType);
    }

    private static int a(KeywordTableData keywordTableData, KeywordTableData keywordTableData2) {
        return KeywordsAndCompetitorsUtil.compareKeywords(keywordTableData.getThisPage().getKeywords(), keywordTableData.getKeyword(), keywordTableData2.getThisPage().getKeywords(), keywordTableData2.getKeyword());
    }

    private static boolean a(String string, IAuditKeyword iAuditKeyword) {
        return iAuditKeyword.getKeyword().equalsIgnoreCase(string);
    }

    private IPageAuditFactorsModel b(IPage iPage) {
        return this.a(iPage);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "{-0}\u0015Y-{C\u001bI&\u001e\u007f\u001fC&5gZ";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 46;
                                break;
                            }
                            case 1: {
                                n9 = 67;
                                break;
                            }
                            case 2: {
                                n9 = 91;
                                break;
                            }
                            case 3: {
                                n9 = 19;
                                break;
                            }
                            default: {
                                n9 = 122;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u000e*(3\u0014[/7";
                    n3 = 0;
                    continue block10;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        h = stringArray3;
        f = !PageAnalysisWidgetService.class.desiredAssertionStatus();
        a = LoggerFactory.getLogger(PageAnalysisWidgetService.class);
    }
}

