/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.websiteauditor.util;

import com.agilemind.commons.util.ThreadSafeUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.crawler.operation.CrawlerRootOperation;
import com.agilemind.websiteauditor.data.service.AnalyzeKeywordsService;
import com.agilemind.websiteauditor.data.service.PageAnalysisService;
import com.agilemind.websiteauditor.data.service.WebsiteAuditorProjectService;
import com.agilemind.websiteauditor.data.service.task.crawlersupport.UpdatePageDataTaskApplyConsumer;
import com.agilemind.websiteauditor.util.PageResult;
import com.agilemind.websiteauditor.util.UpdatePageAndCompetitorsCompositeOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;

public class UpdatePageAndCompetitorsOperationConsumer
implements Consumer<UpdatePageAndCompetitorsCompositeOperation> {
    private final WebsiteAuditorProjectService a;
    private final UnicodeURL b;
    private final Collection<String> c;

    public UpdatePageAndCompetitorsOperationConsumer(WebsiteAuditorProjectService websiteAuditorProjectService, UnicodeURL unicodeURL, Collection<String> collection) {
        this.a = websiteAuditorProjectService;
        this.b = unicodeURL;
        this.c = collection;
    }

    @Override
    public void accept(UpdatePageAndCompetitorsCompositeOperation updatePageAndCompetitorsCompositeOperation) {
        ThreadSafeUtil.runInDispatchThread(() -> this.a(updatePageAndCompetitorsCompositeOperation));
    }

    private void a(UpdatePageAndCompetitorsCompositeOperation updatePageAndCompetitorsCompositeOperation) {
        PageResult pageResult = updatePageAndCompetitorsCompositeOperation.getPageResult();
        PageAnalysisService pageAnalysisService = this.a.getPageAnalysisService();
        if (pageAnalysisService.isPageAnalyzed(pageResult.getPageId())) {
            pageAnalysisService.updatePage(pageResult.getPageId(), pageResult);
            AnalyzeKeywordsService analyzeKeywordsService = pageAnalysisService.getAnalyzeKeywordsService(pageResult.getPageId());
            analyzeKeywordsService.setImportantKeywords(this.c);
            updatePageAndCompetitorsCompositeOperation.getCompetitors().entrySet().stream().forEach(arg_0 -> UpdatePageAndCompetitorsOperationConsumer.a(analyzeKeywordsService, arg_0));
            CrawlerRootOperation crawlerRootOperation = updatePageAndCompetitorsCompositeOperation.getCrawlerRootOperation();
            UpdatePageDataTaskApplyConsumer.applyCrawlerUpdate(Collections.singletonList(this.b), crawlerRootOperation, this.a, true);
        }
    }

    private static void a(AnalyzeKeywordsService analyzeKeywordsService, Map.Entry entry) {
        analyzeKeywordsService.setCompetitors((String)entry.getKey(), (Collection)entry.getValue());
    }
}

