/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class RevokeLinkedApiAppArg {
    protected final String appId;
    protected final String teamMemberId;
    protected final boolean keepAppFolder;

    public RevokeLinkedApiAppArg(String appId, String teamMemberId, boolean keepAppFolder) {
        if (appId == null) {
            throw new IllegalArgumentException("Required value for 'appId' is null");
        }
        this.appId = appId;
        if (teamMemberId == null) {
            throw new IllegalArgumentException("Required value for 'teamMemberId' is null");
        }
        this.teamMemberId = teamMemberId;
        this.keepAppFolder = keepAppFolder;
    }

    public RevokeLinkedApiAppArg(String appId, String teamMemberId) {
        this(appId, teamMemberId, true);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public boolean getKeepAppFolder() {
        return this.keepAppFolder;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.appId, this.teamMemberId, this.keepAppFolder});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            RevokeLinkedApiAppArg other = (RevokeLinkedApiAppArg)obj;
            return !(this.appId != other.appId && !this.appId.equals(other.appId) || this.teamMemberId != other.teamMemberId && !this.teamMemberId.equals(other.teamMemberId) || this.keepAppFolder != other.keepAppFolder);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<RevokeLinkedApiAppArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(RevokeLinkedApiAppArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("app_id");
            StoneSerializers.string().serialize(value.appId, g);
            g.writeFieldName("team_member_id");
            StoneSerializers.string().serialize(value.teamMemberId, g);
            g.writeFieldName("keep_app_folder");
            StoneSerializers.boolean_().serialize((Boolean)value.keepAppFolder, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public RevokeLinkedApiAppArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_keepAppFolder;
            String f_teamMemberId;
            String f_appId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_appId = null;
                f_teamMemberId = null;
                f_keepAppFolder = true;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("app_id".equals(field)) {
                        f_appId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("team_member_id".equals(field)) {
                        f_teamMemberId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("keep_app_folder".equals(field)) {
                        f_keepAppFolder = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_appId == null) {
                    throw new JsonParseException(p, "Required field \"app_id\" missing.");
                }
                if (f_teamMemberId == null) {
                    throw new JsonParseException(p, "Required field \"team_member_id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            RevokeLinkedApiAppArg value = new RevokeLinkedApiAppArg(f_appId, f_teamMemberId, f_keepAppFolder);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

