/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.ranktracker.app.data;

import com.agilemind.commons.data.field.Age;
import com.agilemind.commons.util.MathUtil;
import com.agilemind.factors.IFactorParser;
import com.agilemind.factors.data.AlexaPopularityResult;
import com.agilemind.ranktracker.app.data.ProjectGoogleAdwordsSettings;
import com.agilemind.ranktracker.data.api.PageDifficultyCalculated;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeywordDifficultyUtils {
    private static final int[] a = new int[]{0, 10, 20, 30, 40, 50, 60, 70, 100};
    private static final int[] b = new int[]{0, 10, 25, 40, 55, 70, 80, 90, 100};
    private static final int[] c = new int[]{0, 50, 100, 500, 1000, 5000, 10000, 50000};
    private static final int[] d = new int[]{0, 10, 20, 40, 60, 75, 90, 100};
    private static final double[] e = new double[]{0.0, 20.0, 40.0, 70.0, 100.0};
    private static final double[] f = new double[]{0.0, 20.0, 50.0, 90.0, 100.0};
    private static final int[] g = new int[]{1, 1000, 10000, 100000, 500000};
    private static final int[] h = new int[]{100, 90, 60, 30, 0};
    private static final long[] i = new long[]{0L, 50L, 1000L, 5000L, 10000L, 20000L};
    private static final int[] j = new int[]{0, 10, 40, 70, 90, 100};
    private static final int[] k = new int[]{0, 12, 36, 60, 120};
    private static final int[] l = new int[]{0, 30, 70, 90, 100};
    private static final Logger m = LoggerFactory.getLogger(KeywordDifficultyUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double calculatePageDifficultyScore(PageDifficultyCalculated pageDifficultyCalculated) {
        double d2 = 0.0;
        try {
            d2 += KeywordDifficultyUtils.a(pageDifficultyCalculated);
            d2 += KeywordDifficultyUtils.b(pageDifficultyCalculated);
            d2 += KeywordDifficultyUtils.c(pageDifficultyCalculated);
            d2 += KeywordDifficultyUtils.d(pageDifficultyCalculated);
            d2 += KeywordDifficultyUtils.e(pageDifficultyCalculated);
            d2 += KeywordDifficultyUtils.f(pageDifficultyCalculated);
            d2 += KeywordDifficultyUtils.g(pageDifficultyCalculated);
            if (n) return d2;
            if ((d2 += KeywordDifficultyUtils.h(pageDifficultyCalculated)) <= 100.0) return d2;
            throw new AssertionError(d2);
        }
        catch (Throwable throwable) {
            m.error("", throwable);
        }
        return d2;
    }

    private static double a(PageDifficultyCalculated pageDifficultyCalculated) {
        if (pageDifficultyCalculated.getBlexPageRank() == null || pageDifficultyCalculated.getBlexPageRank() == 0) {
            return 0.0;
        }
        int n2 = pageDifficultyCalculated.getBlexPageRank();
        double d2 = MathUtil.getPoints((int)n2, (int[])a, (int[])b);
        return d2 * 100.0 / 300.0;
    }

    private static double b(PageDifficultyCalculated pageDifficultyCalculated) {
        if (pageDifficultyCalculated.getBlexDomainRank() == null || pageDifficultyCalculated.getBlexDomainRank() == 0) {
            return 0.0;
        }
        int n2 = pageDifficultyCalculated.getBlexDomainRank();
        double d2 = MathUtil.getPoints((int)n2, (int[])a, (int[])b);
        return d2 * 30.0 / 300.0;
    }

    private static double c(PageDifficultyCalculated pageDifficultyCalculated) {
        if (pageDifficultyCalculated.getPageReferencesSites() == null || pageDifficultyCalculated.getPageReferencesSites() == 0) {
            return 0.0;
        }
        int n2 = pageDifficultyCalculated.getPageReferencesSites();
        double d2 = MathUtil.getPoints((int)n2, (int[])c, (int[])d);
        return d2 * 30.0 / 300.0;
    }

    private static double d(PageDifficultyCalculated pageDifficultyCalculated) {
        if (pageDifficultyCalculated.getDomainReferencesSites() == null || pageDifficultyCalculated.getDomainReferencesSites() == 0) {
            return 0.0;
        }
        int n2 = pageDifficultyCalculated.getDomainReferencesSites();
        double d2 = MathUtil.getPoints((int)n2, (int[])c, (int[])d);
        return d2 * 20.0 / 300.0;
    }

    private static double e(PageDifficultyCalculated pageDifficultyCalculated) {
        assert (pageDifficultyCalculated != null);
        if (pageDifficultyCalculated.getOptimizationRate() == null || pageDifficultyCalculated.getOptimizationRate() == -1.0) {
            return 0.0;
        }
        double d2 = pageDifficultyCalculated.getOptimizationRate();
        double d3 = MathUtil.getPoints((double)d2, (double[])e, (double[])f);
        return d3 * 50.0 / 300.0;
    }

    private static double f(PageDifficultyCalculated pageDifficultyCalculated) {
        AlexaPopularityResult alexaPopularityResult = pageDifficultyCalculated.getAlexaPopularity();
        if (alexaPopularityResult == null) {
            return 0.0;
        }
        int n2 = alexaPopularityResult.getGlobalRank();
        if (n2 < 1 || n2 == Integer.MAX_VALUE) {
            return 0.0;
        }
        double d2 = MathUtil.getPoints((int)n2, (int[])g, (int[])h);
        return d2 * 40.0 / 300.0;
    }

    private static double g(PageDifficultyCalculated pageDifficultyCalculated) {
        double d2;
        block5: {
            Long l2;
            block4: {
                l2 = pageDifficultyCalculated.getSocialSignals();
                if (l2 == null) {
                    return 0.0;
                }
                if (l2 <= Integer.MAX_VALUE) break block4;
                d2 = 100.0;
                if (!ProjectGoogleAdwordsSettings.b) break block5;
            }
            d2 = MathUtil.getPoints((long)l2, (long[])i, (int[])j);
        }
        return d2 * 20.0 / 300.0;
    }

    private static double h(PageDifficultyCalculated pageDifficultyCalculated) {
        assert (pageDifficultyCalculated != null);
        Date date = pageDifficultyCalculated.getDomainAge();
        if (date == null || date.equals(IFactorParser.NA_DATE)) {
            return 0.0;
        }
        Age age = new Age(date);
        int n2 = age.getMonths();
        double d2 = MathUtil.getPoints((int)(n2 += age.getYears() * 12), (int[])k, (int[])l);
        return d2 * 10.0 / 300.0;
    }
}

