/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.ranktracker.data;

import com.agilemind.commons.application.data.difference.DifferencePeriod;
import com.agilemind.commons.data.Database;
import com.agilemind.commons.data.Identifier;
import com.agilemind.commons.data.IndexRecordList;
import com.agilemind.commons.data.Record;
import com.agilemind.commons.data.field.ModifiableField;
import com.agilemind.commons.data.field.RecordBeanField;
import com.agilemind.commons.gui.chart.data.XYDataset;
import com.agilemind.commons.io.searchengine.searchengines.type.SearchEngineType;
import com.agilemind.commons.util.Util;
import com.agilemind.ranktracker.data.AbstractKeyword;
import com.agilemind.ranktracker.data.Competitor;
import com.agilemind.ranktracker.data.Keyword;
import com.agilemind.ranktracker.data.KeywordGroupBean;
import com.agilemind.ranktracker.data.Keywords;
import com.agilemind.ranktracker.data.SerpHistory;
import com.agilemind.ranktracker.data.api.ICompareAgainst;
import com.agilemind.ranktracker.data.api.ICompetitor;
import com.agilemind.ranktracker.data.api.ITrackedKeyword;
import com.agilemind.ranktracker.data.api.KeywordGroupBeanStorage;
import com.agilemind.ranktracker.data.util.CompareAgainst;
import com.google.common.collect.Iterables;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeywordsList
extends IndexRecordList<KeywordsList, Keyword, Long>
implements KeywordGroupBeanStorage {
    private static final RecordBeanField a;
    static final boolean b;
    private static final String m;

    public KeywordsList(Database database, Identifier identifier) {
        super(database, identifier, a, AbstractKeyword::getId);
    }

    public KeywordsList(Keywords keywords) {
        super((Record)keywords, a, AbstractKeyword::getId);
    }

    public Keyword addKeyword(String string) {
        Keyword keyword = new Keyword(this, string);
        this.add(keyword);
        return keyword;
    }

    @Nullable
    public Keyword getKeyword(String string, boolean bl) {
        return (Keyword)Iterables.find((Iterable)((Object)this), arg_0 -> KeywordsList.a(bl, string, arg_0), null);
    }

    public boolean remove(@Nullable Keyword keyword) {
        return super.remove((Object)keyword);
    }

    public Keyword getKeyword(String string) {
        int n2 = AbstractKeyword.d;
        for (Keyword keyword : this.getList()) {
            if (keyword.getQuery().equalsIgnoreCase(string)) {
                return keyword;
            }
            if (n2 == 0) continue;
        }
        return null;
    }

    public boolean contains(String string) {
        int n2 = AbstractKeyword.d;
        for (Keyword keyword : this.getList()) {
            if (keyword.getQuery().equals(string)) {
                return true;
            }
            if (n2 == 0) continue;
        }
        return false;
    }

    public boolean containsIgnoreCase(String string) {
        int n2 = AbstractKeyword.d;
        for (Keyword keyword : this.getList()) {
            if (keyword.getQuery().equalsIgnoreCase(string)) {
                return true;
            }
            if (n2 == 0) continue;
        }
        return false;
    }

    public int getInTop(Iterable<SearchEngineType> iterable, int n2) {
        return this.getInTop(ICompareAgainst.CURRENT_MEASUREMENT, iterable, n2);
    }

    public int getInTop(ICompareAgainst iCompareAgainst, Iterable<SearchEngineType> iterable, int n2) {
        return this.getInTop(iCompareAgainst, iterable, null, n2);
    }

    public int getInTop(ICompareAgainst iCompareAgainst, Iterable<SearchEngineType> iterable, @Nullable Competitor competitor, int n2) {
        return KeywordsList.getInTop(iCompareAgainst, this.getList(), iterable, competitor, n2);
    }

    public static <K extends ITrackedKeyword> int getInTop(ICompareAgainst iCompareAgainst, Iterable<K> iterable, Iterable<SearchEngineType> iterable2, @Nullable ICompetitor iCompetitor, int n2) {
        int n3 = AbstractKeyword.d;
        int n4 = 0;
        for (ITrackedKeyword iTrackedKeyword : iterable) {
            n4 += iTrackedKeyword.getInTop(iCompareAgainst, iterable2, n2, iCompetitor);
            if (n3 == 0) continue;
        }
        return n4;
    }

    public int getNonInTop(Iterable<SearchEngineType> iterable, int n2) {
        return this.getNonInTop(ICompareAgainst.CURRENT_MEASUREMENT, iterable, n2);
    }

    public int getNonInTop(Iterable<SearchEngineType> iterable, @Nullable Competitor competitor, int n2) {
        return this.getNonInTop(ICompareAgainst.CURRENT_MEASUREMENT, iterable, competitor, n2);
    }

    public int getNonInTop(ICompareAgainst iCompareAgainst, Iterable<SearchEngineType> iterable, int n2) {
        return this.getNonInTop(iCompareAgainst, iterable, null, n2);
    }

    public int getNonInTop(ICompareAgainst iCompareAgainst, Iterable<SearchEngineType> iterable, @Nullable Competitor competitor, int n2) {
        return KeywordsList.getNonInTop(iCompareAgainst, this.getList(), iterable, competitor, n2);
    }

    public static <K extends ITrackedKeyword> int getNonInTop(ICompareAgainst iCompareAgainst, Iterable<K> iterable, Iterable<SearchEngineType> iterable2, @Nullable ICompetitor iCompetitor, int n2) {
        int n3 = AbstractKeyword.d;
        int n4 = 0;
        for (ITrackedKeyword iTrackedKeyword : iterable) {
            n4 += iTrackedKeyword.getNonInTop(iCompareAgainst, iterable2, iCompetitor, n2);
            if (n3 == 0) continue;
        }
        return n4;
    }

    public int getInTopDifference(ICompareAgainst iCompareAgainst, Iterable<SearchEngineType> iterable, int n2) {
        return this.getInTopDifference(iCompareAgainst, iterable, null, n2);
    }

    public int getInTopDifference(ICompareAgainst iCompareAgainst, Iterable<SearchEngineType> iterable, @Nullable Competitor competitor, int n2) {
        int n3 = AbstractKeyword.d;
        int n4 = 0;
        for (Keyword keyword : this.getList()) {
            n4 += keyword.getInTopDifference(iCompareAgainst, iterable, competitor, n2);
            if (n3 == 0) continue;
        }
        return n4;
    }

    public List<Keyword> getKeywordsWithLandingPage() {
        return Util.filter((Iterable)this.getList(), (Predicate[])new Predicate[]{KeywordsList::b});
    }

    public List<Keyword> getKeywordsWithoutLandingPage() {
        return Util.filter((Iterable)this.getList(), (Predicate[])new Predicate[]{KeywordsList::a});
    }

    public int getInTop(SearchEngineType searchEngineType, int n2) {
        int n3 = AbstractKeyword.d;
        int n4 = 0;
        for (Keyword keyword : this.getList()) {
            if (keyword.isInTop(searchEngineType, n2)) {
                ++n4;
            }
            if (n3 == 0) continue;
        }
        return n4;
    }

    public int getInTop(SearchEngineType searchEngineType, Competitor competitor, int n2) {
        int n3 = AbstractKeyword.d;
        int n4 = 0;
        for (Keyword keyword : this.getList()) {
            if (keyword.isInTop(ICompareAgainst.CURRENT_MEASUREMENT, searchEngineType, n2, competitor)) {
                ++n4;
            }
            if (n3 == 0) continue;
        }
        return n4;
    }

    public int getKeywordsInTop(Iterable<SearchEngineType> iterable, int n2) {
        return this.getKeywordsInTopOrNon(iterable, n2, true);
    }

    public int getKeywordsNonInTop(Iterable<SearchEngineType> iterable, int n2) {
        return this.getKeywordsInTopOrNon(iterable, n2, false);
    }

    public int getSearchEnginesInTop(Iterable<SearchEngineType> iterable, int n2) {
        return this.getSearchEnginesInTopOrNon(iterable, n2, true);
    }

    public int getSearchEnginesNonInTop(Iterable<SearchEngineType> iterable, int n2) {
        return this.getSearchEnginesInTopOrNon(iterable, n2, false);
    }

    public static <K extends ITrackedKeyword> int getVisibilityScore(ICompareAgainst iCompareAgainst, Iterable<K> iterable, Iterable<SearchEngineType> iterable2) {
        int n2 = AbstractKeyword.d;
        int n3 = 0;
        for (ITrackedKeyword iTrackedKeyword : iterable) {
            n3 += iTrackedKeyword.getVisibilityScore(iCompareAgainst, iterable2);
            if (n2 == 0) continue;
        }
        return n3;
    }

    public int getVisibilityScore(ICompareAgainst iCompareAgainst, Iterable<SearchEngineType> iterable) {
        return KeywordsList.getVisibilityScore(iCompareAgainst, this.getList(), iterable);
    }

    public static <K extends ITrackedKeyword> int getVisibilityScoreComp(ICompareAgainst iCompareAgainst, Iterable<K> iterable, Iterable<SearchEngineType> iterable2, ICompetitor iCompetitor) {
        int n2 = AbstractKeyword.d;
        int n3 = 0;
        for (ITrackedKeyword iTrackedKeyword : iterable) {
            n3 += iTrackedKeyword.getVisibilityScoreComp(iCompareAgainst, iterable2, iCompetitor);
            if (n2 == 0) continue;
        }
        return n3;
    }

    public int getVisibilityScoreComp(ICompareAgainst iCompareAgainst, Iterable<SearchEngineType> iterable, Competitor competitor) {
        return KeywordsList.getVisibilityScoreComp(iCompareAgainst, this.getList(), iterable, competitor);
    }

    public int getVisibilityScoreComp(ICompareAgainst iCompareAgainst, SearchEngineType searchEngineType, Competitor competitor) {
        int n2 = AbstractKeyword.d;
        int n3 = 0;
        for (Keyword keyword : this.getList()) {
            n3 += keyword.getVisibilityScoreComp(iCompareAgainst, searchEngineType, (ICompetitor)competitor);
            if (n2 == 0) continue;
        }
        return n3;
    }

    public int getVisibilityScore(Iterable<SearchEngineType> iterable) {
        return this.getVisibilityScore(ICompareAgainst.CURRENT_MEASUREMENT, iterable);
    }

    public int getVisibilityScore(ICompareAgainst iCompareAgainst, SearchEngineType searchEngineType) {
        int n2 = AbstractKeyword.d;
        int n3 = 0;
        for (Keyword keyword : this.getList()) {
            n3 += keyword.getVisibilityScore(iCompareAgainst, searchEngineType);
            if (n2 == 0) continue;
        }
        return n3;
    }

    public int getVisibilityScore(SearchEngineType searchEngineType) {
        int n2 = AbstractKeyword.d;
        int n3 = 0;
        for (Keyword keyword : this.getList()) {
            n3 += keyword.getVisibilityScore(ICompareAgainst.CURRENT_MEASUREMENT, searchEngineType);
            if (n2 == 0) continue;
        }
        return n3;
    }

    public XYDataset<Integer> getVisitsPercentMap() {
        int n2 = AbstractKeyword.d;
        XYDataset xYDataset = new XYDataset();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Keyword keyword = (Keyword)iterator.next();
            keyword.setKeywordVisits((Map<Date, Integer>)xYDataset);
            if (n2 == 0) continue;
        }
        return xYDataset;
    }

    public Map.Entry<Date, Integer> getVisitsDifferenceValue(DifferencePeriod<Map.Entry<Date, Integer>, Map<Date, Integer>> differencePeriod) {
        return (Map.Entry)differencePeriod.getValue(this.getVisitsPercentMap());
    }

    public Date getLastCheckDate() {
        int n2 = AbstractKeyword.d;
        Date date = null;
        for (Keyword keyword : this.getList()) {
            Date date2 = keyword.getLastCheckTime();
            if (date == null || date2 != null && date2.after(date)) {
                date = date2;
            }
            if (n2 == 0) continue;
        }
        return date;
    }

    public int getEnteredTop(ICompareAgainst iCompareAgainst, int n2) {
        return this.a(iCompareAgainst, true, n2);
    }

    public int getEnteredTop(int n2) {
        return this.getEnteredTop(CompareAgainst.PREVIOUS_MEASUREMENT, n2);
    }

    public int getLeftTop(ICompareAgainst iCompareAgainst, int n2) {
        return this.a(iCompareAgainst, false, n2);
    }

    public int getLeftTop(int n2) {
        return this.getLeftTop(CompareAgainst.PREVIOUS_MEASUREMENT, n2);
    }

    public int getMovedUp(ICompareAgainst iCompareAgainst) {
        return this.a(iCompareAgainst, true);
    }

    public int getMovedUp() {
        return this.getMovedUp(CompareAgainst.PREVIOUS_MEASUREMENT);
    }

    public int getMovedDown(ICompareAgainst iCompareAgainst) {
        return this.a(iCompareAgainst, false);
    }

    public int getMovedDown() {
        return this.getMovedDown(CompareAgainst.PREVIOUS_MEASUREMENT);
    }

    public int getKeywordsMovedUp(ICompareAgainst iCompareAgainst) {
        return this.b(iCompareAgainst, true);
    }

    public int getKeywordsMovedDown(ICompareAgainst iCompareAgainst) {
        return this.b(iCompareAgainst, false);
    }

    public int getSearchEnginesMovedUp(ICompareAgainst iCompareAgainst) {
        return this.c(iCompareAgainst, true);
    }

    public int getSearchEnginesMovedDown(ICompareAgainst iCompareAgainst) {
        return this.c(iCompareAgainst, false);
    }

    public int getRanked() {
        int n2 = AbstractKeyword.d;
        int n3 = 0;
        for (Keyword keyword : this.getList()) {
            n3 += keyword.getRanked();
            if (n2 == 0) continue;
        }
        return n3;
    }

    private int a(ICompareAgainst iCompareAgainst, boolean bl, int n2) {
        int n3 = AbstractKeyword.d;
        int n4 = 0;
        for (Keyword keyword : this.getList()) {
            n4 += keyword.getDropOrAddTop(iCompareAgainst, bl, n2);
            if (n3 == 0) continue;
        }
        return n4;
    }

    private int a(ICompareAgainst iCompareAgainst, boolean bl) {
        int n2 = AbstractKeyword.d;
        int n3 = 0;
        for (Keyword keyword : this.getList()) {
            n3 += keyword.getMovedUpOrDown(iCompareAgainst, bl);
            if (n2 == 0) continue;
        }
        return n3;
    }

    private int b(ICompareAgainst iCompareAgainst, boolean bl) {
        int n2 = AbstractKeyword.d;
        int n3 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        for (Keyword keyword : this.getList()) {
            int n4 = keyword.getMovedUpOrDown(iCompareAgainst, bl);
            if (n4 != 0 && !hashSet.contains(keyword.getQuery())) {
                ++n3;
                hashSet.add(keyword.getQuery());
            }
            if (n2 == 0) continue;
        }
        return n3;
    }

    private int c(ICompareAgainst iCompareAgainst, boolean bl) {
        int n2 = AbstractKeyword.d;
        HashSet<String> hashSet = new HashSet<String>();
        for (Keyword keyword : this.getList()) {
            List<String> list = keyword.getSearchEnginesMovedUpOrDown(iCompareAgainst, bl);
            hashSet.addAll(list);
            if (n2 == 0) continue;
        }
        return hashSet.size();
    }

    public int getKeywordsInTopOrNon(Iterable<SearchEngineType> iterable, int n2, boolean bl) {
        int n3 = AbstractKeyword.d;
        int n4 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        for (Keyword keyword : this.getList()) {
            for (SearchEngineType searchEngineType : iterable) {
                block6: {
                    block7: {
                        if (hashSet.contains(keyword.getQuery())) break block6;
                        if (!bl) break block7;
                        if (!keyword.isInTop(searchEngineType, n2)) break block6;
                        ++n4;
                        hashSet.add(keyword.getQuery());
                        if (n3 == 0) break block6;
                    }
                    if (keyword.isNonInTop(searchEngineType, n2)) {
                        ++n4;
                        hashSet.add(keyword.getQuery());
                    }
                }
                if (n3 == 0) continue;
            }
            if (n3 == 0) continue;
        }
        return n4;
    }

    public int getSearchEnginesInTopOrNon(Iterable<SearchEngineType> iterable, int n2, boolean bl) {
        int n3 = AbstractKeyword.d;
        int n4 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        for (Keyword keyword : this.getList()) {
            for (SearchEngineType searchEngineType : iterable) {
                block6: {
                    block7: {
                        if (hashSet.contains(searchEngineType.getType())) break block6;
                        if (!bl) break block7;
                        if (!keyword.isInTop(searchEngineType, n2)) break block6;
                        ++n4;
                        hashSet.add(searchEngineType.getType());
                        if (n3 == 0) break block6;
                    }
                    if (keyword.isNonInTop(searchEngineType, n2)) {
                        ++n4;
                        hashSet.add(searchEngineType.getType());
                    }
                }
                if (n3 == 0) continue;
            }
            if (n3 == 0) continue;
        }
        return n4;
    }

    @Override
    @Nullable
    public KeywordGroupBean getKeywordGroup(String string) {
        int n2 = AbstractKeyword.d;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Keyword keyword = (Keyword)iterator.next();
            KeywordGroupBean keywordGroupBean = keyword.getGroup();
            if (keywordGroupBean != null && keywordGroupBean.getName().equalsIgnoreCase(string)) {
                return keywordGroupBean;
            }
            if (n2 == 0) continue;
        }
        return null;
    }

    public double getKeywordsFluctuation(SearchEngineType searchEngineType) {
        NavigableMap<Date, Double> navigableMap = this.getKeywordsFluctuationHistory(searchEngineType);
        return navigableMap.isEmpty() ? -1.0 : navigableMap.lastEntry().getValue();
    }

    public NavigableMap<Date, Double> getKeywordsFluctuationHistory(SearchEngineType searchEngineType) {
        return this.stream().flatMap(arg_0 -> KeywordsList.b(searchEngineType, arg_0)).collect(Collectors.toSet()).stream().collect(Collectors.toMap(KeywordsList::a, arg_0 -> this.a(searchEngineType, arg_0), KeywordsList::a, TreeMap::new));
    }

    private static Stream<? extends Date> a(SearchEngineType searchEngineType, Keyword keyword) {
        SerpHistory serpHistory = keyword.getSerpHistory(searchEngineType);
        return serpHistory != null ? serpHistory.getFluctuationHistoryMap().keySet().stream() : Stream.empty();
    }

    @NotNull
    private static Function<Keyword, Double> a(Date date, SearchEngineType searchEngineType) {
        return arg_0 -> KeywordsList.a(searchEngineType, date, arg_0);
    }

    private static Double a(SearchEngineType searchEngineType, Date date, Keyword keyword) {
        SerpHistory serpHistory = keyword.getSerpHistory(searchEngineType);
        if (serpHistory == null) {
            return null;
        }
        Map.Entry<Date, Double> entry = serpHistory.getFluctuationHistoryMap().floorEntry(date);
        return entry == null ? null : entry.getValue();
    }

    private static Double a(Double d2, Double d3) {
        return d2;
    }

    private Double a(SearchEngineType searchEngineType, Date date) {
        return Math.round(this.stream().map(KeywordsList.a(date, searchEngineType)).filter(Objects::nonNull).collect(Collectors.averagingDouble(KeywordsList::a)));
    }

    private static double a(Double d2) {
        return d2;
    }

    private static Date a(Date date) {
        return date;
    }

    private static Stream b(SearchEngineType searchEngineType, Keyword keyword) {
        return KeywordsList.a(searchEngineType, keyword);
    }

    private static boolean a(Keyword keyword) {
        return keyword.getLandingPage() == null;
    }

    private static boolean b(Keyword keyword) {
        return keyword.getLandingPage() != null;
    }

    private static boolean a(boolean bl, String string, Keyword keyword) {
        if (!b && keyword == null) {
            throw new AssertionError();
        }
        return bl ? keyword.getQuery().equals(string) : keyword.getQuery().equalsIgnoreCase(string);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "}\u001c1'|d\u001d;".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 22;
                            break;
                        }
                        case 1: {
                            n7 = 121;
                            break;
                        }
                        case 2: {
                            n7 = 72;
                            break;
                        }
                        case 3: {
                            n7 = 80;
                            break;
                        }
                        default: {
                            n7 = 19;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        m = new String(cArray).intern();
        b = !KeywordsList.class.desiredAssertionStatus();
        a = new ModifiableField(m, KeywordsList.class, Keyword.class);
    }
}

