/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.ranktracker.data;

import com.agilemind.commons.util.DateUtil;
import com.agilemind.ranktracker.data.SerpHistoryChangeListener;
import com.agilemind.ranktracker.data.api.SerpHistoryRecord;
import com.agilemind.ranktracker.data.util.FluctuationUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class SerpHistory
implements Serializable {
    private static final long serialVersionUID = -4940663734525294680L;
    public static final double NA_FLUCTUATION = -1.0;
    private NavigableMap<Date, SerpHistoryRecord[]> a = new TreeMap<Date, SerpHistoryRecord[]>();
    private NavigableMap<Date, Double> b = new TreeMap<Date, Double>();
    private transient List<SerpHistoryChangeListener> c = new CopyOnWriteArrayList<SerpHistoryChangeListener>();
    static final boolean d = !SerpHistory.class.desiredAssertionStatus();

    public double getFluctuation() {
        return this.b.isEmpty() ? -1.0 : this.b.lastEntry().getValue();
    }

    public NavigableMap<Date, SerpHistoryRecord[]> getHistoryRecordsMap() {
        return Collections.unmodifiableNavigableMap(this.a);
    }

    public void setHistoryRecordsMap(NavigableMap<Date, SerpHistoryRecord[]> navigableMap) {
        this.a = navigableMap;
    }

    public NavigableMap<Date, Double> getFluctuationHistoryMap() {
        return Collections.unmodifiableNavigableMap(this.b);
    }

    public void setFluctuationHistoryMap(NavigableMap<Date, Double> navigableMap) {
        this.b = navigableMap;
    }

    public void addHistoryRecords(Date date, SerpHistoryRecord[] serpHistoryRecordArray) {
        Map.Entry<Date, SerpHistoryRecord[]> entry = this.a.lowerEntry(date);
        SerpHistoryRecord[] serpHistoryRecordArray2 = entry != null ? entry.getValue() : null;
        this.b.put(date, FluctuationUtil.calculateFluctuation(serpHistoryRecordArray2, serpHistoryRecordArray));
        this.a.put(date, serpHistoryRecordArray);
        if (this.a.size() > 100) {
            this.a.remove(this.a.firstKey());
            this.b.remove(this.b.firstKey());
        }
        this.A();
    }

    public void removeHistoryRecords(Date date, Date date2) {
        new HashSet(this.a.keySet()).stream().filter(arg_0 -> SerpHistory.a(date, date2, arg_0)).forEach(this::removeHistoryRecords);
        if (!d && this.a.size() != this.b.size()) {
            throw new AssertionError();
        }
    }

    public void removeHistoryRecords(Date date) {
        if (!d && !this.a.containsKey(date)) {
            throw new AssertionError();
        }
        if (!d && !this.b.containsKey(date)) {
            throw new AssertionError();
        }
        this.a.remove(date);
        this.b.remove(date);
        Map.Entry<Date, SerpHistoryRecord[]> entry = this.a.lowerEntry(date);
        Map.Entry<Date, SerpHistoryRecord[]> entry2 = this.a.higherEntry(date);
        if (entry != null && entry2 != null) {
            this.b.put(entry2.getKey(), FluctuationUtil.calculateFluctuation(entry.getValue(), entry2.getValue()));
        }
        this.A();
    }

    private void A() {
        this.c.forEach(SerpHistoryChangeListener::historyChanged);
    }

    public void addChangeListener(SerpHistoryChangeListener serpHistoryChangeListener) {
        this.c.add(serpHistoryChangeListener);
    }

    public void removeChangeListener(SerpHistoryChangeListener serpHistoryChangeListener) {
        this.c.remove(serpHistoryChangeListener);
    }

    private static boolean a(Date date, Date date2, Date date3) {
        return DateUtil.between((Date)date3, (Date)date, (Date)date2);
    }
}

