/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.ranktracker.data.util;

import com.agilemind.commons.io.searchengine.searchengines.type.SearchEngineType;
import com.agilemind.commons.util.MathUtil;
import com.agilemind.ranktracker.data.Keyword;
import com.agilemind.ranktracker.data.KeywordPosition;
import com.agilemind.ranktracker.data.LandingPage;
import com.agilemind.ranktracker.data.MultipleKeywordPositionsList;
import com.agilemind.ranktracker.data.api.IKeyword;
import com.agilemind.ranktracker.data.api.IKeywordPosition;
import com.agilemind.ranktracker.data.api.ILandingPage;
import com.agilemind.ranktracker.data.api.IPosition;
import com.agilemind.ranktracker.data.api.ITrackedKeyword;
import com.agilemind.ranktracker.data.api.PageDifficultyData;
import com.agilemind.ranktracker.data.api.SearchEngineResultsPage;
import com.agilemind.ranktracker.data.service.TrackedKeywordService;
import com.agilemind.ranktracker.data.util.CompareAgainst;
import com.agilemind.ranktracker.data.util.Position;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class KeywordDifficultyService {
    @Nullable
    public static SearchEngineResultsPage getSearchEngineResultsPage(ITrackedKeyword iTrackedKeyword, SearchEngineType searchEngineType) {
        return iTrackedKeyword.getSearchEngineResultsPage(searchEngineType);
    }

    @Nullable
    public static Double getKeywordDifficulty(ITrackedKeyword iTrackedKeyword, SearchEngineType searchEngineType) {
        SearchEngineResultsPage searchEngineResultsPage = KeywordDifficultyService.getSearchEngineResultsPage(iTrackedKeyword, searchEngineType);
        if (searchEngineResultsPage == null || searchEngineResultsPage.getPageDifficultyDataList().isEmpty()) {
            return null;
        }
        return KeywordDifficultyService.getKeywordDifficulty(searchEngineResultsPage);
    }

    public static double getKeywordDifficulty(SearchEngineResultsPage searchEngineResultsPage) {
        boolean bl = CompareAgainst.d;
        double d2 = 0.0;
        List<? extends PageDifficultyData> list = searchEngineResultsPage.getPageDifficultyDataList();
        for (PageDifficultyData pageDifficultyData : list) {
            d2 += pageDifficultyData.getDifficultyScore().doubleValue();
            if (!bl) continue;
        }
        return MathUtil.round((double)(d2 / (double)list.size()), (int)1);
    }

    @Nullable
    public static IPosition calcLandingPosition(int n2, Keyword keyword, SearchEngineType searchEngineType, boolean bl) {
        boolean bl2 = CompareAgainst.d;
        LandingPage landingPage = keyword.getLandingPage();
        KeywordPosition keywordPosition = keyword.getPosition(searchEngineType);
        IPosition iPosition = new Position(KeywordPosition.getNotFoundPosition(n2), 0, null);
        if (keywordPosition == null || landingPage == null) {
            return iPosition;
        }
        MultipleKeywordPositionsList multipleKeywordPositionsList = keywordPosition.getMultiplePositions();
        if (multipleKeywordPositionsList == null) {
            return iPosition;
        }
        Iterator iterator = multipleKeywordPositionsList.iterator();
        while (iterator.hasNext()) {
            IKeywordPosition iKeywordPosition = (IKeywordPosition)iterator.next();
            if (iKeywordPosition.getUrl().equals(landingPage.getUrl(), bl)) {
                iPosition = iKeywordPosition;
                break;
            }
            if (!bl2) continue;
        }
        return iPosition;
    }

    @Nullable
    public static IPosition calcLandingPosition(int n2, TrackedKeywordService trackedKeywordService, IKeyword iKeyword, SearchEngineType searchEngineType, boolean bl) {
        boolean bl2 = CompareAgainst.d;
        ILandingPage iLandingPage = trackedKeywordService.getLandingPage(iKeyword.getId());
        IKeywordPosition iKeywordPosition = trackedKeywordService.getPosition(iKeyword.getId(), searchEngineType);
        IPosition iPosition = new Position(KeywordPosition.getNotFoundPosition(n2), 0, null);
        if (iKeywordPosition == null || iLandingPage == null) {
            return iPosition;
        }
        List<IKeywordPosition> list = trackedKeywordService.getMultiplePositions(iKeyword.getId(), searchEngineType);
        if (list.isEmpty()) {
            return iPosition;
        }
        for (IKeywordPosition iKeywordPosition2 : list) {
            if (iKeywordPosition2.getUrl().equals(iLandingPage.getUrl(), bl)) {
                iPosition = iKeywordPosition2;
                break;
            }
            if (!bl2) continue;
        }
        return iPosition;
    }
}

