/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.ranktracker.report.data.widget.data.project;

import com.agilemind.commons.application.modules.io.searchengine.data.api.IPopularityHistoryMap;
import com.agilemind.commons.application.modules.widget.service.project.BacklinkFactorsWidgetProjectService;
import com.agilemind.commons.util.MathUtil;
import com.agilemind.factors.SearchEngineFactorType;
import com.agilemind.factors.SearchEngineFactorsList;
import com.agilemind.ranktracker.data.api.ICompetitor;
import com.agilemind.ranktracker.data.service.RankTrackerProjectService;
import com.agilemind.ranktracker.report.data.widget.data.CompetitorsBacklinkFactorsWidgetService;
import java.util.List;
import java.util.stream.Collectors;

public class CompetitorsBacklinkFactorsProjectWidgetService
extends BacklinkFactorsWidgetProjectService
implements CompetitorsBacklinkFactorsWidgetService<ICompetitor> {
    private RankTrackerProjectService a;

    public CompetitorsBacklinkFactorsProjectWidgetService(RankTrackerProjectService rankTrackerProjectService, IPopularityHistoryMap iPopularityHistoryMap, List<SearchEngineFactorType<? extends Comparable>> list) {
        super(iPopularityHistoryMap, list);
        this.a = rankTrackerProjectService;
    }

    @Override
    public Long getBacklinks(ICompetitor iCompetitor) {
        return (Long)this.getUsedFactorValue(iCompetitor.getPopularityMap(), SearchEngineFactorsList.BACKLINKS_TOTAL);
    }

    @Override
    public Double getDofollowBacklinksPercent(ICompetitor iCompetitor) {
        Long l2 = (Long)this.getUsedFactorValue(iCompetitor.getPopularityMap(), SearchEngineFactorsList.BACKLINKS_TOTAL);
        if (l2 == null || l2 == 0L) {
            return null;
        }
        Long l3 = (Long)this.getFactorValue(iCompetitor.getPopularityMap(), SearchEngineFactorsList.DOFOLLOW_BACKLINKS);
        if (l3 == null) {
            return null;
        }
        return MathUtil.getPercent100((double)l2.longValue(), (double)l3.longValue());
    }

    @Override
    public Long getBacklinkDomains(ICompetitor iCompetitor) {
        return (Long)this.getUsedFactorValue(iCompetitor.getPopularityMap(), SearchEngineFactorsList.BACKLINK_DOMAINS);
    }

    @Override
    public Long getIPs(ICompetitor iCompetitor) {
        return (Long)this.getUsedFactorValue(iCompetitor.getPopularityMap(), SearchEngineFactorsList.BACKLINK_IPS);
    }

    @Override
    public Long getCBlocks(ICompetitor iCompetitor) {
        return (Long)this.getUsedFactorValue(iCompetitor.getPopularityMap(), SearchEngineFactorsList.BACKLINK_C_BLOCKS);
    }

    @Override
    public List<ICompetitor> getCompetitors() {
        return this.a.getCompetitorsList().stream().filter(ICompetitor::isIncludeInReport).collect(Collectors.toList());
    }
}

