/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.ranktracker.report.data.widget.data.project;

import com.agilemind.commons.application.modules.factors.data.DomainStrengthUtil;
import com.agilemind.commons.application.modules.io.searchengine.data.IGoogleAdwordsSettings;
import com.agilemind.commons.application.modules.io.searchengine.data.KEI;
import com.agilemind.commons.application.modules.io.searchengine.data.api.IPopularityHistoryMap;
import com.agilemind.commons.application.modules.io.searchengine.data.api.IPopularityMap;
import com.agilemind.commons.application.modules.widget.core.IWidgetReportSettings;
import com.agilemind.commons.application.modules.widget.service.ITagsDistributionWidgetService;
import com.agilemind.commons.application.modules.widget.util.RecordAnalyzeUtil;
import com.agilemind.commons.application.modules.widget.util.TagsDistributionServiceUtil;
import com.agilemind.commons.application.modules.widget.util.to.GraphPeriod;
import com.agilemind.commons.application.modules.widget.util.to.TagStats;
import com.agilemind.commons.collectors.data.SearchVolumeRange;
import com.agilemind.commons.gui.chart.ChartColorGetter;
import com.agilemind.commons.gui.chart.data.XYChartData;
import com.agilemind.commons.gui.chart.data.XYDataset;
import com.agilemind.commons.gui.util.ColorUtil;
import com.agilemind.commons.io.searchengine.searchengines.data.MajorSearchEngineType;
import com.agilemind.commons.io.searchengine.searchengines.data.UniversalSearchType;
import com.agilemind.commons.io.searchengine.searchengines.type.SearchEngineType;
import com.agilemind.commons.io.searchengine.util.SearchEngineTypeComparator;
import com.agilemind.commons.io.utils.BinaryFile;
import com.agilemind.commons.util.DateUtil;
import com.agilemind.commons.util.MathUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.Util;
import com.agilemind.ranktracker.data.IKeywordPositions;
import com.agilemind.ranktracker.data.KeywordsList;
import com.agilemind.ranktracker.data.api.ICompareAgainst;
import com.agilemind.ranktracker.data.api.ICompetitor;
import com.agilemind.ranktracker.data.api.IKeyword;
import com.agilemind.ranktracker.data.api.IKeywordGroup;
import com.agilemind.ranktracker.data.api.IKeywordPosition;
import com.agilemind.ranktracker.data.api.IKeywordPositionWithSubPosition;
import com.agilemind.ranktracker.data.api.IKeywordTrackingSettings;
import com.agilemind.ranktracker.data.api.ILandingPage;
import com.agilemind.ranktracker.data.api.ITrackedKeyword;
import com.agilemind.ranktracker.data.service.GoogleAdwordsSettingsService;
import com.agilemind.ranktracker.data.service.ProjectKeywordCollectorService;
import com.agilemind.ranktracker.data.service.RankTrackerProjectService;
import com.agilemind.ranktracker.data.util.KeywordsUtil;
import com.agilemind.ranktracker.report.data.widget.UniversalResult;
import com.agilemind.ranktracker.report.data.widget.ValueDifference;
import com.agilemind.ranktracker.report.data.widget.data.IKeywordInfo;
import com.agilemind.ranktracker.report.data.widget.data.KeywordMetricsByKeywordGroupWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.KeywordMetricsByLandingPageWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.KeywordMovedUpDownWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.KeywordRanksCompetitorsWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.KeywordRanksSummaryWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.KeywordRanksWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.KeywordsSummaryWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.RankTrackerWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.RankingPagesWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.SessionsWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.VisibilityBySearchEngineWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.VisibilityProgressGraphWidgetService;
import com.agilemind.ranktracker.report.data.widget.data.project.KeywordInfo;
import com.agilemind.ranktracker.report.data.widget.data.project.b;
import com.agilemind.ranktracker.report.data.widget.data.project.c;
import com.agilemind.ranktracker.report.data.widget.data.project.d;
import com.agilemind.ranktracker.report.data.widget.data.project.e;
import com.agilemind.ranktracker.util.RankTrackerStringKey;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class KeywordsProjectWidgetService
implements KeywordRanksWidgetService,
KeywordRanksCompetitorsWidgetService,
KeywordMovedUpDownWidgetService<ICompetitor>,
KeywordRanksSummaryWidgetService<ICompetitor>,
KeywordsSummaryWidgetService<ICompetitor>,
KeywordMetricsByKeywordGroupWidgetService,
KeywordMetricsByLandingPageWidgetService,
VisibilityBySearchEngineWidgetService<ICompetitor>,
VisibilityProgressGraphWidgetService<ICompetitor>,
RankingPagesWidgetService,
RankTrackerWidgetService,
SessionsWidgetService,
ITagsDistributionWidgetService {
    private RankTrackerProjectService a;
    private ChartColorGetter<SearchEngineType> b;
    private IKeywordTrackingSettings c;
    private List<ITrackedKeyword> d;
    public static int e;

    public KeywordsProjectWidgetService(IWidgetReportSettings iWidgetReportSettings, RankTrackerProjectService rankTrackerProjectService) {
        this.a = rankTrackerProjectService;
        this.b = new ChartColorGetter((Paint[])ColorUtil.PREDEFINED_COLORS);
        this.c = rankTrackerProjectService.getKeywordTrackingSettings();
        this.d = RecordAnalyzeUtil.filterByTags(rankTrackerProjectService.getTrackedKeywordsService().getKeywords(), (List)iWidgetReportSettings.getTags());
    }

    @Override
    public String getProjectShortName() {
        return this.a.getShortName();
    }

    @Override
    public BinaryFile getProjectThumbnail() {
        return this.a.getDomainThumbnail();
    }

    @Override
    public UnicodeURL getProjectUrl() {
        return this.a.getProjectUrl();
    }

    @Override
    public String getProjectTitle() {
        return this.a.getProjectUrlTitle();
    }

    @Override
    public List<SearchEngineType> getSearchEngines() {
        ArrayList<SearchEngineType> arrayList = new ArrayList<SearchEngineType>(this.a.getUseSearchEngineList());
        Collections.sort(arrayList, new SearchEngineTypeComparator());
        return arrayList;
    }

    @Override
    public List<IKeywordInfo> getKeywords() {
        boolean bl = this.c.isTrackMultiplePositions();
        List list = Util.transform(this.d, arg_0 -> this.a(bl, arg_0));
        Collections.sort(list, KeywordsProjectWidgetService::a);
        return list;
    }

    @Override
    public int getKeywordsCount() {
        return this.d.size();
    }

    @Override
    public int getSearchEnginesCount() {
        return this.a.getUseSearchEngineList().size();
    }

    public List<ICompetitor> getCompetitors() {
        return Util.filter(this.a.getCompetitorsList(), (Predicate[])new Predicate[]{ICompetitor::isIncludeInReport});
    }

    private boolean a(List<SearchEngineType> list, @Nullable ICompetitor iCompetitor, ICompareAgainst iCompareAgainst) {
        int n2 = e;
        for (SearchEngineType searchEngineType : list) {
            if (this.a(searchEngineType, iCompetitor, iCompareAgainst)) {
                return true;
            }
            if (n2 == 0) continue;
        }
        return false;
    }

    private boolean a(SearchEngineType searchEngineType, @Nullable ICompetitor iCompetitor, ICompareAgainst iCompareAgainst) {
        int n2 = e;
        for (ITrackedKeyword iTrackedKeyword : this.d) {
            if (this.a(iTrackedKeyword, searchEngineType, iCompetitor, iCompareAgainst)) {
                return true;
            }
            if (n2 == 0) continue;
        }
        return false;
    }

    private boolean a(ITrackedKeyword iTrackedKeyword, SearchEngineType searchEngineType, @Nullable ICompetitor iCompetitor, ICompareAgainst iCompareAgainst) {
        IKeywordPositions iKeywordPositions;
        IKeywordPositions iKeywordPositions2 = iKeywordPositions = iCompetitor == null ? iTrackedKeyword.getKeywordPositionsList(searchEngineType) : iTrackedKeyword.getCompetitorKeywordPositionsList(iCompetitor, searchEngineType);
        if (iKeywordPositions == null) {
            return false;
        }
        IKeywordPositionWithSubPosition iKeywordPositionWithSubPosition = iKeywordPositions.getPosition(iCompareAgainst);
        return iKeywordPositionWithSubPosition != null;
    }

    @Override
    public Date getReportCreationDate() {
        return new Date();
    }

    @Override
    public ICompareAgainst getCompareAgainst() {
        return this.a.getReportCompareAgainst();
    }

    @Override
    public ValueDifference getVisibilityValueDifference() {
        return this.getVisibilityValueDifference(this.getSearchEngines(), null);
    }

    @Override
    public ValueDifference getVisibilityValueDifference(ICompetitor iCompetitor) {
        return this.getVisibilityValueDifference(this.getSearchEngines(), iCompetitor);
    }

    @Override
    public ValueDifference getVisibilityValueDifference(SearchEngineType searchEngineType, @Nullable ICompetitor iCompetitor) {
        return this.getVisibilityValueDifference(Collections.singletonList(searchEngineType), iCompetitor);
    }

    public ValueDifference getVisibilityValueDifference(List<SearchEngineType> list, @Nullable ICompetitor iCompetitor) {
        int n2 = -1;
        if (this.a(list, iCompetitor, ICompareAgainst.CURRENT_MEASUREMENT)) {
            n2 = this.b(list, iCompetitor, ICompareAgainst.CURRENT_MEASUREMENT);
        }
        int n3 = Integer.MIN_VALUE;
        if (this.a(list, iCompetitor, this.getCompareAgainst())) {
            n3 = n2 - this.b(list, iCompetitor, this.getCompareAgainst());
        }
        return new ValueDifference(n2, n3);
    }

    private int b(List<SearchEngineType> list, @Nullable ICompetitor iCompetitor, ICompareAgainst iCompareAgainst) {
        int n2 = iCompetitor == null ? KeywordsList.getVisibilityScore(iCompareAgainst, this.d, list) : KeywordsList.getVisibilityScoreComp(iCompareAgainst, this.d, list, iCompetitor);
        return (int)KeywordsUtil.getVisibility(n2, this.getKeywordsCount(), list.size());
    }

    @Override
    public double getVisibilityPercent(ValueDifference valueDifference) {
        return valueDifference.getValue();
    }

    @Override
    public boolean hasCheckedExpectedVisits() {
        int n2 = e;
        for (ITrackedKeyword iTrackedKeyword : this.d) {
            long l2 = iTrackedKeyword.getKEI().getSearchNum();
            if (l2 != -2L) {
                return true;
            }
            if (n2 == 0) continue;
        }
        return false;
    }

    @Override
    public long getExpectedVisits() {
        int n2 = e;
        long l2 = 0L;
        for (ITrackedKeyword iTrackedKeyword : this.d) {
            KEI kEI = iTrackedKeyword.getKEI();
            long l3 = kEI.getSearchNum();
            if (l3 > 0L) {
                ProjectKeywordCollectorService projectKeywordCollectorService = this.a.getProjectKeywordCollectorService();
                GoogleAdwordsSettingsService googleAdwordsSettingsService = projectKeywordCollectorService.getGoogleAdwordsSettingsService();
                IGoogleAdwordsSettings iGoogleAdwordsSettings = googleAdwordsSettingsService.getGoogleAdwordsSettings();
                l2 += kEI.getKeywordCollectorType().getEstimatedVisits(l3, iGoogleAdwordsSettings.getCountries());
            }
            if (n2 == 0) continue;
        }
        return l2;
    }

    @Override
    public double getExpectedVisitsPercent(long l2) {
        return KeywordsProjectWidgetService.a(l2);
    }

    @Override
    @Nullable
    public Integer getTotalVisits() {
        return this.getTotalVisits(GraphPeriod.ONE_MONTH);
    }

    @Override
    public Integer getTotalVisits(GraphPeriod graphPeriod) {
        Date date = DateUtil.minusDays((long)1L);
        Date date2 = graphPeriod != GraphPeriod.ALL_TIME ? graphPeriod.getDate() : this.a.getEntranceDate();
        return this.a(date2, date);
    }

    private Integer a(Date date, Date date2) {
        int n2 = e;
        Map<Date, Number> map = this.b(date, date2);
        if (map.isEmpty()) {
            return null;
        }
        int n3 = 0;
        for (Map.Entry<Date, Number> entry : map.entrySet()) {
            n3 += entry.getValue().intValue();
            if (n2 == 0) continue;
        }
        return n3;
    }

    private Map<Date, Number> b(Date date, Date date2) {
        int n2 = e;
        LinkedHashMap<Date, Number> linkedHashMap = new LinkedHashMap<Date, Number>();
        XYDataset<Number> xYDataset = this.A();
        Date date3 = DateUtil.getStartDay((Date)date);
        Date date4 = DateUtil.getStartDay((Date)date2);
        for (Map.Entry entry : xYDataset.entrySet()) {
            if (DateUtil.between((Date)((Date)entry.getKey()), (Date)date3, (Date)date4)) {
                linkedHashMap.put((Date)entry.getKey(), (Number)entry.getValue());
            }
            if (n2 == 0) continue;
        }
        return linkedHashMap;
    }

    @Override
    public double getTotalVisitsPercent(long l2) {
        return KeywordsProjectWidgetService.a(l2);
    }

    private static double a(long l2) {
        int n2 = e;
        if (l2 == 0L) {
            return 0.0;
        }
        if (l2 >= 1L && l2 < 100L) {
            return 5.0;
        }
        if (l2 > 1000000L) {
            return 100.0;
        }
        double[][] dArrayArray = new double[][]{{100.0, 5000.0, 0.05, 0.3}, {5000.0, 50000.0, 0.3, 0.5}, {50000.0, 100000.0, 0.5, 0.7}, {100000.0, 1000000.0, 0.7, 1.0}};
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        for (double[] dArray2 : dArrayArray) {
            if (!((double)l2 >= dArray2[0]) || !((double)l2 <= dArray2[1])) continue;
            dArray = dArray2;
            if (n2 == 0) continue;
        }
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        return (d4 + ((double)l2 - d2) * (d5 - d4) / (d3 - d2)) * 100.0;
    }

    @Override
    public double getDomainStrength() {
        IPopularityHistoryMap iPopularityHistoryMap = this.a.getPopularityHistoryMap();
        return DomainStrengthUtil.getStrength((IPopularityMap)iPopularityHistoryMap);
    }

    @Override
    public double getDomainStrength(ICompetitor iCompetitor) {
        IPopularityMap iPopularityMap = iCompetitor.getPopularityMap();
        return DomainStrengthUtil.getStrength((IPopularityMap)iPopularityMap);
    }

    @Override
    public double getDomainStrengthPercent(double d2) {
        return d2 == -1.0 ? 0.0 : d2 * 10.0;
    }

    @Override
    public int getPositionsLimit() {
        return this.c.getPositionsLimit();
    }

    @Override
    public ValueDifference getKeywordsInTopValueDifference(SearchEngineType searchEngineType, @Nullable ICompetitor iCompetitor, int n2) {
        int n3 = -1;
        if (this.a(searchEngineType, iCompetitor, ICompareAgainst.CURRENT_MEASUREMENT)) {
            n3 = this.a(searchEngineType, iCompetitor, ICompareAgainst.CURRENT_MEASUREMENT, n2);
        }
        int n4 = Integer.MIN_VALUE;
        if (this.a(searchEngineType, iCompetitor, this.getCompareAgainst())) {
            n4 = n3 - this.a(searchEngineType, iCompetitor, this.getCompareAgainst(), n2);
        }
        return new ValueDifference(n3, n4);
    }

    private int a(SearchEngineType searchEngineType, @Nullable ICompetitor iCompetitor, ICompareAgainst iCompareAgainst, int n2) {
        return KeywordsList.getInTop(iCompareAgainst, this.d, Collections.singletonList(searchEngineType), iCompetitor, n2);
    }

    @Override
    public ValueDifference getKeywordsNotInTopValueDifference(SearchEngineType searchEngineType, @Nullable ICompetitor iCompetitor, int n2) {
        int n3 = -1;
        if (this.a(searchEngineType, iCompetitor, ICompareAgainst.CURRENT_MEASUREMENT)) {
            n3 = this.b(searchEngineType, iCompetitor, ICompareAgainst.CURRENT_MEASUREMENT, n2);
        }
        int n4 = Integer.MIN_VALUE;
        if (this.a(searchEngineType, iCompetitor, this.getCompareAgainst())) {
            n4 = n3 - this.b(searchEngineType, iCompetitor, this.getCompareAgainst(), n2);
        }
        return new ValueDifference(n3, n4);
    }

    private int b(SearchEngineType searchEngineType, @Nullable ICompetitor iCompetitor, ICompareAgainst iCompareAgainst, int n2) {
        return KeywordsList.getNonInTop(iCompareAgainst, this.d, Collections.singletonList(searchEngineType), iCompetitor, n2);
    }

    @Override
    public UniversalResult getKeywordsInUniversalValueDifference(SearchEngineType searchEngineType, @Nullable ICompetitor iCompetitor, UniversalSearchType universalSearchType) {
        int n2 = -1;
        int n3 = -1;
        int n4 = Integer.MIN_VALUE;
        if (MajorSearchEngineType.isUniversalResultSupport((MajorSearchEngineType.MajorType)searchEngineType.getMajorType().getMajorType())) {
            boolean bl = this.c.isUseUniversalSearch();
            if (bl && this.a(searchEngineType, iCompetitor, ICompareAgainst.CURRENT_MEASUREMENT)) {
                n2 = this.a(searchEngineType, iCompetitor, universalSearchType);
                n3 = this.a(searchEngineType, iCompetitor, ICompareAgainst.CURRENT_MEASUREMENT, universalSearchType);
            }
            if (bl && this.a(searchEngineType, iCompetitor, this.getCompareAgainst())) {
                n4 = n3 - this.a(searchEngineType, iCompetitor, this.getCompareAgainst(), universalSearchType);
            }
        }
        return new UniversalResult(n2, n3, n4);
    }

    private int a(SearchEngineType searchEngineType, @Nullable ICompetitor iCompetitor, ICompareAgainst iCompareAgainst, UniversalSearchType universalSearchType) {
        int n2 = e;
        int n3 = 0;
        for (ITrackedKeyword iTrackedKeyword : this.d) {
            IKeywordPositionWithSubPosition iKeywordPositionWithSubPosition;
            IKeywordPositions iKeywordPositions;
            IKeywordPositions iKeywordPositions2 = iKeywordPositions = iCompetitor == null ? iTrackedKeyword.getKeywordPositionsList(searchEngineType) : iTrackedKeyword.getCompetitorKeywordPositionsList(iCompetitor, searchEngineType);
            if (iKeywordPositions == null && n2 == 0 || (iKeywordPositionWithSubPosition = iKeywordPositions.getPosition(iCompareAgainst)) == null && n2 == 0) continue;
            if (this.a(iKeywordPositionWithSubPosition, universalSearchType)) {
                ++n3;
            }
            if (n2 == 0) continue;
        }
        return n3;
    }

    private boolean a(IKeywordPositionWithSubPosition iKeywordPositionWithSubPosition, UniversalSearchType universalSearchType) {
        int n2 = e;
        boolean bl = this.c.isTrackMultiplePositions();
        List<IKeywordPosition> list = iKeywordPositionWithSubPosition.getPositions();
        for (int i2 = 0; i2 < (bl ? list.size() : 1); ++i2) {
            IKeywordPosition iKeywordPosition = list.get(i2);
            if (iKeywordPosition.getUniversalSearchType() != universalSearchType) continue;
            return true;
        }
        return false;
    }

    private int a(SearchEngineType searchEngineType, @Nullable ICompetitor iCompetitor, UniversalSearchType universalSearchType) {
        int n2 = e;
        int n3 = 0;
        for (ITrackedKeyword iTrackedKeyword : this.d) {
            List<UniversalSearchType> list;
            IKeywordPositionWithSubPosition iKeywordPositionWithSubPosition;
            IKeywordPositions iKeywordPositions;
            IKeywordPositions iKeywordPositions2 = iKeywordPositions = iCompetitor == null ? iTrackedKeyword.getKeywordPositionsList(searchEngineType) : iTrackedKeyword.getCompetitorKeywordPositionsList(iCompetitor, searchEngineType);
            if (iKeywordPositions == null && n2 == 0 || (iKeywordPositionWithSubPosition = iKeywordPositions.getPosition()) == null && n2 == 0) continue;
            if (universalSearchType == iKeywordPositionWithSubPosition.getUniversalSearchType()) {
                ++n3;
                if (n2 == 0) continue;
            }
            if ((list = iKeywordPositionWithSubPosition.getUniversalSearchTypes()) == null && n2 == 0) continue;
            if (list.contains(universalSearchType)) {
                ++n3;
            }
            if (n2 == 0) continue;
        }
        return n3;
    }

    public int getKeywordsMovedUp(SearchEngineType searchEngineType) {
        return this.getKeywordsMovedUp(searchEngineType, null);
    }

    @Override
    public int getKeywordsMovedUp(SearchEngineType searchEngineType, @Nullable ICompetitor iCompetitor) {
        return this.a(searchEngineType, iCompetitor, this.getCompareAgainst(), true);
    }

    public int getKeywordsMovedDown(SearchEngineType searchEngineType) {
        return this.getKeywordsMovedDown(searchEngineType, null);
    }

    @Override
    public int getKeywordsMovedDown(SearchEngineType searchEngineType, @Nullable ICompetitor iCompetitor) {
        return this.a(searchEngineType, iCompetitor, this.getCompareAgainst(), false);
    }

    private int a(SearchEngineType searchEngineType, @Nullable ICompetitor iCompetitor, ICompareAgainst iCompareAgainst, boolean bl) {
        int n2 = e;
        if (!this.a(searchEngineType, iCompetitor, this.getCompareAgainst())) {
            return -1;
        }
        int n3 = 0;
        for (ITrackedKeyword iTrackedKeyword : this.d) {
            IKeywordPositions iKeywordPositions;
            IKeywordPositions iKeywordPositions2 = iKeywordPositions = iCompetitor == null ? iTrackedKeyword.getKeywordPositionsList(searchEngineType) : iTrackedKeyword.getCompetitorKeywordPositionsList(iCompetitor, searchEngineType);
            if (iKeywordPositions == null && n2 == 0) continue;
            if (iKeywordPositions.getMovedUpOrDown(iCompareAgainst, bl)) {
                ++n3;
            }
            if (n2 == 0) continue;
        }
        return n3;
    }

    @Override
    public double getKeywordsMovedPercent(int n2) {
        return MathUtil.getPercent100((double)this.d.size(), (double)n2);
    }

    @Override
    public Collection<UnicodeURL> getPages(boolean bl, int n2) {
        int n3 = e;
        LinkedHashSet<UnicodeURL> linkedHashSet = new LinkedHashSet<UnicodeURL>();
        for (ITrackedKeyword iTrackedKeyword : this.d) {
            Set<UnicodeURL> set = KeywordsUtil.getKeywordFoundUrls(iTrackedKeyword, this.getSearchEngines());
            linkedHashSet.addAll(set);
            if (n3 == 0) continue;
        }
        ArrayList arrayList = new ArrayList(linkedHashSet);
        Collections.sort(arrayList, this::a);
        return bl ? Util.subList((List)arrayList, (int)n2) : arrayList;
    }

    @Override
    @Nullable
    public Integer getVisits(UnicodeURL unicodeURL) {
        return this.a.getPageSessionsMap().getSessions(unicodeURL);
    }

    @Override
    public List<IKeywordInfo> getKeywords(UnicodeURL unicodeURL) {
        int n2 = e;
        ArrayList<IKeywordInfo> arrayList = new ArrayList<IKeywordInfo>();
        boolean bl = this.c.isTrackMultiplePositions();
        for (ITrackedKeyword iTrackedKeyword : this.d) {
            Set<UnicodeURL> set = KeywordsUtil.getKeywordFoundUrls(iTrackedKeyword, this.getSearchEngines());
            if (set.contains(unicodeURL)) {
                ProjectKeywordCollectorService projectKeywordCollectorService = this.a.getProjectKeywordCollectorService();
                GoogleAdwordsSettingsService googleAdwordsSettingsService = projectKeywordCollectorService.getGoogleAdwordsSettingsService();
                IGoogleAdwordsSettings iGoogleAdwordsSettings = googleAdwordsSettingsService.getGoogleAdwordsSettings();
                arrayList.add(new KeywordInfo(iTrackedKeyword, this.getSearchEngines(), iGoogleAdwordsSettings.getCountries(), bl));
            }
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    @Override
    public List<IKeywordGroup> getKeywordGroups() {
        int n2 = e;
        ArrayList<IKeywordGroup> arrayList = new ArrayList<IKeywordGroup>();
        for (ITrackedKeyword iTrackedKeyword : this.d) {
            if (!arrayList.contains(iTrackedKeyword.getGroup())) {
                arrayList.add(iTrackedKeyword.getGroup());
            }
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new c(this, null));
        return arrayList;
    }

    @Override
    @Nullable
    public Long getSearchVolume(@Nullable IKeywordGroup iKeywordGroup) {
        int n2 = e;
        Long l2 = null;
        for (IKeywordInfo iKeywordInfo : this.getKeywords(iKeywordGroup)) {
            SearchVolumeRange searchVolumeRange = iKeywordInfo.getSearchVolumeRange();
            long l3 = searchVolumeRange.getSearchVolume();
            if (l3 < 0L && n2 == 0) continue;
            if (l2 == null) {
                l2 = 0L;
            }
            l2 = l2 + l3;
            if (n2 == 0) continue;
        }
        return l2;
    }

    @Override
    public List<? extends IKeywordInfo> getKeywords(@Nullable IKeywordGroup iKeywordGroup) {
        return this.d.stream().filter(arg_0 -> KeywordsProjectWidgetService.a(iKeywordGroup, arg_0)).map(new d(this, null)).collect(Collectors.toList());
    }

    @Override
    public List<ILandingPage> getLandingPages() {
        int n2 = e;
        ArrayList<ILandingPage> arrayList = new ArrayList<ILandingPage>();
        for (ITrackedKeyword iTrackedKeyword : this.d) {
            if (!Util.contains(arrayList, (Object)iTrackedKeyword.getLandingPage(), (Comparator)new e(null))) {
                arrayList.add(iTrackedKeyword.getLandingPage());
            }
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new b(this, null));
        return arrayList;
    }

    @Override
    @Nullable
    public Long getExpectedVisits(ILandingPage iLandingPage) {
        int n2 = e;
        Long l2 = null;
        for (IKeywordInfo iKeywordInfo : this.getKeywords(iLandingPage)) {
            long l3 = iKeywordInfo.getExpectedVisits();
            if (l3 < 0L && n2 == 0) continue;
            if (l2 == null) {
                l2 = 0L;
            }
            l2 = l2 + l3;
            if (n2 == 0) continue;
        }
        return l2;
    }

    @Override
    public List<? extends IKeywordInfo> getKeywords(@Nullable ILandingPage iLandingPage) {
        return this.d.stream().filter(arg_0 -> KeywordsProjectWidgetService.a(iLandingPage, arg_0)).map(new d(this, null)).collect(Collectors.toList());
    }

    @Override
    public XYChartData<Integer> getTotalVisibilityChartData(GraphPeriod graphPeriod) {
        int n2 = e;
        List<SearchEngineType> list = this.getSearchEngines();
        List<Long> list2 = this.d.stream().map(IKeyword::getId).collect(Collectors.toList());
        XYDataset<Integer> xYDataset = this.a.getTrackedKeywordsService().getVisibilityPercentMap(list2, list);
        xYDataset.setColor(this.a.getProjectColor());
        XYChartData xYChartData = new XYChartData.Builder().addSeriesDataset(xYDataset).setStartDatePeriod(graphPeriod != GraphPeriod.ALL_TIME ? graphPeriod.getDate() : this.a.getEntranceDate()).build();
        if (RankTrackerStringKey.b != 0) {
            e = ++n2;
        }
        return xYChartData;
    }

    @Override
    public XYChartData<Integer> getBySearchEngineVisibilityChartData(GraphPeriod graphPeriod) {
        int n2 = e;
        List<SearchEngineType> list = this.getSearchEngines();
        ArrayList<XYDataset<Integer>> arrayList = new ArrayList<XYDataset<Integer>>();
        for (SearchEngineType searchEngineType : list) {
            List<Long> list2 = this.d.stream().map(IKeyword::getId).collect(Collectors.toList());
            XYDataset<Integer> xYDataset = this.a.getTrackedKeywordsService().getVisibilityPercentMap(list2, Collections.singletonList(searchEngineType));
            xYDataset.setColor(this.b.getColor((Object)searchEngineType));
            arrayList.add(xYDataset);
            if (n2 == 0) continue;
        }
        return new XYChartData.Builder().setSeriesDatasets(arrayList).setStartDatePeriod(graphPeriod != GraphPeriod.ALL_TIME ? graphPeriod.getDate() : this.a.getEntranceDate()).build();
    }

    @Override
    public XYChartData<Integer> getProjectAndCompetitorsVisibilityChartData(GraphPeriod graphPeriod) {
        int n2 = e;
        List<SearchEngineType> list = this.getSearchEngines();
        List<ICompetitor> list2 = this.getCompetitors();
        ArrayList<XYDataset<Integer>> arrayList = new ArrayList<XYDataset<Integer>>();
        List<Long> list3 = this.d.stream().map(IKeyword::getId).collect(Collectors.toList());
        XYDataset<Integer> xYDataset = this.a.getTrackedKeywordsService().getVisibilityPercentMap(list3, list);
        xYDataset.setColor(this.a.getProjectColor());
        arrayList.add(xYDataset);
        for (ICompetitor iCompetitor : list2) {
            List<Long> list4 = this.d.stream().map(IKeyword::getId).collect(Collectors.toList());
            XYDataset<Integer> xYDataset2 = this.a.getTrackedKeywordsService().getVisibilityPercentMap(list4, list, iCompetitor);
            xYDataset2.setColor(iCompetitor.getKeywordColor());
            arrayList.add(xYDataset2);
            if (n2 == 0) continue;
            int n3 = RankTrackerStringKey.b;
            RankTrackerStringKey.b = ++n3;
            break;
        }
        return new XYChartData.Builder().setSeriesDatasets(arrayList).setStartDatePeriod(graphPeriod != GraphPeriod.ALL_TIME ? graphPeriod.getDate() : this.a.getEntranceDate()).build();
    }

    @Override
    public XYChartData<Number> getVisitsChartData(GraphPeriod graphPeriod) {
        XYDataset<Number> xYDataset = this.A();
        return new XYChartData.Builder().addSeriesDataset(xYDataset).setStartDatePeriod(graphPeriod != GraphPeriod.ALL_TIME ? graphPeriod.getDate() : this.a.getEntranceDate()).build();
    }

    private XYDataset<Number> A() {
        int n2 = e;
        XYDataset xYDataset = new XYDataset(this.a.getProjectColor());
        Date date = this.a.getLastSiteSessionsCheckDate();
        if (date == null) {
            return xYDataset;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, -1);
        List<Integer> list = this.a.getTotalSiteSessions();
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            Date date2 = DateUtil.getStartDay((Date)calendar.getTime());
            xYDataset.put((Object)date2, (Object)list.get(i2));
            calendar.add(6, -1);
            if (n2 == 0) continue;
        }
        return xYDataset;
    }

    public List<TagStats> getTagsDistribution(boolean bl, int n2, Collection<String> collection) {
        return TagsDistributionServiceUtil.getTagsGetterTagStatus(this.d, (boolean)bl, (int)n2, collection);
    }

    private static boolean a(@Nullable ILandingPage iLandingPage, ITrackedKeyword iTrackedKeyword) {
        if (iTrackedKeyword.getLandingPage() == null && iLandingPage == null) {
            return true;
        }
        if (iTrackedKeyword.getLandingPage() != null && iLandingPage != null) {
            return iTrackedKeyword.getLandingPage().getUrl().equals((Object)iLandingPage.getUrl());
        }
        return false;
    }

    private static boolean a(@Nullable IKeywordGroup iKeywordGroup, ITrackedKeyword iTrackedKeyword) {
        return iTrackedKeyword.getGroup() == iKeywordGroup;
    }

    private int a(UnicodeURL unicodeURL, UnicodeURL unicodeURL2) {
        return Util.compare((Object)this.getVisits(unicodeURL2), (Object)this.getVisits(unicodeURL));
    }

    private static int a(IKeywordInfo iKeywordInfo, IKeywordInfo iKeywordInfo2) {
        return iKeywordInfo.getQuery().compareToIgnoreCase(iKeywordInfo2.getQuery());
    }

    private IKeywordInfo a(boolean bl, ITrackedKeyword iTrackedKeyword) {
        ProjectKeywordCollectorService projectKeywordCollectorService = this.a.getProjectKeywordCollectorService();
        IGoogleAdwordsSettings iGoogleAdwordsSettings = projectKeywordCollectorService.getGoogleAdwordsSettingsService().getGoogleAdwordsSettings();
        return new KeywordInfo(iTrackedKeyword, this.getSearchEngines(), iGoogleAdwordsSettings.getCountries(), bl);
    }

    static RankTrackerProjectService a(KeywordsProjectWidgetService keywordsProjectWidgetService) {
        return keywordsProjectWidgetService.a;
    }

    static IKeywordTrackingSettings b(KeywordsProjectWidgetService keywordsProjectWidgetService) {
        return keywordsProjectWidgetService.c;
    }
}

