/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.ranktracker.util;

import com.agilemind.commons.application.util.ProjectServiceProvider;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.ranktracker.data.api.ICompetitor;
import com.agilemind.ranktracker.data.service.RankTrackerProjectService;
import com.agilemind.ranktracker.util.KeywordDifficultyRendererInfoProvider;
import com.agilemind.ranktracker.views.serp.SerpDeepAnalysisUtil;
import java.awt.Color;
import java.util.stream.Stream;

public class ProjectKeywordDifficultyRendererInfoProvider
implements KeywordDifficultyRendererInfoProvider {
    private final ProjectServiceProvider<RankTrackerProjectService> a;

    public ProjectKeywordDifficultyRendererInfoProvider(ProjectServiceProvider<RankTrackerProjectService> projectServiceProvider) {
        this.a = projectServiceProvider;
    }

    @Override
    public boolean isProjectUrl(UnicodeURL unicodeURL) {
        RankTrackerProjectService rankTrackerProjectService = this.A();
        return Stream.concat(rankTrackerProjectService.getAlternateUrls().stream(), Stream.of(rankTrackerProjectService.getProjectUrl())).anyMatch(arg_0 -> ProjectKeywordDifficultyRendererInfoProvider.a(unicodeURL, rankTrackerProjectService, arg_0));
    }

    @Override
    public Color getProjectColor() {
        return this.A().getProjectColor();
    }

    @Override
    public boolean isCompetitorsVisible() {
        return this.A().isCompetitorsVisible();
    }

    @Override
    public ICompetitor getCompetitor(UnicodeURL unicodeURL) {
        return this.A().getCompetitorsList().stream().filter(arg_0 -> ProjectKeywordDifficultyRendererInfoProvider.a(unicodeURL, arg_0)).sorted(ProjectKeywordDifficultyRendererInfoProvider::a).findFirst().orElse(null);
    }

    @Override
    public boolean isCompetitorsLimitReached() {
        return this.A().getCompetitorsList().size() >= 20;
    }

    private RankTrackerProjectService A() {
        return (RankTrackerProjectService)this.a.getProjectService();
    }

    private static int a(ICompetitor iCompetitor, ICompetitor iCompetitor2) {
        return Integer.compare(iCompetitor.getURL().toUnicodeString().length(), iCompetitor2.getURL().toUnicodeString().length());
    }

    private static boolean a(UnicodeURL unicodeURL, ICompetitor iCompetitor) {
        return SerpDeepAnalysisUtil.isInScope(iCompetitor.getURL(), unicodeURL, (boolean)iCompetitor.getWWW());
    }

    private static boolean a(UnicodeURL unicodeURL, RankTrackerProjectService rankTrackerProjectService, UnicodeURL unicodeURL2) {
        return SerpDeepAnalysisUtil.isInScope(unicodeURL2, unicodeURL, rankTrackerProjectService.isIgnoreWWW());
    }
}

