/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.ranktracker.util;

import com.agilemind.commons.io.searchengine.searchengines.type.SearchEngineType;
import com.agilemind.commons.util.DateUtil;
import com.agilemind.commons.util.ThreadSafeUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.ranktracker.data.api.ICompetitor;
import com.agilemind.ranktracker.data.api.KeyPositionResult;
import com.agilemind.ranktracker.data.api.SerpHistoryRecord;
import com.agilemind.ranktracker.data.service.RankTrackerProjectService;
import com.agilemind.ranktracker.data.service.TrackedKeywordService;
import com.agilemind.ranktracker.util.AbstractWordFormsAcceptor;
import com.agilemind.ranktracker.util.KeyPositionAnalyzerResult;
import com.agilemind.ranktracker.util.ScanKeywordResult;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class ScanKeywordsResultConsumer
implements Consumer<List<ScanKeywordResult>> {
    private RankTrackerProjectService a;

    public ScanKeywordsResultConsumer(RankTrackerProjectService rankTrackerProjectService) {
        this.a = rankTrackerProjectService;
    }

    @Override
    public void accept(List<ScanKeywordResult> list) {
        ThreadSafeUtil.invokeLater(() -> this.a(list));
    }

    private void a(List list) {
        boolean bl = AbstractWordFormsAcceptor.e;
        for (ScanKeywordResult scanKeywordResult : list) {
            KeyPositionAnalyzerResult keyPositionAnalyzerResult = scanKeywordResult.getKeyPositionAnalyzerResult();
            if (keyPositionAnalyzerResult == null) {
                return;
            }
            long l2 = scanKeywordResult.getKeywordId();
            SearchEngineType searchEngineType = scanKeywordResult.getSearchEngineType();
            TrackedKeywordService trackedKeywordService = this.a.getTrackedKeywordsService();
            Map<UnicodeURL, List<KeyPositionResult>> map = keyPositionAnalyzerResult.getPositionsResults();
            List<KeyPositionResult> list2 = map.get(this.a.getProjectUrl());
            if (list2 != null) {
                trackedKeywordService.addPosition(l2, searchEngineType, list2);
            }
            Object object = this.a.getCompetitorsList().iterator();
            while (object.hasNext()) {
                ICompetitor iCompetitor = object.next();
                if (!iCompetitor.isEnable().booleanValue() && !bl) continue;
                List<KeyPositionResult> list3 = map.get(iCompetitor.getURL());
                if (list3 != null) {
                    trackedKeywordService.addPosition(l2, iCompetitor.getId(), searchEngineType, list3);
                }
                if (!bl) continue;
            }
            if (!(object = keyPositionAnalyzerResult.getSerpHistoryRecords()).isEmpty()) {
                trackedKeywordService.addSerpHistory(l2, searchEngineType, DateUtil.getTimezoneToday(), object.toArray(new SerpHistoryRecord[object.size()]));
            }
            if (!bl) continue;
        }
    }
}

