/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.util.LangProfile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectorFactory {
    protected int capacity = 0;
    protected HashMap<String, double[]> wordLangProbMap = new HashMap();
    protected ArrayList<String> langlist = new ArrayList();
    protected Long seed = null;

    public static DetectorFactory newInstance() {
        return new DetectorFactory();
    }

    private DetectorFactory() {
    }

    private void ensureCapacity(int newCapacity) {
        if (newCapacity > this.capacity) {
            for (Map.Entry<String, double[]> entry : this.wordLangProbMap.entrySet()) {
                double[] newProb = new double[newCapacity];
                System.arraycopy(entry.getValue(), 0, newProb, 0, this.capacity);
                entry.setValue(newProb);
            }
            this.capacity = newCapacity;
        }
    }

    private void ensureRemainingCapacity(int freeCapacity) {
        this.ensureCapacity(this.langlist.size() + freeCapacity);
    }

    public void loadDefaultProfiles() throws IOException {
        InputStream profileListStream = this.getClass().getResourceAsStream("profiles/profiles.lst");
        if (profileListStream == null) {
            throw new IOException("Couldn't find default profiles package");
        }
        InputStreamReader profileListReader = new InputStreamReader(profileListStream);
        BufferedReader profileListBuffer = new BufferedReader(profileListReader);
        String profileList = profileListBuffer.readLine();
        String[] profiles = profileList.split(",");
        this.ensureRemainingCapacity(profiles.length);
        for (String profileName : profiles) {
            InputStream is = null;
            try {
                is = this.getClass().getResourceAsStream("profiles/" + profileName);
                LangProfile profile = JSON.decode(is, LangProfile.class);
                this.addProfile(profile);
            }
            catch (JSONException e) {
                throw new IOException("Profile format error in '" + profileName + "'", e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void loadProfiles(String profileDirectory) throws IOException {
        this.loadProfiles(new File(profileDirectory));
    }

    public void loadProfiles(File profileDirectory) throws IOException {
        File[] listFiles = profileDirectory.listFiles();
        if (listFiles == null) {
            throw new IOException("Couldn't open directory or directory is empty: " + profileDirectory);
        }
        this.ensureRemainingCapacity(listFiles.length);
        for (File file : listFiles) {
            if (file.getName().startsWith(".") || !file.isFile()) continue;
            this.loadProfile(file);
        }
    }

    public void loadProfiles(List<String> json_profiles) throws IOException {
        this.ensureRemainingCapacity(json_profiles.size());
        for (String json : json_profiles) {
            this.loadProfile(json);
        }
    }

    public void loadProfile(File profileFile) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(profileFile);
            LangProfile profile = JSON.decode((InputStream)is, LangProfile.class);
            this.addProfile(profile);
        }
        catch (JSONException e) {
            throw new IOException("Profile format error in '" + profileFile.getName() + "'", e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void loadProfile(String jsonProfile) throws IOException {
        try {
            LangProfile profile = JSON.decode(jsonProfile, LangProfile.class);
            this.addProfile(profile);
        }
        catch (JSONException e) {
            throw new IOException("Profile format error");
        }
    }

    void addProfile(LangProfile profile) {
        String lang = profile.name;
        if (this.langlist.contains(lang)) {
            throw new IllegalArgumentException("Duplicate language profile for [" + lang + "]");
        }
        int index = this.langlist.size();
        if (this.capacity <= index) {
            this.ensureCapacity(this.capacity + 1);
        }
        this.langlist.add(lang);
        for (String word : profile.freq.keySet()) {
            double prob;
            int length;
            if (!this.wordLangProbMap.containsKey(word)) {
                this.wordLangProbMap.put(word, new double[this.capacity]);
            }
            if ((length = word.length()) < 1 || length > 3) continue;
            this.wordLangProbMap.get((Object)word)[index] = prob = profile.freq.get(word).doubleValue() / (double)profile.n_words[length - 1];
        }
    }

    public void clear() {
        this.langlist.clear();
        this.wordLangProbMap.clear();
    }

    public Detector create() {
        return this.createDetector();
    }

    public Detector create(double alpha) {
        Detector detector = this.createDetector();
        detector.setAlpha(alpha);
        return detector;
    }

    private Detector createDetector() {
        if (this.langlist.size() == 0) {
            throw new IllegalStateException("Profiles need to be loaded first");
        }
        Detector detector = new Detector(this);
        return detector;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public final List<String> getLangList() {
        return Collections.unmodifiableList(this.langlist);
    }
}

