/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.BrowserContextParams;
import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.NetworkService;
import com.teamdev.jxbrowser.chromium.ProxyConfig;
import com.teamdev.jxbrowser.chromium.SpellCheckerService;
import com.teamdev.jxbrowser.chromium.ZoomService;
import com.teamdev.jxbrowser.chromium.internal.BrowserContextIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;

public final class BrowserContext {
    private static final BrowserContext a = new BrowserContext(new BrowserContextParams(BrowserPreferences.getDefaultDataDir()), -1);
    private final int b;
    private final IPC c;
    private final String d;
    private final String e;
    private final String f;
    private final String g;
    private final ProxyConfig h;
    private final ZoomService i;
    private final NetworkService j;
    private final SpellCheckerService k;

    public static BrowserContext defaultContext() {
        return a;
    }

    public BrowserContext(BrowserContextParams browserContextParams) {
        this(browserContextParams, BrowserContextIDGenerator.generate());
    }

    private BrowserContext(BrowserContextParams browserContextParams, int n2) {
        this(browserContextParams, n2, IPC.getDefault());
    }

    private BrowserContext(BrowserContextParams object, int n2, IPC iPC) {
        if (object == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        this.b = n2;
        this.c = iPC;
        this.d = ((BrowserContextParams)object).getDataDir();
        this.e = ((BrowserContextParams)object).getCacheDir();
        this.f = ((BrowserContextParams)object).getMemoryDir();
        this.g = ((BrowserContextParams)object).getAcceptLanguage();
        this.h = ((BrowserContextParams)object).getProxyConfig();
        this.i = new ZoomService(n2, iPC);
        this.j = new NetworkService(n2, iPC);
        this.k = new SpellCheckerService(n2, iPC);
        object = this;
        FileUtil.createDirs(((BrowserContext)object).d);
        FileUtil.createDirs(((BrowserContext)object).e);
        if (!Environment.isWindows()) {
            FileUtil.createDirs(((BrowserContext)object).f);
        }
    }

    public final String getDataDir() {
        return this.d;
    }

    public final String getCacheDir() {
        return this.e;
    }

    public final String getMemoryDir() {
        return this.f;
    }

    public final String getAcceptLanguage() {
        return this.g;
    }

    public final ProxyConfig getProxyConfig() {
        return this.h;
    }

    public final NetworkService getNetworkService() {
        return this.j;
    }

    public final ZoomService getZoomService() {
        return this.i;
    }

    public final SpellCheckerService getSpellCheckerService() {
        return this.k;
    }

    public final int getIdentifier() {
        return this.b;
    }

    final IPC a() {
        return this.c;
    }
}

