/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.ai;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelType;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPCException;
import javafx.application.Platform;
import javax.swing.SwingUtilities;

public final class BrowserCore {
    public static void initialize() {
        if (Environment.isMac() && Environment.isJavaFX() && Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Browser Core cannot be initialized in JavaFX Application Thread on Mac OS.");
        }
        IPC.getDefault().start();
    }

    public static boolean isInitialized() {
        return IPC.getDefault().isStarted();
    }

    public static void shutdown() {
        if (Environment.isMac()) {
            IPC iPC = IPC.getDefault();
            Object object = iPC.getChannels();
            object = object.iterator();
            while (object.hasNext()) {
                Channel channel = (Channel)object.next();
                if (channel.getType() != ChannelType.Browser) continue;
                throw new IPCException("Failed to shutdown IPC. Pending Browser instances are detected. IPC cannot be destroyed until at least one Browser instance is running. To shutdown IPC dispose all Browser instances.");
            }
            iPC.initiateShutdown();
            object = new ai(iPC);
            if (Environment.isJavaFX()) {
                if (Platform.isFxApplicationThread()) {
                    new Thread((Runnable)object).start();
                    return;
                }
                object.run();
                return;
            }
            SwingUtilities.invokeLater((Runnable)object);
        }
    }
}

