/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.internal.ChromiumBuild;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BrowserPreferences {
    public static final String USER_AGENT_PROPERTY = "jxbrowser.chromium.user-agent";
    public static final String CHROMIUM_DIR_PROPERTY = "jxbrowser.chromium.dir";
    public static final String TEMP_DIR_PROPERTY = "jxbrowser.tmp.dir";
    private static final Set<String> a = new LinkedHashSet<String>();
    private static final Map<String, String> b = new HashMap<String, String>();
    private String c;
    private boolean d;
    private boolean e;
    private boolean f;
    private boolean g;
    private boolean h;
    private boolean i;
    private boolean j;
    private boolean k;
    private boolean l;
    private boolean m;
    private boolean n;
    private boolean o;
    private boolean p;
    private boolean q;

    public static void setChromiumDir(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The chromiumDir parameter cannot be null.");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("The chromiumDir string cannot be empty.");
        }
        System.setProperty(CHROMIUM_DIR_PROPERTY, string);
    }

    public static String getChromiumDir() {
        return System.getProperty(CHROMIUM_DIR_PROPERTY, BrowserPreferences.getDefaultChromiumDir());
    }

    public static void setUserAgent(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The userAgent parameter cannot be null.");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("The userAgent string cannot be empty.");
        }
        System.setProperty(USER_AGENT_PROPERTY, string);
    }

    public static String getUserAgent() {
        return System.getProperty(USER_AGENT_PROPERTY);
    }

    public static String getDefaultChromiumDir() {
        Object object = ChromiumBuild.version();
        String string = System.getProperty("java.io.tmpdir");
        object = "jxbrowser-chromium-" + (String)object;
        object = new File(string, (String)object);
        return ((File)object).getAbsolutePath();
    }

    public static String getDefaultDataDir() {
        File file = new File(BrowserPreferences.getDefaultChromiumDir(), "data");
        return file.getAbsolutePath();
    }

    public static String getDefaultCacheDir() {
        return BrowserPreferences.getDefaultDataDir() + File.separator + "Cache";
    }

    public static String getDefaultMemoryDir() {
        return BrowserPreferences.getDefaultDataDir() + File.separator + "Memory";
    }

    public static String getTempDir() {
        return System.getProperty(TEMP_DIR_PROPERTY, BrowserPreferences.getDefaultDataDir() + File.separator + "Temp");
    }

    public static String getDefaultAcceptLanguage() {
        String string = System.getProperty("user.country", "us");
        String string2 = System.getProperty("user.language", "en");
        string = string2 + '-' + string.toLowerCase();
        return string;
    }

    public static void setChromiumSwitches(String ... stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The switches parameter cannot be null.");
        }
        a.clear();
        Collections.addAll(a, stringArray);
    }

    public static List<String> getChromiumSwitches() {
        return new ArrayList<String>(a);
    }

    public static void setChromiumVariable(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("The name parameter cannot be null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The value parameter cannot be null.");
        }
        b.put(string, string2);
    }

    public static Map<String, String> getChromiumVariables() {
        return new HashMap<String, String>(b);
    }

    public String getDefaultEncoding() {
        return this.c;
    }

    public boolean isJavaScriptEnabled() {
        return this.d;
    }

    public boolean isJavaScriptCanOpenWindowsAutomatically() {
        return this.e;
    }

    public boolean isLoadsImagesAutomatically() {
        return this.g;
    }

    public boolean isImagesEnabled() {
        return this.h;
    }

    public boolean isPluginsEnabled() {
        return this.i;
    }

    public boolean isAllowScriptsToCloseWindows() {
        return this.j;
    }

    public boolean isJavaScriptCanAccessClipboard() {
        return this.f;
    }

    public boolean isLocalStorageEnabled() {
        return this.k;
    }

    public boolean isDatabasesEnabled() {
        return this.l;
    }

    public boolean isWebAudioEnabled() {
        return this.m;
    }

    public boolean isApplicationCacheEnabled() {
        return this.n;
    }

    public boolean isAllowDisplayingInsecureContent() {
        return this.o;
    }

    public boolean isAllowRunningInsecureContent() {
        return this.p;
    }

    public void setDefaultEncoding(String string) {
        this.c = string;
    }

    public void setJavaScriptEnabled(boolean bl) {
        this.d = bl;
    }

    public void setJavaScriptCanOpenWindowsAutomatically(boolean bl) {
        this.e = bl;
    }

    public void setLoadsImagesAutomatically(boolean bl) {
        this.g = bl;
    }

    public void setImagesEnabled(boolean bl) {
        this.h = bl;
    }

    public void setPluginsEnabled(boolean bl) {
        this.i = bl;
    }

    public void setAllowScriptsToCloseWindows(boolean bl) {
        this.j = bl;
    }

    public void setJavaScriptCanAccessClipboard(boolean bl) {
        this.f = bl;
    }

    public void setLocalStorageEnabled(boolean bl) {
        this.k = bl;
    }

    public void setDatabasesEnabled(boolean bl) {
        this.l = bl;
    }

    public void setWebAudioEnabled(boolean bl) {
        this.m = bl;
    }

    public void setApplicationCacheEnabled(boolean bl) {
        this.n = bl;
    }

    public void setAllowDisplayingInsecureContent(boolean bl) {
        this.o = bl;
    }

    public void setAllowRunningInsecureContent(boolean bl) {
        this.p = bl;
    }

    public void setUnifiedTextcheckerEnabled(boolean bl) {
        this.q = bl;
    }

    public boolean isUnifiedTextcheckerEnabled() {
        return this.q;
    }
}

