/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.ExtendedKeyUsage;
import com.teamdev.jxbrowser.chromium.KeyUsage;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.Principal;
import com.teamdev.jxbrowser.chromium.SubjectAlternativeName;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.bind.DatatypeConverter;

public final class Certificate {
    private final String a;
    private final String b;
    private final boolean c;
    private final long d;
    private final long e;
    private final String f;
    private final Principal g;
    private final Principal h;
    private final X509Certificate i;

    public Certificate(String object, String string, boolean bl, long l2, long l3, String string2, String string3) {
        this.a = object;
        this.b = string;
        this.c = bl;
        this.d = l2;
        this.e = l3;
        this.f = string2;
        this.i = Certificate.a(string3);
        object = this.i;
        this.g = object != null ? new Principal(((X509Certificate)object).getIssuerX500Principal().getName()) : null;
        object = this.i;
        this.h = object != null ? new Principal(((X509Certificate)object).getSubjectX500Principal().getName()) : null;
    }

    private static X509Certificate a(String object) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            object = DatatypeConverter.parseBase64Binary((String)object);
            object = new ByteArrayInputStream((byte[])object);
            return (X509Certificate)certificateFactory.generateCertificate((InputStream)object);
        }
        catch (CertificateException certificateException) {
            LoggerProvider.getBrowserLogger().log(Level.WARNING, "Failed to parse X509Certificate data. " + certificateException.getMessage());
            return null;
        }
    }

    public final X509Certificate getX509Certificate() {
        return this.i;
    }

    public final Principal getIssuer() {
        return this.g;
    }

    public final String getIssuerName() {
        return this.a;
    }

    public final Principal getSubject() {
        return this.h;
    }

    public final String getSubjectName() {
        return this.b;
    }

    public final boolean hasExpired() {
        return this.c;
    }

    public final long getValidStartTime() {
        return this.d;
    }

    public final long getValidExpiryTime() {
        return this.e;
    }

    public final String getFingerPrint() {
        if (this.i != null) {
            try {
                Object object = MessageDigest.getInstance("SHA-1");
                Object[] objectArray = this.i.getEncoded();
                ((MessageDigest)object).update((byte[])objectArray);
                byte[] byArray = ((MessageDigest)object).digest();
                object = byArray;
                object = byArray;
                objectArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
                StringBuilder stringBuilder = new StringBuilder(((Object)object).length << 1);
                for (Object object2 : object) {
                    stringBuilder.append((char)objectArray[(object2 & 0xF0) >> 4]);
                    stringBuilder.append((char)objectArray[object2 & 0xF]);
                }
                return stringBuilder.toString();
            }
            catch (Exception exception) {
                return "";
            }
        }
        return "";
    }

    public final String getSerialNumber() {
        if (this.i != null) {
            return this.i.getSerialNumber().toString().toUpperCase();
        }
        return "";
    }

    public final List<KeyUsage> getKeyUsages() {
        boolean[] blArray;
        LinkedList<KeyUsage> linkedList = new LinkedList<KeyUsage>();
        if (this.i != null && (blArray = this.i.getKeyUsage()) != null) {
            for (int i2 = 0; i2 < blArray.length && KeyUsage.values().length > i2; ++i2) {
                if (!blArray[i2]) continue;
                linkedList.add(KeyUsage.values()[i2]);
            }
        }
        return linkedList;
    }

    public final List<ExtendedKeyUsage> getExtendedKeyUsages() {
        LinkedList<ExtendedKeyUsage> linkedList = new LinkedList<ExtendedKeyUsage>();
        if (this.i != null) {
            try {
                Object object = this.i.getExtendedKeyUsage();
                if (object != null) {
                    object = object.iterator();
                    while (object.hasNext()) {
                        Object object2 = (String)object.next();
                        if ((object2 = ExtendedKeyUsage.a(object2)) == null) continue;
                        linkedList.add((ExtendedKeyUsage)((Object)object2));
                    }
                }
            }
            catch (CertificateParsingException certificateParsingException) {}
        }
        return linkedList;
    }

    public final List<SubjectAlternativeName> getSubjectAlternativeNames() {
        LinkedList<SubjectAlternativeName> linkedList = new LinkedList<SubjectAlternativeName>();
        if (this.i != null) {
            try {
                Object object = this.i.getSubjectAlternativeNames();
                if (object != null) {
                    object = object.iterator();
                    while (object.hasNext()) {
                        Object object2 = (List)object.next();
                        if (object2.size() != 2) continue;
                        int n2 = (Integer)object2.get(0);
                        object2 = object2.get(1).toString();
                        if (n2 >= SubjectAlternativeName.Type.values().length) continue;
                        linkedList.add(new SubjectAlternativeName(SubjectAlternativeName.Type.values()[n2], (String)object2));
                    }
                }
            }
            catch (CertificateParsingException certificateParsingException) {}
        }
        return linkedList;
    }

    public final String getCAFingerPrint() {
        return this.f;
    }

    public final String toString() {
        return "Certificate{subject=" + this.h + '}';
    }
}

