/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.BeforeRedirectParams;
import com.teamdev.jxbrowser.chromium.BeforeSendHeadersParams;
import com.teamdev.jxbrowser.chromium.BeforeSendProxyHeadersParams;
import com.teamdev.jxbrowser.chromium.BeforeURLRequestParams;
import com.teamdev.jxbrowser.chromium.BytesData;
import com.teamdev.jxbrowser.chromium.Certificate;
import com.teamdev.jxbrowser.chromium.CertificateVerifier;
import com.teamdev.jxbrowser.chromium.CertificateVerifyFlag;
import com.teamdev.jxbrowser.chromium.CertificateVerifyParams;
import com.teamdev.jxbrowser.chromium.CertificateVerifyResult;
import com.teamdev.jxbrowser.chromium.Cookie;
import com.teamdev.jxbrowser.chromium.DataReceivedParams;
import com.teamdev.jxbrowser.chromium.FormData;
import com.teamdev.jxbrowser.chromium.HeadersReceivedParams;
import com.teamdev.jxbrowser.chromium.HostPortPair;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.MultipartFormData;
import com.teamdev.jxbrowser.chromium.NetworkDelegate;
import com.teamdev.jxbrowser.chromium.PACScriptErrorParams;
import com.teamdev.jxbrowser.chromium.ProxyType;
import com.teamdev.jxbrowser.chromium.RequestCompletedParams;
import com.teamdev.jxbrowser.chromium.RequestParams;
import com.teamdev.jxbrowser.chromium.RequestStatus;
import com.teamdev.jxbrowser.chromium.ResourceHandler;
import com.teamdev.jxbrowser.chromium.ResourceParams;
import com.teamdev.jxbrowser.chromium.ResourceType;
import com.teamdev.jxbrowser.chromium.ResponseStartedParams;
import com.teamdev.jxbrowser.chromium.SendHeadersParams;
import com.teamdev.jxbrowser.chromium.StatusLine;
import com.teamdev.jxbrowser.chromium.TextData;
import com.teamdev.jxbrowser.chromium.UploadData;
import com.teamdev.jxbrowser.chromium.am;
import com.teamdev.jxbrowser.chromium.events.NetError;
import com.teamdev.jxbrowser.chromium.internal.CertificateFactory;
import com.teamdev.jxbrowser.chromium.internal.CookieParser;
import com.teamdev.jxbrowser.chromium.internal.EventQueue;
import com.teamdev.jxbrowser.chromium.internal.HttpHeadersExImpl;
import com.teamdev.jxbrowser.chromium.internal.HttpHeadersImpl;
import com.teamdev.jxbrowser.chromium.internal.UploadDataBuilderCreator;
import com.teamdev.jxbrowser.chromium.internal.UploadDataFactory;
import com.teamdev.jxbrowser.chromium.internal.UploadDataUtils;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCChannelAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CloseAuthDialogMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageType;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeRedirectMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeSendHeadersMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeSendProxyHeadersMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeURLRequestMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCanGetCookiesMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCanSetCookiesMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCompletedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDataReceivedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnHeadersReceivedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnPACScriptErrorMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRequestDestroyedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnResponseStartedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRunAuthDialogMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnSendHeadersMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShouldBeginRequestMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnVerifyCertMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetNetworkDelegateConfigMessage;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NetworkService {
    private static final Logger a = LoggerProvider.getBrowserLogger();
    private final int b;
    private final EventQueue c;
    private final ChannelListener d;
    private Channel e;
    private ResourceHandler f;
    private NetworkDelegate g;
    private CertificateVerifier h;

    NetworkService(int n2, IPC iPC) {
        this.b = n2;
        this.c = EventQueue.createFixedEventQueue("Network Events Thread");
        this.d = new a(0);
        this.e = iPC.getMainChannel();
        if (this.e != null) {
            this.e.addChannelListener(this.d);
        }
        iPC.addIPCChannelListener(new b(this, 0));
    }

    final void a() {
        if (this.e != null) {
            boolean bl = this.g == null;
            this.e.send(new SetNetworkDelegateConfigMessage(MessageUIDGenerator.generate(), this.b, bl));
        }
    }

    public final void setNetworkDelegate(NetworkDelegate networkDelegate) {
        this.g = networkDelegate;
        this.a();
    }

    public final NetworkDelegate getNetworkDelegate() {
        return this.g;
    }

    public final void setCertificateVerifier(CertificateVerifier certificateVerifier) {
        this.h = certificateVerifier;
    }

    public final CertificateVerifier getCertificateVerifier() {
        return this.h;
    }

    public final void setResourceHandler(ResourceHandler resourceHandler) {
        this.f = resourceHandler;
    }

    public final ResourceHandler getResourceHandler() {
        return this.f;
    }

    final class b
    extends IPCChannelAdapter {
        private /* synthetic */ NetworkService a;

        private b(NetworkService networkService) {
            this.a = networkService;
        }

        @Override
        public final void onMainChannelAdded(Channel channel) {
            channel.addChannelListener(this.a.d);
            this.a.e = channel;
        }

        @Override
        public final void onMainChannelRemoved(Channel channel) {
            channel.removeChannelListener(this.a.d);
            this.a.e = null;
        }

        /* synthetic */ b(NetworkService networkService, byte by) {
            this(networkService);
        }
    }

    final class a
    extends ChannelAdapter {
        private a() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final void onMessageReceived(Message object) {
            MessageType messageType = object.getType();
            if (messageType == MessageType.OnBeforeUrlRequest) {
                OnBeforeURLRequestMessage onBeforeURLRequestMessage = (OnBeforeURLRequestMessage)object;
                object = this;
                if (onBeforeURLRequestMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.g == null) return;
                try {
                    Object object2;
                    Object object3;
                    Object object4;
                    long l2 = onBeforeURLRequestMessage.getRequestId();
                    String string = onBeforeURLRequestMessage.getURL();
                    String string2 = onBeforeURLRequestMessage.getMethod();
                    Object object5 = onBeforeURLRequestMessage.getOriginalHeaders();
                    byte[] byArray = onBeforeURLRequestMessage.getUploadData();
                    String string3 = onBeforeURLRequestMessage.getFileList();
                    HttpHeadersExImpl httpHeadersExImpl = HttpHeadersExImpl.buildFromString((String)object5);
                    String string4 = httpHeadersExImpl.getStringRepresentation("\r\n");
                    UploadData uploadData = null;
                    if ("POST".equals(string2)) {
                        object4 = httpHeadersExImpl.getHeader("Content-Type");
                        uploadData = UploadDataFactory.create((String)object4, byArray, string3);
                    }
                    if ("PUT".equals(string2) || "PATCH".equals(string2)) {
                        uploadData = new BytesData(byArray);
                    }
                    object4 = new BeforeURLRequestParams(l2, string, string2, uploadData);
                    ((a)object).NetworkService.this.g.onBeforeURLRequest((BeforeURLRequestParams)object4);
                    if ("POST".equals(string2)) {
                        object3 = ((BeforeURLRequestParams)object4).getUploadData();
                        if (object3 instanceof TextData) {
                            UploadDataBuilderCreator.create(object3.getType(), httpHeadersExImpl);
                            object2 = (TextData)object3;
                            String string5 = ((TextData)object2).getText();
                            byte[] byArray2 = string5.getBytes("UTF-8");
                            if (!Arrays.equals(byArray2, byArray)) {
                                onBeforeURLRequestMessage.setUploadData(byArray2);
                            }
                        } else if (object3 instanceof MultipartFormData) {
                            if (!object3.equals(uploadData)) {
                                object2 = UploadDataBuilderCreator.create(object3.getType(), httpHeadersExImpl);
                                MultipartFormData multipartFormData = (MultipartFormData)object3;
                                Map<String, List<String>> map = UploadDataUtils.buildKeyValuesMap(multipartFormData);
                                object5 = UploadDataUtils.buildFilesMap(multipartFormData);
                                onBeforeURLRequestMessage.setUploadData(object2.buildKeyValues(map, (Map<String, List<String>>)object5).getBytes("UTF-8"));
                                onBeforeURLRequestMessage.setFileList(object2.buildFileList((Map<String, List<String>>)object5));
                            }
                        } else if (object3 instanceof FormData) {
                            if (!object3.equals(uploadData)) {
                                object2 = UploadDataBuilderCreator.create(object3.getType(), httpHeadersExImpl);
                                FormData formData = (FormData)object3;
                                Map<String, List<String>> map = UploadDataUtils.buildKeyValuesMap(formData);
                                onBeforeURLRequestMessage.setUploadData(object2.buildKeyValues(map).getBytes("UTF-8"));
                            }
                        } else if (object3 instanceof BytesData && !object3.equals(uploadData)) {
                            UploadDataBuilderCreator.create(object3.getType(), httpHeadersExImpl);
                            object2 = (BytesData)object3;
                            byte[] byArray3 = ((BytesData)object2).getData();
                            if (!Arrays.equals(byArray3, byArray)) {
                                onBeforeURLRequestMessage.setUploadData(byArray3);
                            }
                        }
                    } else if (("PUT".equals(string2) || "PATCH".equals(string2)) && (object3 = ((BeforeURLRequestParams)object4).getUploadData()) instanceof BytesData) {
                        UploadDataBuilderCreator.create(object3.getType(), httpHeadersExImpl);
                        object2 = (BytesData)object3;
                        byte[] byArray4 = ((BytesData)object2).getData();
                        if (!Arrays.equals(byArray4, byArray)) {
                            onBeforeURLRequestMessage.setUploadData(byArray4);
                        }
                    }
                    object3 = httpHeadersExImpl.getStringRepresentation("\r\n");
                    if (!string4.equals(object3)) {
                        onBeforeURLRequestMessage.setOverrideHeaders((String)object3);
                    }
                    if ((object2 = ((RequestParams)object4).getURL()) == null || string.equals(object2)) return;
                    onBeforeURLRequestMessage.setNewLocation((String)object2);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onBeforeURLRequest() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnBeforeSendHeaders) {
                OnBeforeSendHeadersMessage onBeforeSendHeadersMessage = (OnBeforeSendHeadersMessage)object;
                object = this;
                if (onBeforeSendHeadersMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.g == null) return;
                try {
                    String string;
                    String string6 = onBeforeSendHeadersMessage.getURL();
                    String string7 = onBeforeSendHeadersMessage.getMethod();
                    long l3 = onBeforeSendHeadersMessage.getRequestId();
                    String string8 = onBeforeSendHeadersMessage.getOriginalHeaders();
                    HttpHeadersImpl httpHeadersImpl = HttpHeadersImpl.buildFromString(string8);
                    HttpHeadersExImpl httpHeadersExImpl = HttpHeadersExImpl.buildFromString(string8);
                    String string9 = httpHeadersImpl.getStringRepresentation("\r\n");
                    String string10 = httpHeadersExImpl.getStringRepresentation("\r\n");
                    BeforeSendHeadersParams beforeSendHeadersParams = new BeforeSendHeadersParams(l3, string6, string7, httpHeadersImpl, httpHeadersExImpl);
                    ((a)object).NetworkService.this.g.onBeforeSendHeaders(beforeSendHeadersParams);
                    String string11 = httpHeadersImpl.getStringRepresentation("\r\n");
                    if (!string9.equals(string11)) {
                        onBeforeSendHeadersMessage.setOverrideHeaders(string11);
                    }
                    if (string10.equals(string = httpHeadersExImpl.getStringRepresentation("\r\n"))) return;
                    onBeforeSendHeadersMessage.setOverrideHeaders(string);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onBeforeSendHeaders() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnSendHeaders) {
                OnSendHeadersMessage onSendHeadersMessage = (OnSendHeadersMessage)object;
                object = this;
                if (onSendHeadersMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.g == null) return;
                try {
                    String string = onSendHeadersMessage.getURL();
                    String string12 = onSendHeadersMessage.getMethod();
                    String string13 = onSendHeadersMessage.getHeaders();
                    long l4 = onSendHeadersMessage.getRequestId();
                    HttpHeadersImpl httpHeadersImpl = HttpHeadersImpl.buildFromString(string13);
                    HttpHeadersExImpl httpHeadersExImpl = HttpHeadersExImpl.buildFromString(string13);
                    SendHeadersParams sendHeadersParams = new SendHeadersParams(l4, string, string12, httpHeadersImpl, httpHeadersExImpl);
                    ((a)object).NetworkService.this.g.onSendHeaders(sendHeadersParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onSendHeaders() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnHeadersReceived) {
                OnHeadersReceivedMessage onHeadersReceivedMessage = (OnHeadersReceivedMessage)object;
                object = this;
                if (onHeadersReceivedMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.g == null) return;
                try {
                    String string = onHeadersReceivedMessage.getURL();
                    String string14 = onHeadersReceivedMessage.getMethod();
                    long l5 = onHeadersReceivedMessage.getRequestId();
                    int n2 = onHeadersReceivedMessage.getContentLength();
                    String string15 = onHeadersReceivedMessage.getCharset();
                    String string16 = onHeadersReceivedMessage.getMimeType();
                    int n3 = onHeadersReceivedMessage.getResponseCode();
                    String string17 = onHeadersReceivedMessage.getStatusLine();
                    String string18 = onHeadersReceivedMessage.getStatusText();
                    String string19 = onHeadersReceivedMessage.getOriginalHeaders();
                    HttpHeadersImpl httpHeadersImpl = HttpHeadersImpl.buildFromString(string19);
                    String string20 = httpHeadersImpl.getStringRepresentation("\r\n");
                    HttpHeadersExImpl httpHeadersExImpl = HttpHeadersExImpl.buildFromString(string19);
                    String string21 = httpHeadersExImpl.getStringRepresentation("\r\n");
                    HeadersReceivedParams headersReceivedParams = new HeadersReceivedParams(l5, string, string14, n2, string15, string16, new StatusLine(string17, n3, string18), httpHeadersImpl, httpHeadersExImpl);
                    ((a)object).NetworkService.this.g.onHeadersReceived(headersReceivedParams);
                    string16 = httpHeadersImpl.getStringRepresentation("\r\n");
                    if (!string20.equals(string16)) {
                        onHeadersReceivedMessage.setOverrideHeaders(string16);
                    }
                    if (string21.equals(object = httpHeadersExImpl.getStringRepresentation("\r\n"))) return;
                    onHeadersReceivedMessage.setOverrideHeaders((String)object);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onHeadersReceived() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnBeforeRedirect) {
                OnBeforeRedirectMessage onBeforeRedirectMessage = (OnBeforeRedirectMessage)object;
                object = this;
                if (onBeforeRedirectMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.g == null) return;
                try {
                    String string = onBeforeRedirectMessage.getURL();
                    String string22 = onBeforeRedirectMessage.getMethod();
                    long l6 = onBeforeRedirectMessage.getRequestId();
                    int n4 = onBeforeRedirectMessage.getResponseCode();
                    String string23 = onBeforeRedirectMessage.getNewLocation();
                    BeforeRedirectParams beforeRedirectParams = new BeforeRedirectParams(l6, string, string22, n4, string23);
                    ((a)object).NetworkService.this.g.onBeforeRedirect(beforeRedirectParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onBeforeRedirect() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnResponseStarted) {
                OnResponseStartedMessage onResponseStartedMessage = (OnResponseStartedMessage)object;
                object = this;
                if (onResponseStartedMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.g == null) return;
                try {
                    String string = onResponseStartedMessage.getURL();
                    String string24 = onResponseStartedMessage.getMethod();
                    long l7 = onResponseStartedMessage.getRequestId();
                    int n5 = onResponseStartedMessage.getResponseCode();
                    ResponseStartedParams responseStartedParams = new ResponseStartedParams(l7, string, string24, n5);
                    ((a)object).NetworkService.this.g.onResponseStarted(responseStartedParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onResponseStarted() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnCompleted) {
                OnCompletedMessage onCompletedMessage = (OnCompletedMessage)object;
                object = this;
                if (onCompletedMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.g == null) return;
                try {
                    RequestStatus requestStatus = RequestStatus.valueOf(onCompletedMessage.getStatus());
                    NetError netError = NetError.valueOf(onCompletedMessage.getErrorCode());
                    if (netError == NetError.UNKNOWN) {
                        netError = null;
                    }
                    String string = onCompletedMessage.getURL();
                    String string25 = onCompletedMessage.getMethod();
                    long l8 = onCompletedMessage.getRequestId();
                    int n6 = onCompletedMessage.getResponseCode();
                    RequestCompletedParams requestCompletedParams = new RequestCompletedParams(l8, string, string25, n6, requestStatus, netError);
                    ((a)object).NetworkService.this.g.onCompleted(requestCompletedParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onCompleted() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnRequestDestroyed) {
                OnRequestDestroyedMessage onRequestDestroyedMessage = (OnRequestDestroyedMessage)object;
                object = this;
                if (onRequestDestroyedMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.g == null) return;
                try {
                    String string = onRequestDestroyedMessage.getURL();
                    String string26 = onRequestDestroyedMessage.getMethod();
                    long l9 = onRequestDestroyedMessage.getRequestId();
                    RequestParams requestParams = new RequestParams(l9, string, string26);
                    ((a)object).NetworkService.this.g.onDestroyed(requestParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onCompleted() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnPACScriptError) {
                OnPACScriptErrorMessage onPACScriptErrorMessage = (OnPACScriptErrorMessage)object;
                object = this;
                if (onPACScriptErrorMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.g == null) return;
                try {
                    String string = onPACScriptErrorMessage.getErrorText();
                    int n7 = onPACScriptErrorMessage.getLineNumber();
                    ((a)object).NetworkService.this.g.onPACScriptError(new PACScriptErrorParams(n7, string));
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onPACScriptError() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnRunAuthDialog) {
                OnRunAuthDialogMessage onRunAuthDialogMessage = (OnRunAuthDialogMessage)object;
                object = this;
                if (onRunAuthDialogMessage.getBrowserContextId() != ((a)object).NetworkService.this.b) return;
                if (((a)object).NetworkService.this.g == null) {
                    ((a)object).NetworkService.this.e.send(new CloseAuthDialogMessage(MessageUIDGenerator.generate(), ((a)object).NetworkService.this.b, onRunAuthDialogMessage.getDialogID(), false, "", ""));
                    return;
                }
                ((a)object).NetworkService.this.c.invokeLater(new am((a)object, onRunAuthDialogMessage));
                return;
            }
            if (messageType == MessageType.OnCanGetCookies) {
                OnCanGetCookiesMessage onCanGetCookiesMessage = (OnCanGetCookiesMessage)object;
                object = this;
                if (onCanGetCookiesMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.g == null) return;
                String string = onCanGetCookiesMessage.getURL();
                List<Cookie> list = CookieParser.parseCookiesString(onCanGetCookiesMessage.getCookies());
                try {
                    onCanGetCookiesMessage.setCanGetCookies(((a)object).NetworkService.this.g.onCanGetCookies(string, list));
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The DialogHandler.onCanGetCookies() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnCanSetCookies) {
                OnCanSetCookiesMessage onCanSetCookiesMessage = (OnCanSetCookiesMessage)object;
                object = this;
                if (onCanSetCookiesMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.g == null) return;
                String string = onCanSetCookiesMessage.getURL();
                List<Cookie> list = CookieParser.parseCookiesString(onCanSetCookiesMessage.getCookies());
                try {
                    onCanSetCookiesMessage.setCanSetCookies(((a)object).NetworkService.this.g.onCanSetCookies(string, list));
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The DialogHandler.onCanSetCookies() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnShouldBeginRequest) {
                OnShouldBeginRequestMessage onShouldBeginRequestMessage = (OnShouldBeginRequestMessage)object;
                object = this;
                if (onShouldBeginRequestMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.f == null) return;
                String string = onShouldBeginRequestMessage.getURL();
                String string27 = onShouldBeginRequestMessage.getMethod();
                ResourceType resourceType = ResourceType.valueOf(onShouldBeginRequestMessage.getResourceType());
                try {
                    onShouldBeginRequestMessage.setCancel(!((a)object).NetworkService.this.f.canLoadResource(new ResourceParams(string, string27, resourceType)));
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The ResourceHandler.canLoadResource() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnBeforeSendProxyHeaders) {
                OnBeforeSendProxyHeadersMessage onBeforeSendProxyHeadersMessage = (OnBeforeSendProxyHeadersMessage)object;
                object = this;
                if (onBeforeSendProxyHeadersMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.g == null) return;
                try {
                    String string = onBeforeSendProxyHeadersMessage.getURL();
                    String string28 = onBeforeSendProxyHeadersMessage.getMethod();
                    long l10 = onBeforeSendProxyHeadersMessage.getRequestId();
                    String string29 = onBeforeSendProxyHeadersMessage.getOriginalHeaders();
                    boolean bl = onBeforeSendProxyHeadersMessage.isDidProxyBypass();
                    boolean bl2 = onBeforeSendProxyHeadersMessage.isDidUsePacScript();
                    String string30 = onBeforeSendProxyHeadersMessage.getHost();
                    int n8 = onBeforeSendProxyHeadersMessage.getPort();
                    int n9 = onBeforeSendProxyHeadersMessage.getSchema();
                    ProxyType proxyType = ProxyType.from(n9);
                    HostPortPair hostPortPair = new HostPortPair(string30, n8);
                    HttpHeadersImpl httpHeadersImpl = HttpHeadersImpl.buildFromString(string29);
                    String string31 = httpHeadersImpl.getStringRepresentation("\r\n");
                    HttpHeadersExImpl httpHeadersExImpl = HttpHeadersExImpl.buildFromString(string29);
                    string29 = httpHeadersExImpl.getStringRepresentation("\r\n");
                    BeforeSendProxyHeadersParams beforeSendProxyHeadersParams = new BeforeSendProxyHeadersParams(l10, string, string28, httpHeadersImpl, httpHeadersExImpl, bl, bl2, proxyType, hostPortPair);
                    ((a)object).NetworkService.this.g.onBeforeSendProxyHeaders(beforeSendProxyHeadersParams);
                    object = httpHeadersImpl.getStringRepresentation("\r\n");
                    if (!string31.equals(object)) {
                        onBeforeSendProxyHeadersMessage.setOverrideHeaders((String)object);
                    }
                    if (string29.equals(object = httpHeadersExImpl.getStringRepresentation("\r\n"))) return;
                    onBeforeSendProxyHeadersMessage.setOverrideHeaders((String)object);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onBeforeSendProxyHeaders() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnVerifyCert) {
                OnVerifyCertMessage onVerifyCertMessage = (OnVerifyCertMessage)object;
                object = this;
                if (((a)object).NetworkService.this.h == null) return;
                Certificate certificate = CertificateFactory.certificateFromString(onVerifyCertMessage.getCertData());
                EnumSet<CertificateVerifyFlag> enumSet = EnumSet.noneOf(CertificateVerifyFlag.class);
                int n10 = onVerifyCertMessage.getResultFlags();
                if ((n10 & 1) != 0) {
                    enumSet.add(CertificateVerifyFlag.COMMON_NAME_INVALID);
                }
                if ((n10 & 2) != 0) {
                    enumSet.add(CertificateVerifyFlag.DATE_INVALID);
                }
                if ((n10 & 4) != 0) {
                    enumSet.add(CertificateVerifyFlag.AUTHORITY_INVALID);
                }
                if ((n10 & 0x10) != 0) {
                    enumSet.add(CertificateVerifyFlag.NO_REVOCATION_MECHANISM);
                }
                if ((n10 & 0x20) != 0) {
                    enumSet.add(CertificateVerifyFlag.UNABLE_TO_CHECK_REVOCATION);
                }
                if ((n10 & 0x40) != 0) {
                    enumSet.add(CertificateVerifyFlag.REVOKED);
                }
                if ((n10 & 0x80) != 0) {
                    enumSet.add(CertificateVerifyFlag.INVALID);
                }
                if ((n10 & 0x100) != 0) {
                    enumSet.add(CertificateVerifyFlag.WEAK_SIGNATURE_ALGORITHM);
                }
                if ((n10 & 0x400) != 0) {
                    enumSet.add(CertificateVerifyFlag.NON_UNIQUE_NAME);
                }
                if ((n10 & 0x800) != 0) {
                    enumSet.add(CertificateVerifyFlag.WEAK_KEY);
                }
                if ((n10 & 0x2000) != 0) {
                    enumSet.add(CertificateVerifyFlag.PINNED_KEY_MISSING);
                }
                if ((n10 & 0x4000) != 0) {
                    enumSet.add(CertificateVerifyFlag.NAME_CONSTRAINT_VIOLATION);
                }
                if ((n10 & 0x8000) != 0) {
                    enumSet.add(CertificateVerifyFlag.VALIDITY_TOO_LONG);
                }
                if ((n10 & 0x10000) != 0) {
                    enumSet.add(CertificateVerifyFlag.IS_EV);
                }
                if ((n10 & 0x20000) != 0) {
                    enumSet.add(CertificateVerifyFlag.REV_CHECKING_ENABLED);
                }
                if ((n10 & 0x80000) != 0) {
                    enumSet.add(CertificateVerifyFlag.SHA1_SIGNATURE_PRESENT);
                }
                String string = onVerifyCertMessage.getHostName();
                CertificateVerifyParams certificateVerifyParams = new CertificateVerifyParams(string, certificate, enumSet);
                try {
                    CertificateVerifyResult certificateVerifyResult = ((a)object).NetworkService.this.h.verify(certificateVerifyParams);
                    if (certificateVerifyResult == CertificateVerifyResult.INVALID) {
                        onVerifyCertMessage.setResultCode(-207);
                        onVerifyCertMessage.setResultFlags(128);
                        return;
                    }
                    if (certificateVerifyResult != CertificateVerifyResult.OK) return;
                    onVerifyCertMessage.setResultCode(0);
                    onVerifyCertMessage.setResultFlags(0);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The CertificateVerifier.verify() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType != MessageType.OnReceivedData) return;
            OnDataReceivedMessage onDataReceivedMessage = (OnDataReceivedMessage)object;
            object = this;
            if (onDataReceivedMessage.getBrowserContextId() != ((a)object).NetworkService.this.b || ((a)object).NetworkService.this.g == null) return;
            try {
                String string = onDataReceivedMessage.getURL();
                String string32 = onDataReceivedMessage.getMethod();
                String string33 = onDataReceivedMessage.getCharset();
                String string34 = onDataReceivedMessage.getMimeType();
                long l11 = onDataReceivedMessage.getRequestId();
                byte[] byArray = onDataReceivedMessage.getData();
                DataReceivedParams dataReceivedParams = new DataReceivedParams(l11, string, string32, string33, string34, byArray);
                ((a)object).NetworkService.this.g.onDataReceived(dataReceivedParams);
                return;
            }
            catch (Exception exception) {
                a.log(Level.SEVERE, "The NetworkDelegate.onDataReceived() method has thrown exception: ", exception);
            }
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

