/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.WebStorage;
import com.teamdev.jxbrowser.chromium.internal.WebStorageType;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ClearWebStorageMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ContainsWebStorageKeyMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetWebStorageItemMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetWebStorageKeyMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetWebStorageLengthMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.RemoveWebStorageItemMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetWebStorageItemMessage;

public class ChannelWebStorage
implements WebStorage {
    private final long a;
    private final Channel b;
    private final WebStorageType c;

    public ChannelWebStorage(Channel channel, long l2, WebStorageType webStorageType) {
        this.b = channel;
        this.c = webStorageType;
        this.a = l2;
    }

    @Override
    public long length() {
        GetWebStorageLengthMessage getWebStorageLengthMessage = this.b.post(new GetWebStorageLengthMessage(MessageUIDGenerator.generate(), this.a, this.c));
        return getWebStorageLengthMessage.getLength();
    }

    @Override
    public String key(long l2) {
        if (l2 < 0L || l2 >= this.length()) {
            throw new IllegalArgumentException("The index must be in range: 0 < index < length.");
        }
        GetWebStorageKeyMessage getWebStorageKeyMessage = this.b.post(new GetWebStorageKeyMessage(MessageUIDGenerator.generate(), this.a, this.c, l2));
        if (!getWebStorageKeyMessage.isError()) {
            return getWebStorageKeyMessage.getKeyName();
        }
        return null;
    }

    @Override
    public String getItem(String object) {
        if (object == null) {
            throw new IllegalArgumentException("The key parameter cannot be null.");
        }
        object = this.b.post(new GetWebStorageItemMessage(MessageUIDGenerator.generate(), this.a, this.c, (String)object));
        if (!((GetWebStorageItemMessage)object).isError()) {
            return ((GetWebStorageItemMessage)object).getValue();
        }
        return null;
    }

    @Override
    public boolean setItem(String object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("The key parameter cannot be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The value parameter cannot be null.");
        }
        object = this.b.post(new SetWebStorageItemMessage(MessageUIDGenerator.generate(), this.a, this.c, (String)object, string));
        return !((SetWebStorageItemMessage)object).isError();
    }

    @Override
    public boolean removeItem(String object) {
        if (object == null) {
            throw new IllegalArgumentException("The key parameter cannot be null.");
        }
        object = this.b.post(new RemoveWebStorageItemMessage(MessageUIDGenerator.generate(), this.a, this.c, (String)object));
        return !((RemoveWebStorageItemMessage)object).isError();
    }

    @Override
    public boolean clear() {
        ClearWebStorageMessage clearWebStorageMessage = this.b.post(new ClearWebStorageMessage(MessageUIDGenerator.generate(), this.a, this.c));
        return !clearWebStorageMessage.isError();
    }

    @Override
    public boolean contains(String object) {
        if (object == null) {
            throw new IllegalArgumentException("The key parameter cannot be null.");
        }
        object = this.b.post(new ContainsWebStorageKeyMessage(MessageUIDGenerator.generate(), this.a, this.c, (String)object));
        return ((ContainsWebStorageKeyMessage)object).contains();
    }
}

