/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.r;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.logging.Logger;

public final class FileUtil {
    private static final Logger a = LoggerProvider.getBrowserLogger();

    public static void createDirs(File file) {
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Failed to create directory: " + file.getPath());
        }
    }

    public static void createDirs(String object) {
        if (!((File)(object = new File((String)object))).exists() && !((File)object).mkdirs()) {
            throw new RuntimeException("Failed to create directory: " + ((File)object).getPath());
        }
    }

    public static boolean createFile(File file) {
        try {
            return file.createNewFile();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean copyFile(File file, File file2) {
        if (file2.exists() || !file2.createNewFile()) {
            return false;
        }
        FileChannel fileChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            fileChannel = new FileInputStream(file).getChannel();
            abstractInterruptibleChannel = new FileOutputStream(file2).getChannel();
            ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, fileChannel.size());
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
        }
        return true;
    }

    public static void deleteDir(File file) {
        if (!file.isDirectory()) {
            if (!file.delete()) {
                file.deleteOnExit();
                return;
            }
        } else {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    FileUtil.deleteDir(file2);
                }
            }
            FileUtil.deleteFile(file);
        }
    }

    public static void deleteFile(File file) {
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public static boolean allFilesExist(File file, String ... stringArray) {
        for (String string : stringArray) {
            File object = new File(file, string);
            if (object.exists()) continue;
            a.info("The '" + object.getAbsolutePath() + "' file doesn't exist.");
            return false;
        }
        return true;
    }

    public static File createTempDir(String object) {
        try {
            object = File.createTempFile((String)object, Long.toString(System.nanoTime()));
            if (!((File)object).delete()) {
                throw new IllegalStateException("Failed to delete temp file: " + ((File)object).getAbsolutePath());
            }
            if (!((File)object).mkdir()) {
                throw new IllegalStateException("Failed to create temp dir: " + ((File)object).getAbsolutePath());
            }
            return object;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static File findByTemplate(String fileArray, String string) {
        if ((fileArray = new File((String)fileArray)).isDirectory() && (fileArray = fileArray.listFiles(new r(string))) != null && fileArray.length > 0) {
            return fileArray[0];
        }
        return null;
    }

    public static String getFileName(File object) {
        int n2 = ((String)(object = ((File)object).getName())).lastIndexOf(46);
        if (n2 != -1) {
            return ((String)object).substring(0, n2);
        }
        return object;
    }

    public static String getFileExtension(File object, boolean bl) {
        int n2 = ((String)(object = ((File)object).getName())).lastIndexOf(46);
        if (n2 != -1) {
            return ((String)object).substring(bl ? n2 : n2 + 1);
        }
        return "";
    }

    public static void validateDirectory(String object) {
        if (((String)object).isEmpty()) {
            throw new IOException("The path to the directory is empty.");
        }
        if (!((File)(object = new File((String)object))).exists() && !((File)object).mkdirs()) {
            throw new IOException("The directory " + ((File)object).getAbsolutePath() + " does not exist and cannot be created.");
        }
        if (!((File)object).isDirectory()) {
            throw new IOException("The path " + ((File)object).getAbsolutePath() + " does not refer to a directory.");
        }
        if (!FileUtil.canWriteToDirectory(((File)object).getAbsolutePath())) {
            throw new IOException("There is no write permission to the directory " + ((File)object).getAbsolutePath());
        }
    }

    public static boolean canWriteToDirectory(String object) {
        Long l2 = System.currentTimeMillis();
        object = (String)object + File.separator + "jxbrowser-test-file-" + l2;
        object = new File((String)object);
        try {
            new FileOutputStream((File)object, true).close();
            ((File)object).delete();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

