/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.HttpHeadersEx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class HttpHeadersExImpl
implements HttpHeadersEx {
    private static final Pattern a = Pattern.compile("\r\n");
    private final Map<String, LinkedList<String>> b = new TreeMap<String, LinkedList<String>>(String.CASE_INSENSITIVE_ORDER);

    @Override
    public void setHeader(String string, String string2) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Header name cannot be null or empty.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Header value cannot be null");
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string2);
        this.b.put(string, linkedList);
    }

    @Override
    public void setHeaders(String string, List<String> list) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Header name cannot be null or empty.");
        }
        if (list == null) {
            throw new IllegalArgumentException("The headerValues parameter cannot be null");
        }
        this.b.put(string, new LinkedList<String>(list));
    }

    @Override
    public List<String> removeHeader(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Header name cannot be null or empty.");
        }
        return this.b.remove(string);
    }

    @Override
    public void removeAll() {
        this.b.clear();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return new HashMap<String, List<String>>(this.b);
    }

    @Override
    public boolean containsHeader(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Header name cannot be null or empty.");
        }
        return this.b.containsKey(string);
    }

    @Override
    public String getHeader(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Header name cannot be null or empty.");
        }
        if (this.containsHeader(string)) {
            return this.b.get(string).getLast();
        }
        return null;
    }

    @Override
    public List<String> getHeaders(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Header name cannot be null or empty.");
        }
        if (this.containsHeader(string)) {
            return this.b.get(string);
        }
        return new ArrayList<String>();
    }

    public String getStringRepresentation(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, LinkedList<String>> entry : this.b.entrySet()) {
            for (String string2 : entry.getValue()) {
                stringBuilder.append(entry.getKey());
                stringBuilder.append(": ");
                stringBuilder.append(string2);
                stringBuilder.append(string);
            }
        }
        int n2 = stringBuilder.lastIndexOf(string);
        if (n2 != -1) {
            stringBuilder.delete(n2, n2 + string.length());
        }
        return stringBuilder.toString();
    }

    public static HttpHeadersExImpl buildFromString(String stringArray) {
        HttpHeadersExImpl httpHeadersExImpl = new HttpHeadersExImpl();
        String[] stringArray2 = a.split((CharSequence)stringArray);
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            String string = stringArray[i2];
            if (string.isEmpty() || (n3 = string.indexOf(58)) == -1) continue;
            String string2 = string.substring(0, n3);
            String string3 = string = n3 + 2 >= string.length() ? "" : string.substring(n3 + 2);
            if (!httpHeadersExImpl.containsHeader(string2)) {
                httpHeadersExImpl.setHeaders(string2, new ArrayList<String>());
            }
            List<String> list = httpHeadersExImpl.getHeaders(string2);
            list.add(string);
            httpHeadersExImpl.setHeaders(string2, list);
        }
        return httpHeadersExImpl;
    }
}

