/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.BytesData;
import com.teamdev.jxbrowser.chromium.FormData;
import com.teamdev.jxbrowser.chromium.MultipartFormData;
import com.teamdev.jxbrowser.chromium.TextData;
import com.teamdev.jxbrowser.chromium.UploadData;
import com.teamdev.jxbrowser.chromium.UploadDataType;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class UploadDataUtils {
    private static final int[] a = new int[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66};

    public static UploadDataType getDataTypeFromHeader(String string) {
        if (string == null) {
            return null;
        }
        if (string.contains("application/x-www-form-urlencoded")) {
            return UploadDataType.FORM_URL_ENCODED;
        }
        if (string.contains("multipart/form-data")) {
            return UploadDataType.MULTIPART_FORM_DATA;
        }
        if (string.contains("plain/text")) {
            return UploadDataType.PLAIN_TEXT;
        }
        return UploadDataType.BYTES;
    }

    public static String getBoundaryFromContentHeader(String string) {
        Object object = UploadDataUtils.getDataTypeFromHeader(string);
        if (object == UploadDataType.MULTIPART_FORM_DATA) {
            object = "boundary=";
            int n2 = string.indexOf((String)object) + ((String)object).length();
            return string.substring(n2);
        }
        return null;
    }

    public static boolean isKeyValuePairsEquals(Map<String, List<String>> object, Map<String, List<String>> map) {
        if (object.size() != map.size()) {
            return false;
        }
        for (Map.Entry object2 : object.entrySet()) {
            Object object3 = (String)object2.getKey();
            if (!map.containsKey(object3)) {
                return false;
            }
            List list = (List)object2.getValue();
            object3 = map.get(object3);
            boolean bl = list.containsAll((Collection<?>)object3);
            boolean bl2 = object3.containsAll(list);
            if (bl && bl2) continue;
            return false;
        }
        return true;
    }

    public static String generateUniqueBoundary() {
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("----WebKitFormBoundary");
        for (int i2 = 0; i2 < 16; ++i2) {
            int n2 = secureRandom.nextInt(64);
            stringBuilder.append((char)a[n2]);
        }
        return stringBuilder.toString();
    }

    public static void initializeFormData(FormData formData, Map<String, List<String>> object) {
        formData.removeAllPairs();
        for (Map.Entry entry : object.entrySet()) {
            List list = (List)entry.getValue();
            formData.setPair((String)entry.getKey(), list.toArray(new String[list.size()]));
        }
    }

    public static void initializeFormData(MultipartFormData multipartFormData, Map<String, List<String>> object, Map<String, List<String>> object22) {
        multipartFormData.removeAllFilePairs();
        UploadDataUtils.initializeFormData(multipartFormData, (Map<String, List<String>>)((Object)object));
        for (Map.Entry entry : object22.entrySet()) {
            List list = (List)entry.getValue();
            multipartFormData.setFilePair((String)entry.getKey(), list.toArray(new String[list.size()]));
        }
    }

    public static Map<String, List<String>> buildKeyValuesMap(FormData formData) {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>();
        Object object = formData.getPairKeys();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            treeMap.put(string, new ArrayList<String>(formData.getPairValues(string)));
        }
        return treeMap;
    }

    public static Map<String, List<String>> buildFilesMap(MultipartFormData multipartFormData) {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>();
        Object object = multipartFormData.getFileKeys();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            treeMap.put(string, new ArrayList<String>(multipartFormData.getFiles(string)));
        }
        return treeMap;
    }

    public static UploadData copy(UploadData uploadData) {
        if (uploadData instanceof MultipartFormData) {
            MultipartFormData multipartFormData = new MultipartFormData();
            UploadDataUtils.initializeFormData(multipartFormData, UploadDataUtils.buildKeyValuesMap((MultipartFormData)uploadData), UploadDataUtils.buildFilesMap((MultipartFormData)uploadData));
            return multipartFormData;
        }
        if (uploadData instanceof FormData) {
            FormData formData = new FormData();
            UploadDataUtils.initializeFormData(formData, UploadDataUtils.buildKeyValuesMap((FormData)uploadData));
            return formData;
        }
        if (uploadData instanceof TextData) {
            return new TextData(((TextData)uploadData).getText());
        }
        if (uploadData instanceof BytesData) {
            return new BytesData(((BytesData)uploadData).getData());
        }
        return null;
    }
}

