/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ChromiumLocale;
import com.teamdev.jxbrowser.chromium.internal.ChromiumLocaleFactory;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import com.teamdev.jxbrowser.chromium.internal.SharedMemoryLibrary;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChromiumProcessListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ChromiumProcess {
    private static final Logger a = LoggerProvider.getChromiumProcessLogger();
    private final File b;
    private final List<ChromiumProcessListener> c;

    protected ChromiumProcess(String string) {
        this.b = new File(string);
        this.c = new CopyOnWriteArrayList<ChromiumProcessListener>();
    }

    public String getWorkingDir() {
        return this.b.getAbsolutePath();
    }

    public void addChromiumProcessListener(ChromiumProcessListener chromiumProcessListener) {
        if (!this.c.contains(chromiumProcessListener)) {
            this.c.add(chromiumProcessListener);
        }
    }

    public void removeChromiumProcessListener(ChromiumProcessListener chromiumProcessListener) {
        this.c.remove(chromiumProcessListener);
    }

    public List<ChromiumProcessListener> getChromiumProcessListeners() {
        return new ArrayList<ChromiumProcessListener>(this.c);
    }

    public int start(int n2) {
        Object object;
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("--port=" + n2);
        arrayList.add("--pid=" + SharedMemoryLibrary.getInstance().getCurrentProcessId());
        if (Environment.isWindows() && !(string = ChromiumProcess.a()).isEmpty()) {
            arrayList.add("--crash-dump-dir=" + string);
        }
        if ((object = BrowserPreferences.getUserAgent()) != null && !((String)object).isEmpty()) {
            arrayList.add("--user-agent=" + (String)object);
        }
        this.a(arrayList);
        if (Environment.isMac()) {
            arrayList.add("--disable-remote-core-animation");
        }
        arrayList.add("--disable-surfaces");
        object = System.getProperty("jxbrowser.chromium.switches");
        if (object != null) {
            object = new StringTokenizer((String)object, " ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
        }
        object = BrowserPreferences.getChromiumSwitches();
        arrayList.addAll((Collection<String>)object);
        int n3 = this.doStart(arrayList);
        a.info("Chromium process exit code " + n3);
        for (ChromiumProcessListener chromiumProcessListener : this.getChromiumProcessListeners()) {
            chromiumProcessListener.onExit(n3);
        }
        return n3;
    }

    private static String a() {
        String string;
        string = System.getProperty("jxbrowser.dmp.dir", Environment.isWindowsXP() || Environment.isWindowsServer2003() ? ((string = System.getProperty("user.home", "")) != null ? string + "\\Local Settings\\Application Data\\JxBrowser" : "") : ((string = System.getenv("LOCALAPPDATA")) != null ? string + "\\JxBrowser" : ""));
        try {
            FileUtil.validateDirectory(string);
        }
        catch (IOException iOException) {
            a.log(Level.WARNING, "Failed to access dump folder: " + iOException.getMessage());
            return "";
        }
        return string;
    }

    private void a(List<String> object) {
        String string;
        Object object2 = ChromiumLocaleFactory.create(this.getWorkingDir());
        Object object3 = ((ChromiumLocale)object2).getSupportedLanguages();
        Object object4 = BrowserPreferences.getChromiumSwitches().iterator();
        while (object4.hasNext()) {
            string = object4.next();
            if (!string.startsWith("--lang=")) continue;
            object4 = string.substring(7);
            if (!object3.contains(((String)object4).toLowerCase())) {
                object2 = new StringBuilder();
                object = object3.iterator();
                while (object.hasNext()) {
                    object3 = (String)object.next();
                    ((StringBuilder)object2).append((String)object3);
                    if (!object.hasNext()) continue;
                    ((StringBuilder)object2).append(", ");
                }
                throw new IllegalArgumentException("The '" + string + "' Chromium switcher contains unsupported language value. Use one of the following language values: " + object2 + '.');
            }
            return;
        }
        object4 = Locale.getDefault();
        string = ((Locale)object4).getLanguage();
        if ((object2 = ((ChromiumLocale)object2).findSupportedLanguage(string, (String)(object4 = ((Locale)object4).getCountry()))) != null) {
            object.add((String)("--lang=" + (String)object2));
        }
    }

    protected abstract int doStart(List<String> var1);

    public abstract boolean isStarted();
}

